from calibre.web.feeds.recipes import BasicNewsRecipe
from calibre.ebooks.BeautifulSoup import BeautifulSoup
#from random import randint
from urllib import quote

class SportsIllustratedRecipe(BasicNewsRecipe) :
    __author__  = 'kwetal'
    __license__ = 'GPL v3'
    language = 'en_US'
    description = 'Sports Illustrated'
    version = 2
    title = u'Sports Illustrated'
    
    no_stylesheets = True
    remove_javascript = True
    #template_css = ''
    use_embedded_content   = False
    
    INDEX = 'http://sportsillustrated.cnn.com/'

    def parse_index(self):
        answer = []
        soup = self.index_to_soup(self.INDEX)
        # Find the link to the current issue on the front page.
        cover = soup.find('img', attrs = {'alt' : 'Read All Articles', 'style' : 'vertical-align:bottom;'})
        if cover:
            currentIssue = cover.parent['href']
            if currentIssue:
                # Open the index of current issue
                index = self.index_to_soup(currentIssue)
                
                # Now let us see if they updated their frontpage
                nav = index.find('div', attrs = {'class': 'siv_trav_top'})
                if nav:
                    img = nav.find('img', attrs = {'src': 'http://i.cdn.turner.com/sivault/.element/img/1.0/btn_next_v2.jpg'})
                    if img:
                        parent = img.parent
                        if parent.name == 'a':
                            # They didn't update their frontpage: lazy bastards. But we use the new issue anyway
                            href = self.INDEX + parent['href']
                            index = self.index_to_soup(href)
                 
                # Find all articles.
                list = index.find('div', attrs = {'class' : 'siv_artList'}) 
                if list:
                    articles = []
                    # Get all the artcles ready for calibre.
                    for headline in list.findAll('div', attrs = {'class' : 'headline'}):
                        title = self.tag_to_string(headline.a) + '\n' + self.tag_to_string(headline.findNextSibling('div', attrs = {'class' : 'info'}))
                        url = self.INDEX + headline.a['href']
                        description = self.tag_to_string(headline.findNextSibling('a').div)
                        article = {'title' : title, 'date' : u'', 'url'  : url, 'description' : description}
                         
                        articles.append(article)
                    
                    # See if we can find a meaningfull title
                    feedTitle = 'Current Issue'
                    hasTitle = index.find('div', attrs = {'class' : 'siv_imageText_head'})
                    if hasTitle :
                        feedTitle = self.tag_to_string(hasTitle.h1)
                    
                    answer.append([feedTitle, articles])

        return answer
        
        
    def print_version(self, url) :
        # This is the url and the parameters that work to get the print version.
        printUrl = 'http://si.printthis.clickability.com/pt/printThis?clickMap=printThis'
        printUrl += '&fb=Y&partnerID=2356&url=' + quote(url)

        return printUrl
        
        # However the original javascript also uses the following parameters, but they can be left out:
        #   title : can be some random string
        #   random : some random number, but I think the number of digits is important
        #   expire : no idea what value to use
        # All this comes from the Javascript function that redirects to the print version. It's called PT() and is defined in the file 48.js

    def preprocess_html(self, soup):
        header = soup.find('div', attrs = {'class' : 'siv_artheader'}) 
        if header:
            # It's an article, prepare a container for the content
            homeMadeSoup = BeautifulSoup('<html><head></head><body></body></html>')
            body = homeMadeSoup.find('body')
            
            # Find the date, title and byline
            temp = header.find('td', attrs = {'class' : 'title'})
            if temp :
                date = temp.find('div', attrs = {'class' : 'date'})
                if date:
                    body.append(date)
                if temp.h1:
                    body.append(temp.h1)
                if temp.h2 :
                    body.append(temp.h2)
                byline = temp.find('div', attrs = {'class' : 'byline'})
                if byline:
                    body.append(byline)
            
            # Find the content
            for para in soup.findAll('div', attrs = {'class' : 'siv_artpara'}) :
                body.append(para)
                
            return homeMadeSoup
        else :
            # It's a TOC, just return the whole lot
            return soup

