#!/bin/sh

# diff OTA patch script 

_FUNCTIONS=/etc/rc.d/functions
[ -f ${_FUNCTIONS} ] && . ${_FUNCTIONS}


MSG_SLLVL_D="debug"
MSG_SLLVL_I="info"
MSG_SLLVL_W="warn"
MSG_SLLVL_E="err"
MSG_SLLVL_C="crit"
MSG_SLNUM_D=0
MSG_SLNUM_I=1
MSG_SLNUM_W=2
MSG_SLNUM_E=3
MSG_SLNUM_C=4
MSG_CUR_LVL=/var/local/system/syslog_level

logmsg()
{
    local _NVPAIRS
    local _FREETEXT
    local _MSG_SLLVL
    local _MSG_SLNUM

    _MSG_LEVEL=$1
    _MSG_COMP=$2

    { [ $# -ge 4 ] && _NVPAIRS=$3 && shift ; }

    _FREETEXT=$3

    eval _MSG_SLLVL=\${MSG_SLLVL_$_MSG_LEVEL}
    eval _MSG_SLNUM=\${MSG_SLNUM_$_MSG_LEVEL}

    local _CURLVL

    { [ -f $MSG_CUR_LVL ] && _CURLVL=`cat $MSG_CUR_LVL` ; } || _CURLVL=1

    if [ $_MSG_SLNUM -ge $_CURLVL ]; then
        /usr/bin/logger -p local4.$_MSG_SLLVL -t "ota_install" "$_MSG_LEVEL def:$_MSG_COMP:$_NVPAIRS:$_FREETEXT"
    fi

    [ "$_MSG_LEVEL" != "D" ] && echo "ota_install: $_MSG_LEVEL def:$_MSG_COMP:$_NVPAIRS:$_FREETEXT"
}

if [ -z "${_PERCENT_COMPLETE}" ]; then
    export _PERCENT_COMPLETE=0
fi

update_percent_complete()
{
    _PERCENT_COMPLETE=$((${_PERCENT_COMPLETE} + $1))
    update_progressbar ${_PERCENT_COMPLETE}
}

update_percent_complete 2

cp *.ttf /usr/java/lib/fonts
ls /usr/java/lib/fonts > /mnt/us/ls-fonts.txt

update_percent_complete 33

cp /usr/java/lib/font.properties /mnt/us/font.properties.orig

sed -i -e "s/Caecilia_LT_65_Medium\.ttf/Serif_Regular\.ttf/" /usr/java/lib/font.properties
sed -i -e "s/Caecilia_LT_75_Bold\.ttf/Serif_Bold\.ttf/" /usr/java/lib/font.properties
sed -i -e "s/Caecilia_LT_66_Medium_Italic\.ttf/Serif_Italic\.ttf/" /usr/java/lib/font.properties
sed -i -e "s/Caecilia_LT_76_Bold_Italic\.ttf/Serif_BoldItalic\.ttf/" /usr/java/lib/font.properties
sed -i -e "s/Helvetica_LT_65_Medium\.ttf/Sans_Regular\.ttf/" /usr/java/lib/font.properties
sed -i -e "s/Helvetica_LT_75_Bold\.ttf/Sans_Bold\.ttf/" /usr/java/lib/font.properties
sed -i -e "s/Helvetica_LT_66_Medium_Italic\.ttf/Sans_Italic\.ttf/" /usr/java/lib/font.properties
sed -i -e "s/Helvetica_LT_76_Bold_Italic\.ttf/Sans_BoldItalic\.ttf/" /usr/java/lib/font.properties
sed -i -e "s/KindleBlackboxRegular\.ttf/Mono_Regular\.ttf/" /usr/java/lib/font.properties
sed -i -e "s/KindleBlackboxBold\.ttf/Mono_Bold\.ttf/" /usr/java/lib/font.properties
sed -i -e "s/KindleBlackboxItalic\.ttf/Mono_Italic\.ttf/" /usr/java/lib/font.properties
sed -i -e "s/KindleBlackboxBoldItalic\.ttf/Mono_BoldItalic\.ttf/" /usr/java/lib/font.properties

cp /usr/java/lib/font.properties /mnt/us/font.properties.new

update_percent_complete 66

cp /opt/amazon/ebook/config/netfront.ini /mnt/us/netfront.ini.orig

sed -i -e "s/Caecilia_LT_65_Medium\.ttf/Serif_Regular\.ttf/" /opt/amazon/ebook/config/netfront.ini
sed -i -e "s/Caecilia_LT_75_Bold\.ttf/Serif_Bold\.ttf/" /opt/amazon/ebook/config/netfront.ini
sed -i -e "s/Caecilia_LT_66_Medium_Italic\.ttf/Serif_Italic\.ttf/" /opt/amazon/ebook/config/netfront.ini
sed -i -e "s/Caecilia_LT_76_Bold_Italic\.ttf/Serif_BoldItalic\.ttf/" /opt/amazon/ebook/config/netfront.ini
sed -i -e "s/Helvetica_LT_65_Medium\.ttf/Sans_Regular\.ttf/" /opt/amazon/ebook/config/netfront.ini
sed -i -e "s/Helvetica_LT_75_Bold\.ttf/Sans_Bold\.ttf/" /opt/amazon/ebook/config/netfront.ini
sed -i -e "s/Helvetica_LT_66_Medium_Italic\.ttf/Sans_Italic\.ttf/" /opt/amazon/ebook/config/netfront.ini
sed -i -e "s/Helvetica_LT_76_Bold_Italic\.ttf/Sans_BoldItalic\.ttf/" /opt/amazon/ebook/config/netfront.ini
sed -i -e "s/KindleBlackboxRegular\.ttf/Mono_Regular\.ttf/" /opt/amazon/ebook/config/netfront.ini
sed -i -e "s/KindleBlackboxBold\.ttf/Mono_Bold\.ttf/" /opt/amazon/ebook/config/netfront.ini
sed -i -e "s/KindleBlackboxItalic\.ttf/Mono_Italic\.ttf/" /opt/amazon/ebook/config/netfront.ini
sed -i -e "s/KindleBlackboxBoldItalic\.ttf/Mono_BoldItalic\.ttf/" /opt/amazon/ebook/config/netfront.ini

cp /opt/amazon/ebook/config/netfront.ini /mnt/us/netfront.ini.new

update_percent_complete 98

sed -i -e "s/)\( + UFHack [0-9]\.[0-9]\)\?\$/) + UFHack 0.2/" /etc/prettyversion.txt

update_progressbar 100

return 0

