----------------------------------------------------------------------
-- about: show about information
--
-- Copyright (C) 2009  Iñigo Serna <inigoserna@gmail.com>
-- Time-stamp: <2009-11-22 21:44:48 inigo>


----------------------------------------------------------------------
-- window
local win = gtk.Window.new()
win:set("title", "About Iliad Toolbox", "border-width", 20)
win:connect("delete-event", gtk.main_quit)

-- header: title and quit button
local hbox = gtk.HBox.new(false, 10)
local evbox = gtk.EventBox.new()
evbox:modify_bg(gtk.STATE_NORMAL, gdk.color_parse("black"))
local title = gtk.Label.new()
title:set_markup("<span size='xx-large' color='white' weight='bold'>About</span>")
evbox:add(title)
hbox:pack_start(evbox, true, true, 0)

local btn_quit = gtk.Button.new()
local img = gtk.Image.new_from_file("_files/data/quit.png")
btn_quit:connect("clicked", function () win:hide(); win:destroy() end)
btn_quit:add(img)
hbox:pack_end(btn_quit, false, false, 0)

-- text
local text = gtk.Label.new()
local buf = "\n<span size='xx-large'>Iliad Toolbox</span>\n\n\n" ..
      "<b>Some tools for you Iliad ebook reader.</b>\n\n" ..
      "(C) 2009, Iñigo Serna &lt;inigoserna@gmail.com&gt;\n" ..
      "Licensed under GPL 3 or later.\n\n" ..
      "This program is written in Lua language, and uses lgob\n" ..
      "- a Lua binding for GTK -. Display refresh is handled by\n" ..
      "Hansel's <i>xx</i>, a small program based on Antartica's <i>xepdmgr</i>.\n" ..
      "Icons come from BlackSecret theme.\n\n" ..
      "Special thanks to Hansel, Ericshliao, Antartica, jharker, Adam B.\n" ..
      "and all the people on <i>http://www.mobileread.com</i>.\n\n"
text:set_markup(buf)

-- footer
local img = gtk.Image.new_from_file("_files/data/bar.png")

-- widgets packaging
local vbox = gtk.VBox.new(false, 20)
vbox:pack_start(hbox, false, false, 10)
vbox:pack_start(text, false, false, 10)
vbox:pack_start(gtk.Label.new(" "), true, true, 10)
vbox:pack_start(img, false, false, 10)
win:add(vbox)

-- show window
win:fullscreen()
win:show_all()


----------------------------------------------------------------------
