#!/usr/local/bin/lua

--
-- Copyright (C) 2009  Iñigo Serna <inigoserna@gmail.com>
-- Time-stamp: <2009-11-22 14:19:51 inigo>
-- 
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--


require("lgob.gtk")
require("lgob.gdk")
require("lgob.pango")


----------------------------------------------------------------------
local win = gtk.Window.new()
win:set("title", "Iliad Toolbox", "border-width", 20)
win:connect("delete-event", gtk.main_quit)

-- header: title and quit button
local hbox = gtk.HBox.new(false, 10)
local evbox = gtk.EventBox.new()
evbox:modify_bg(gtk.STATE_NORMAL, gdk.color_parse("black"))
local title = gtk.Label.new()
title:set_markup("<span size='xx-large' color='white' weight='bold'>Iliad Toolbox</span>")
evbox:add(title)
hbox:pack_start(evbox, true, true, 0)

local btn_quit = gtk.Button.new()
local img = gtk.Image.new_from_file("_files/data/quit.png")
btn_quit:add(img)
btn_quit:connect("clicked", gtk.main_quit)
hbox:pack_start(btn_quit, false, false, 0)

-- body
local data, evboxi, hboxi, imgi, lbli
data = { {"sysinfo","System Information", "Show Iliad system information"},
         -- {"netinfo", "Network Information", "Show network info. Start/stop network and SSH server"},
         {"filebrowser", "File Explorer", "Browse the contents of your Iliad"},
         {"recentfiles", "Recent Files", "Clean your recent files list"},
         {"sysoperations", "System Operations", "Reboot or shutdown the device"},
         {"help", "Help", "Read the documentation of Iliad Toolbox"},
         {"about", "About", "About Iliad Toolbox"} }
local vbox2 = gtk.VBox.new(false, 15)
for i, val in pairs(data) do
   evboxi = gtk.EventBox.new()
   evboxi:modify_bg(gtk.STATE_NORMAL, gdk.color_parse("gray60"))
   evboxi:set_events(gdk.BUTTON_PRESS_MASK)
   evboxi:connect("button_press_event", function() dofile("_files/modules/"..val[1]..".lua") end)
   hboxi = gtk.HBox.new(false, 20)
   imgi = gtk.Image.new_from_file("_files/data/"..val[1]..".png")
   hboxi:pack_start(imgi, false, false, 5)
   lbli = gtk.Label.new()
   buf = string.format("<span size='x-large'>%s</span>\n<i>%s</i>", val[2], val[3])
   lbli:set("xalign", 0)
   lbli:set_markup(buf)
   hboxi:pack_start(lbli, true, true, 0)
   evboxi:add(hboxi)
   vbox2:pack_start(evboxi, false, false, 0)
end

-- footer
local img = gtk.Image.new_from_file("_files/data/bar.png")

-- widgets packaging
local vbox = gtk.VBox.new(false, 20)
vbox:pack_start(hbox, false, false, 10)
vbox:pack_start(vbox2, false, false, 0)
vbox:pack_start(gtk.Label.new(" "), true, true, 10)
vbox:pack_start(img, false, false, 10)
win:add(vbox)

-- show and run
win:fullscreen()
win:show_all()
gtk.main()


----------------------------------------------------------------------
