// Copyright 2007, Kaboodle, Inc.

/* grab_xlib.js compiled from X 4.0 with XC 0.27b. Distributed by GNU LGPL. For copyrights, license, documentation and more visit Cross-Browser.com */
var xOp7Up,xOp6Dn,xIE4Up,xIE4,xIE5,xNN4,xUA=navigator.userAgent.toLowerCase();if(window.opera){var i=xUA.indexOf('opera');if(i!=-1){var v=parseInt(xUA.charAt(i+6));xOp7Up=v>=7;xOp6Dn=v<7;}}else if(navigator.vendor!='KDE' && document.all && xUA.indexOf('msie')!=-1){xIE4Up=parseFloat(navigator.appVersion)>=4;xIE4=xUA.indexOf('msie 4')!=-1;xIE5=xUA.indexOf('msie 5')!=-1;}else if(document.layers){xNN4=true;}xMac=xUA.indexOf('mac')!=-1;function xCardinalPosition(e, cp, margin, outside){if(!(e=xGetElementById(e))) return;if (typeof(cp)!='string'){window.status='xCardinalPosition error: cp=' + cp + ', id=' + e.id; return;}var x=xLeft(e), y=xTop(e), w=xWidth(e), h=xHeight(e);var pw,ph,p = xParent(e);if (p == document || p.nodeName.toLowerCase() == 'html') {pw = xClientWidth(); ph = xClientHeight();}else {pw=xWidth(p); ph=xHeight(p);}var sx=xScrollLeft(p), sy=xScrollTop(p);var right=sx + pw, bottom=sy + ph;var cenLeft=sx + Math.floor((pw-w)/2), cenTop=sy + Math.floor((ph-h)/2);if (!margin) margin=0;else{if (outside) margin=-margin;sx +=margin; sy +=margin; right -=margin; bottom -=margin;}switch (cp.toLowerCase()){case 'n': x=cenLeft; if (outside) y=sy - h; else y=sy; break;case 'ne': if (outside){x=right; y=sy - h;}else{x=right - w; y=sy;}break;case 'e': y=cenTop; if (outside) x=right; else x=right - w; break;case 'se': if (outside){x=right; y=bottom;}else{x=right - w; y=bottom - h}break;case 's': x=cenLeft; if (outside) y=sy - h; else y=bottom - h; break;case 'sw': if (outside){x=sx - w; y=bottom;}else{x=sx; y=bottom - h;}break;case 'w': y=cenTop; if (outside) x=sx - w; else x=sx; break;case 'nw': if (outside){x=sx - w; y=sy - h;}else{x=sx; y=sy;}break;case 'cen': x=cenLeft; y=cenTop; break;case 'cenh': x=cenLeft; break;case 'cenv': y=cenTop; break;}var o = new Object();o.x = x; o.y = y;return o;}function xClientHeight(){var h=0;if(xOp6Dn) h=window.innerHeight;else if(document.compatMode == 'CSS1Compat' && !window.opera && document.documentElement && document.documentElement.clientHeight)h=document.documentElement.clientHeight;else if(document.body && document.body.clientHeight)h=document.body.clientHeight;else if(xDef(window.innerWidth,window.innerHeight,document.width)) {h=window.innerHeight;if(document.width>window.innerWidth) h-=16;}return h;}function xClientWidth(){var w=0;if(xOp6Dn) w=window.innerWidth;else if(document.compatMode == 'CSS1Compat' && !window.opera && document.documentElement && document.documentElement.clientWidth)w=document.documentElement.clientWidth;else if(document.body && document.body.clientWidth)w=document.body.clientWidth;else if(xDef(window.innerWidth,window.innerHeight,document.height)) {w=window.innerWidth;if(document.height>window.innerHeight) w-=16;}return w;}function xDef(){for(var i=0; i<arguments.length; ++i){if(typeof(arguments[i])=='undefined') return false;}return true;}function xGetComputedStyle(oEle, sProp, bInt){var s, p = 'undefined';var dv = document.defaultView;if(dv && dv.getComputedStyle){s = dv.getComputedStyle(oEle,'');if (s) p = s.getPropertyValue(sProp);}else if(oEle.currentStyle) {var a = sProp.split('-');sProp = a[0];for (var i=1; i<a.length; ++i) {c = a[i].charAt(0);sProp += a[i].replace(c, c.toUpperCase());}   p = oEle.currentStyle[sProp];}else return null;return bInt ? (parseInt(p) || 0) : p;}function xGetElementById(e){if(typeof(e)!='string') return e;if(document.getElementById) e=document.getElementById(e);else if(document.all) e=document.all[e];else e=null;return e;}function xHeight(e,h){if(!(e=xGetElementById(e))) return 0;if (xNum(h)) {if (h<0) h = 0;else h=Math.round(h);}else h=-1;var css=xDef(e.style);if (e == document || e.tagName.toLowerCase() == 'html' || e.tagName.toLowerCase() == 'body') {h = xClientHeight();}else if(css && xDef(e.offsetHeight) && xStr(e.style.height)) {if(h>=0) {var pt=0,pb=0,bt=0,bb=0;if (document.compatMode=='CSS1Compat') {var gcs = xGetComputedStyle;pt=gcs(e,'padding-top',1);if (pt !== null) {pb=gcs(e,'padding-bottom',1);bt=gcs(e,'border-top-width',1);bb=gcs(e,'border-bottom-width',1);}else if(xDef(e.offsetHeight,e.style.height)){e.style.height=h+'px';pt=e.offsetHeight-h;}}h-=(pt+pb+bt+bb);if(isNaN(h)||h<0) return;else e.style.height=h+'px';}h=e.offsetHeight;}else if(css && xDef(e.style.pixelHeight)) {if(h>=0) e.style.pixelHeight=h;h=e.style.pixelHeight;}return h;}function xLeft(e, iX){if(!(e=xGetElementById(e))) return 0;var css=xDef(e.style);if (css && xStr(e.style.left)) {if(xNum(iX)) e.style.left=iX+'px';else {iX=parseInt(e.style.left);if(isNaN(iX)) iX=0;}}else if(css && xDef(e.style.pixelLeft)) {if(xNum(iX)) e.style.pixelLeft=iX;else iX=e.style.pixelLeft;}return iX;}function xMoveTo(e,x,y){xLeft(e,x);xTop(e,y);}function xNum(){for(var i=0; i<arguments.length; ++i){if(isNaN(arguments[i]) || typeof(arguments[i])!='number') return false;}return true;}function xParent(e, bNode){if (!(e=xGetElementById(e))) return null;var p=null;if (!bNode && xDef(e.offsetParent)) p=e.offsetParent;else if (xDef(e.parentNode)) p=e.parentNode;else if (xDef(e.parentElement)) p=e.parentElement;return p;}function xScrollLeft(e, bWin){var offset=0;if (!xDef(e) || bWin || e == document || e.tagName.toLowerCase() == 'html' || e.tagName.toLowerCase() == 'body') {var w = window;if (bWin && e) w = e;if(w.document.documentElement && w.document.documentElement.scrollLeft) offset=w.document.documentElement.scrollLeft;else if(w.document.body && xDef(w.document.body.scrollLeft)) offset=w.document.body.scrollLeft;}else {e = xGetElementById(e);if (e && xNum(e.scrollLeft)) offset = e.scrollLeft;}return offset;}function xScrollTop(e, bWin){var offset=0;if (!xDef(e) || bWin || e == document || e.tagName.toLowerCase() == 'html' || e.tagName.toLowerCase() == 'body') {var w = window;if (bWin && e) w = e;if(w.document.documentElement && w.document.documentElement.scrollTop) offset=w.document.documentElement.scrollTop;else if(w.document.body && xDef(w.document.body.scrollTop)) offset=w.document.body.scrollTop;}else {e = xGetElementById(e);if (e && xNum(e.scrollTop)) offset = e.scrollTop;}return offset;}function xStr(s){for(var i=0; i<arguments.length; ++i){if(typeof(arguments[i])!='string') return false;}return true;}function xTop(e, iY){if(!(e=xGetElementById(e))) return 0;var css=xDef(e.style);if(css && xStr(e.style.top)) {if(xNum(iY)) e.style.top=iY+'px';else {iY=parseInt(e.style.top);if(isNaN(iY)) iY=0;}}else if(css && xDef(e.style.pixelTop)) {if(xNum(iY)) e.style.pixelTop=iY;else iY=e.style.pixelTop;}return iY;}function xWidth(e,w){if(!(e=xGetElementById(e))) return 0;if (xNum(w)) {if (w<0) w = 0;else w=Math.round(w);}else w=-1;var css=xDef(e.style);if (e == document || e.tagName.toLowerCase() == 'html' || e.tagName.toLowerCase() == 'body') {w = xClientWidth();}else if(css && xDef(e.offsetWidth) && xStr(e.style.width)) {if(w>=0) {var pl=0,pr=0,bl=0,br=0;if (document.compatMode=='CSS1Compat') {var gcs = xGetComputedStyle;pl=gcs(e,'padding-left',1);if (pl !== null) {pr=gcs(e,'padding-right',1);bl=gcs(e,'border-left-width',1);br=gcs(e,'border-right-width',1);}else if(xDef(e.offsetWidth,e.style.width)){e.style.width=w+'px';pl=e.offsetWidth-w;}}w-=(pl+pr+bl+br);if(isNaN(w)||w<0) return;else e.style.width=w+'px';}w=e.offsetWidth;}else if(css && xDef(e.style.pixelWidth)) {if(w>=0) e.style.pixelWidth=w;w=e.style.pixelWidth;}return w;}
var _mg56v = '0.3';

function KaboodleRun(u) {
    var kaboodleAddItemRuntime = new KaboodleAddItemRuntime();

    try {
	    //If the custom addtokaboodle is defined and the current document domain is same as the button target then use the override
	    if(typeof customAddToKaboodle == "function" && document.domain == "www.kaboodle.com"){
		    customAddToKaboodle();
	    }
	    else{
		    kaboodleAddItemRuntime.run(u);
	    }
    }
    catch(e) {
	    if (kaboodleAddItemRuntime.DEBUG) {
		    window.alert('Caught Exception: ' + e);
	    }
	    else {	
		    var url = 'http://www.kaboodle.com/za/additem' + '?get=1';
		    url = url.concat('&title=' + encodeURIComponent(document.title));
		    if (u != null && u != ''){
		        url = url.concat('&url=' + encodeURIComponent(u));
		    } else {
		        url = url.concat('&url=' + encodeURIComponent(window.location.href));
		    }
		    url = url.concat('&version=' + encodeURIComponent(_mg56v));
		    window.location = url;
	    }
    }
}

function KaboodleAddItemCommon(_baseUrl, _libs, _version) {

	// If true, exceptions are shown in alert box.
	this.DEBUG = false;

	this.retries = 0;
	this.baseUrl = _baseUrl;
	this.version = _version;
	this.libs = _libs;

	this.caught = function(e) {
		if (this.DEBUG) window.alert('Caught Exception: ' + e.message);
	}
	
	this.addDependentLibraries = function(callback) {
		var obj = this;
		if (this.retries == 0) {
			var doc = window.document;
			var head = doc.getElementsByTagName('head')[0];
			for (key in this.libs) {
				if (typeof this.libs[key] == 'string') { 
					if (this.DEBUG) window.alert('Adding library ' + key + ' from ' + this.baseUrl + this.libs[key] + '?v=' + this.version);		
					var element = this.createElement(doc, 'script');
					element.type = 'text/javascript';
					element.src = this.baseUrl + this.libs[key] + '?v=' + this.version;
					element.id = key;
					head.insertBefore(element, head.firstChild);
				}
			}
			this.retries++;
			setTimeout(function(){obj.addDependentLibraries(callback)}, 10);
		}
		else if(self.xDef && self.KaboodleExtractor) {
			if (this.DEBUG) window.alert('Libraries added after ' + (this.retries - 1) + ' retries.');
			callback.call();
		}
		else {
			if(this.retries == 100) { // 100 * 100 ms = 10 seconds
				if (this.DEBUG) window.alert('Error: Timed out waiting for the application to load.');
				return;
			}
			else if(this.retries > 100) {
				return;
			}
			else {
				this.retries++;
				setTimeout(function(){obj.addDependentLibraries(callback)}, 100);
			}
		}
	}
	
	this.removeDependentLibraries = function() {
		var doc = window.document;
		var head = doc.getElementsByTagName('head')[0];
		for(key in this.libs) {
			var element = doc.getElementById(key);
			if (element) {
				if (this.DEBUG) window.alert('Removing library ' + key);		
				head.removeChild(element);
			}
		}
	}

	this.getVersion = function(){
		var theVer = '';
		try {
			theVer = _mg56v;
		}
		catch (e) {
			this.caught(e);
		}
		return theVer;
	}

	this.createElement = function(doc, type) {
		try {
			var elem = doc.standardCreateElement(type);
			if (typeof(elem)=='object')
			return elem;
		}
		catch(e) {}
	
		return doc.createElement(type);
	}
}
function KaboodleAddItemShell(_common, _window, _document, _body, _url, _formTarget, _overlayMode) {

	// If true, exceptions are shown in alert box.
	this.DEBUG = false;

	// If true, set testing mode, else production mode, where
	// testing mode	= open text area with content
	// production mode = submit content to server
	this.TESTING = false;

	this.FORM_POST_URL=_url;
	this.FORM_TARGET = typeof _formTarget == 'undefined' ? null : _formTarget;
	this.overlayMode = typeof _overlayMode == 'undefined' ? false : _overlayMode;

	this.FORM_ID = 'KaboodleAddItemForm';
	this.BANNER_ID='KaboodleAddItemBanner';
	
	this.common = _common;
	this.window = _window;
	this.document = _document;
	this.body = _body;
	
	this.isTestingMode = function() {
		return self.K_TESTING != null ? self.K_TESTING : this.TESTING;
	}

	this.run = function(title, bgColor, color, params, url) {
		var banner = this.showBanner(title, bgColor, color);
		try {
			var obj = this;
			if (window.addEventListener)
				window.addEventListener("unload", function(){obj.hideBanner(banner)}, false);
			else if (window.attachEvent)
				window.attachEvent("unload", function(){obj.hideBanner(banner)});
		}
		catch(e) { 		
			if (this.DEBUG) this.window.alert('Ignoring Exception: ' + e.message);
		}
		var extractor = new KaboodleExtractor(this.window, this.document, this.body);
		var charset = this.getCharset();
		var content = extractor.extract(url);
		
		if (params == null)
			params = new Array();
				 	
		params['title'] = this.document.title;
		if (url != null && url != '') {
		    params['url'] = url;
		} else {
		    params['url'] = window.location.href;
		}
		params['type'] = extractor.type;
		if (this.isTestingMode()) {
			this.showTextArea(charset, content, params);
			this.hideBanner(banner);
			this.common.removeDependentLibraries();
		}
		else {
			this.send(charset, content, params);
			this.common.removeDependentLibraries();
		}
	}
	
	this.getCharset = function() {
		if (this.document.getElementById && xDef(this.document.characterSet))
			return this.document.characterSet;
		else if (xDef(this.document.charset))
			return this.document.charset;
		else
			return 'ISO-8859-1';
	}

	this.showBanner = function(title, bgColor, color) {
		if(this.overlayMode){
			return null;
		}
		try {
			var element = this.common.createElement(this.document, 'DIV');
			element.id = this.BANNER_ID;
			var style = 'font-family: Arial; font-size: 12pt; font-weight: bolder; ' +
				'text-align: center; ' +
				'height: 1em; position: absolute; ' +
				'color: '+ color + '; background-color:'+ bgColor + '; ' +
				'border: 1px solid black; ' + 
				'visibility: hidden; ' +
				'top:0px; left:0px; z-index: 99999; ' +
				'padding: 0.5em 0 0 0; ' +
				'width: 100%; height: 2em; ' +
				'filter:alpha(opacity=85); ' +
				'-moz-opacity:0.85; ' +
				'opacity: 0.85; ';
			element.style.cssText = style;
			element.innerHTML = '&nbsp;&nbsp;' + title + '&nbsp;&nbsp;';
			this.body.appendChild(element);
			var pos = xCardinalPosition(element, 'n');
			xMoveTo(element, pos.x, pos.y);
			element.style.visibility = 'hidden';
			return element;
		}
		catch(e) {
			if (this.DEBUG)
				this.window.alert('Caught Exception: ' + e.message);
		}
		return null;
	}
	
	this.hideBanner = function(element) {
		try {
			if (element) {
				this.body.removeChild(element);
			}
		}
		catch(e) {
			if (this.DEBUG)
				this.window.alert('Caught Exception: ' + e.message);
		}
	}

	this.send = function(charset, content, params) {
		var form = this.common.createElement(this.document, 'form');
		form.method = 'post';
		form.action = this.FORM_POST_URL;
		form.enctype = 'multipart/form-data';
		form.encoding = 'multipart/form-data';
		form.id=this.FORM_ID;
		form.name=this.FORM_ID;
		form.style.visibility = 'hidden';
		if(this.FORM_TARGET != null){
			form.target = this.FORM_TARGET;		
		}
		if(this.overlayMode){
			this.addInput(this.document, form, 'hidden', 'overlay', true);
		}
			
		for (param in params) {
			this.addInput(this.document, form, 'hidden', param, params[param]);
		}
		this.addInput(this.document, form, 'hidden', 'charset', charset);
		this.addInput(this.document, form, 'hidden', 'content', content);
		this.addInput(this.document, form, 'submit', 'button', 'submit');
		this.body.appendChild(form);
		form.submit();
		this.body.removeChild(form);
	}

	this.showTextArea = function(charset, content, params) {
		var form = this.body.insertBefore(this.common.createElement(this.document, 'form'), this.body.firstChild);
		form.method='post';
		form.enctype='multipart/form-data';
		form.id=this.FORM_ID;
		form.name=this.FORM_ID;

		var textarea=form.appendChild(this.common.createElement(this.document, 'textarea'));		
		textarea.setAttribute('rows','30');
		textarea.setAttribute('cols','100');

		var text = new Array();
		for (param in params) {
			var value = params[param];
			
			if (typeof value == 'string')
				text.push(param + '=' + params[param]);
		}
		text.push('charset=' + charset);
		text.push(content);
		textarea.value = text.join('\n');
		
		form.appendChild(this.common.createElement(this.document, 'br'));

		var submit=this.common.createElement(this.document, 'input');
		submit.setAttribute('type','submit');
		submit.setAttribute('onclick', 'javascript:window.document.getElementsByTagName(\'body\')[0].removeChild(window.document.getElementById(\'' + this.FORM_ID + '\')); return false;');
		submit.value = 'Discard';
		
		form.appendChild(submit);
	}

	this.addInput = function(doc, form, type, name, value) {
		  var e = this.common.createElement(doc, 'input');
		  e.type = type;
		  e.name = name;
		  e.value = value;
		  
		  form.appendChild(e);
	}

	this.addQueryStringParam = function(name, value) {
			return '&' + name + '=' + encodeURIComponent(value);
	}
}
function KaboodleExtractor(_window, _document, _body) {

	// If true, exceptions are shown in alert box.
	this.DEBUG = false;

	this.CSS_FONT_SIZE_LITERALS = new Array();
	this.CSS_FONT_SIZE_LITERALS['xx-small'] = 10;
	this.CSS_FONT_SIZE_LITERALS['x-small'] = 13;
	this.CSS_FONT_SIZE_LITERALS['small'] = 16;
	this.CSS_FONT_SIZE_LITERALS['medium'] = 18;
	this.CSS_FONT_SIZE_LITERALS['large'] = 24;
	this.CSS_FONT_SIZE_LITERALS['x-large'] = 32;
	this.CSS_FONT_SIZE_LITERALS['xx-large'] = 48;
	this.CSS_FONT_SIZE_LITERALS['1'] = 10;
	this.CSS_FONT_SIZE_LITERALS['2'] = 13;
	this.CSS_FONT_SIZE_LITERALS['3'] = 18;
	this.CSS_FONT_SIZE_LITERALS['4'] = 24;
	this.CSS_FONT_SIZE_LITERALS['5'] = 32;
	this.CSS_FONT_SIZE_LITERALS['6'] = 48;
	this.CSS_FONT_SIZE_LITERALS['7'] = 64;

	this.microformat = null;	
	this.type = 'custom';
	this.window = _window;
	this.document = _document;
	this.body = _body;
	this.view = _document.defaultView;
	this.timestamp = null;
	this.nonws = /\S/;
	this.quote = /([\"\\])/g;
	this.reservedChars = /([#@\\\{\}\[\]])/g;
	this.breakingTags = /^(P|DIV|H[R1-6]|TABLE|TR)$/i;
	this.ignoreTags = /^(BUTTON|TEXTAREA)$/i;
	this.headerTags = /^(H[1-6])$/i;
	this.imageTags = /^(IMG|V:IMAGEDATA|EMBED|OBJECT)$/i;
	this.fontWeights = /\d+/i;
	this.fontSizes = /^\d+(\.\d+)?(pc|pt|px|em|ex|%)$/i;
	this.http = /^http(s)?:\/\//ig;
	this.hex = new Array('0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f');
	this.imageArray = new Array('', '', '', '');
	this.positionArray = new Array('', '');
	this.fontArray = new Array('', '', '', '','');
	this.currentStyle = null;
	this.structures = null;
	this.states = null;
	this.breaks = 0;
	this.href = false;
	this.header = false;
	this.id = 0;
	
	this.start = function(msg) {

		this.window.alert(msg);

		this.timestamp = new Date().getTime();
	}

	this.split = function(msg) {

		var split = new Date().getTime();

		this.window.alert(msg + ": " + (split - this.timestamp) + "ms");

		this.timestamp = new Date().getTime();	
	}

	this.extract = function(url) {

		if (url != null && url != '') {
		    this.microformat = this.getMicroformat(url);
		} else {
		    this.microformat = this.getMicroformat(window.location);
		}
		
		if (this.DEBUG) this.start("Extracting using " + this.type);

		var content = new Array();
		
		content.push('!HTML' + this.printAttributeNodes(this.document.documentElement));

		content.push('!TITLE ' + this.document.title);

		var base = this.document.getElementsByTagName("base");
		
		if (base && base.length > 0) {
		
			content.push('!BASE' + this.printAttributeNodes(base[0]));
		}
		else if (this.window != window) {

		    if (url != null && url != '') {
			    content.push('!BASE href="' + url + '"');
		    } else {
			    content.push('!BASE href="' + this.window.location + '"');
		    }
		}

		var meta = this.document.getElementsByTagName("meta");

		if (meta) {

			for (var i = 0; i < meta.length; ++i) {

				content.push('!META' + this.printAttributeNodes(meta[i]));
			}	
		}

		var link = this.document.getElementsByTagName("link");

		if (link) {

			for (var i = 0; i < link.length; ++i) {

				if (link[i].getAttribute("rel") == "image_src") {
				
					content.push('!LINK' + this.printAttributeNodes(link[i]));
				}
			}	
		}

		var text = new Array();
		var images = new Array();
		
		try {
		
			this.extractNode(text, images, this.body);
		}
		catch (e) {

			if (this.DEBUG) throw e;
		}

		for (var src in images) {

			var href = false;
			var image = images[src];
			
			if (typeof image == 'object') {
			
				var params = new Array();
				
				params.push(this.printAttribute('src', src));
				
				for (var param in image) {
				
					switch (param) {
						case 'x':
						case 'y':
						case 'width':
						case 'height':
						case 'structure':

							break;
							
						case 'href':
						
							href = image[param];
							
							break;
							
						default:
						
							var value = image[param];
							
							if (typeof value == 'string')
								params.push(this.printAttribute(param, value));
					}
				}
				
				var str = new Array();
				
				str.push(this.toHex(image['x']));
				str.push(':');
				str.push(this.toHex(image['y']));
				str.push(':');
				str.push(this.toHex(image['width']));
				str.push(':');
				str.push(this.toHex(image['height']));
				str.push('[');
				str.push(this.toHex(image['id']));
				str.push(']');

				if (href) 
					str.push('@');

				str.push(' ');
				str.push(params.join(' ').replace(/\s+/g, ' '));
				
				content.push(str.join(''));
			}
		}
		
		for (var i = 0; i < text.length; ++i) {

			content.push(text[i]);
		}

		if (this.DEBUG) this.split("Time to extract");

		return content.join('\n');
	}

	this.extractNode = function(content, images, node, offsets, frameSrc) {

		this.structures = new Array();
		this.states = new Array();
		this.breaks = 0;
		this.href = false;
		this.header = false;
		
		var length = 0;

		if (node) {

			var text = null;
			var small = false;
			var backup = false;
			var ids = new Array();
			var parents = new Array();

			node = node.firstChild;

			while (node && length < 15360) {

				if (backup) {

					if (parents.length == 0)
						break;

					node = parents.pop();

					var tag = node.tagName;
					
					if (tag)
						tag = tag.toLowerCase();
						
					if (tag == 'a') {

						this.href = false;
					}
					else if (tag == 'table' || tag == 'ol' || tag == 'ul' || tag == 'dl') {
					
						if (this.states.pop() > 0) {
						
							if (!text)
								content.push(content.pop() + '}');
							else
								text.push('}');
						}
						
						this.structures.pop();
					}
					else if (tag == 'tr') {

						this.breaks &= ~2;
					}
					else if (tag == 'td' || tag == 'th') {

						this.breaks &= ~4;
					}
					else if (tag == 'li' || tag == 'dt') {
					
						this.breaks &= ~8;
					}
					else if (tag == 'small') {
					
						small = false;
					}
					else if (tag == 'input') {

						this.breaks &= ~16;
					}
					else if (this.headerTags.test(tag)) {
					
						this.header = false;
					}

					if ((node.id && this.microformat["#" + node.id]) || (node.className && this.microformat["." + node.className])) {
														
						if (this.states.pop() > 0) {
						
							if (!text)
								content.push(content.pop() + '}');
							else
								text.push('}');
						}
						
						this.structures.pop();
					}
					
					if (text) {

						if (this.breakingTags.test(tag)) {

							var str = text.join('').replace(/\s+/g, ' ');

							content.push(str);

							length += str.length;

							text = null;
							
							this.breaks = 0;
						}
					}

					if (node.nextSibling) {

						node = node.nextSibling;

						backup = false;
					}
				}						
				else if (node.nodeType == 1) {

					var tag = node.tagName;
					
					if (tag)
						tag = tag.toLowerCase();
						
					var style;
					var hidden;
					var block;

					if (this.view && this.view.getComputedStyle) {

						style = this.view.getComputedStyle(node, '');

						if (style) {

							hidden = style.getPropertyValue("visibility") == "hidden" 
								|| style.getPropertyValue("display") == "none";
						}
						else {
						
							hidden = true;
						}
						
						if (!hidden && style.getPropertyValue("overflow") == 'hidden') {
						
							var top = style.getPropertyValue("top");
							var left = style.getPropertyValue("left");
							
							hidden = (top && top.charAt(0) == '-') || (left && left.charAt(0) == '-');
						}
								
						block = style.getPropertyValue("display") == "block";
					}
					else if (node.currentStyle) {

						hidden = node.currentStyle["visibility"] == "hidden"
							|| node.currentStyle["display"] == "none"

						if (!hidden && node.currentStyle["overflow"] == 'hidden') {
						
							var top = node.currentStyle["top"];
							var left = node.currentStyle["left"];
							
							hidden = (top && top.charAt(0) == '-') || (left && left.charAt(0) == '-');
						}

						block = node.currentStyle["display"] == "block";
					}

					if (hidden || this.ignoreTags.test(tag)
						|| (node.id && node.id.substr && node.id.substr(0, 8)== 'Kaboodle')) {

						if (node.nextSibling)
							node = node.nextSibling;								
						else 
							backup = true;				
					}
					else if (this.imageTags.test(tag)) {

						var image = this.extractImage(images, node, offsets, frameSrc);

						if (image) {
						
							if (!text) {
					
								text = new Array();
					
								text.push(this.getNodePosition(node.parentNode, offsets));
							}
					
							this.appendImage(text, image);
						}

						if (node.nextSibling)
							node = node.nextSibling;
						else 
							backup = true;
					}
					else if (tag == 'iframe') {
					
						this.extractFrame(content, images, node, offsets);

						if (node.nextSibling)
							node = node.nextSibling;
						else 
							backup = true;
					}
					else if (tag == 'select') {
					
						var value = node.options[node.selectedIndex].text;
						
						if (value) {

							if (!text) {
	
								text = new Array();
	
								text.push(this.getNodePosition(node, offsets));
							}
	
							this.append(text, value, this.getFontInfo(node, small));
						}

						if (node.nextSibling)
							node = node.nextSibling;
						else 
							backup = true;
					}
					else if (tag == 'input') {
					
						var type = node.getAttribute('type');
						var value = node.getAttribute('value');
						
						if (type == 'text' && value) {
						
							if (!text) {
	
								text = new Array();
	
								text.push(this.getNodePosition(node, offsets));
							}
							
							this.breaks |= 16;
							
							this.append(text, value, this.getFontInfo(node, small));						
						}

						if (node.nextSibling)
							node = node.nextSibling;
						else 
							backup = true;
					}
					else {

						if (text) {

							if (this.breakingTags.test(tag)) {
 
								var str = text.join('').replace(/\s+/g, ' ');

								content.push(str);

								length += str.length;

								text = null;
								
								this.breaks = 0;
							}
						}
						
						if (text && (tag == 'br' || block)) {
							
							this.breaks |= 1;
						}

						if (node.firstChild) {

							if (node.id && this.microformat["#" + node.id]) {
							
								this.structures.push(this.microformat["#" + node.id]);
								this.states.push(0);
							}
							else if (node.className && this.microformat["." + node.className]) {
							
								this.structures.push(this.microformat["." + node.className]);
								this.states.push(0);
							}
							else if (node.className && this.microformat["?" + node.className]) {
							
								if (this.microformat["?" + node.className] == "br") {
								
									this.breaks |= 16;
								}
							}

							if (tag == 'a') {

								this.href = true;
							}
							else if (tag == 'table') {
							
								this.structures.push('t');
								this.states.push(0);
							}
							else if (tag == 'ol' || tag == 'ul' || tag == 'dl') {
							
								this.structures.push('l');
								this.states.push(0);
							}
							else if (tag == 'tr') {
		
								this.breaks |= 2;
							}
							else if (tag == 'td' || tag == 'th') {
		
								this.breaks |= 4;
							}
							else if (tag == 'li' || tag == 'dt') {
							
								this.breaks |= 8;
							}
							else if (tag == 'small') {
							
								small = true;
							}
							else if (this.headerTags.test(tag)) {
							
								this.header = true;
							}

							parents.push(node);
							
							node = node.firstChild;
						}
						else if (node.nextSibling)
							node = node.nextSibling;
						else 
							backup = true;
					}
				}
				else if (node.nodeType == 3) {

					if (this.nonws.test(node.nodeValue)) {

						if (!text) {
				
							text = new Array();
				
							text.push(this.getNodePosition(node.parentNode, offsets));
						}
				
						this.append(text, node.nodeValue, this.getFontInfo(node.parentNode, small));
					}
					else if (text && text.length > 0) {
					
						text.push(' ');
					}

					if (node.nextSibling)
						node = node.nextSibling;							
					else 
						backup = true;
				}
				else if (node.nextSibling)
					node = node.nextSibling;							
				else 
					backup = true;
			}

			if (text) {

				var str = text.join('').replace(/\s+/g, ' ');

				content.push(str);

				length += str.length;

				text = null;
			}		
		}
	}
	
	this.append = function(text, value, style) {

		var prefix = '';
		var structure = '';
			
		for (var i = this.states.length - 1; i >= 0 && this.states[i] == 0; --i) {
		
			structure = this.structures[i] + structure;
			this.states[i] = 1;
		}
		
		if (structure.length > 0)
			prefix += '{' + structure;
				
		if (this.breaks != 0) {
		
			prefix += '@' + this.toHex(this.breaks);
			
			this.breaks = 0;
		}

		if (style != this.currentStyle) {

			prefix += '#' + style;

			this.currentStyle = style;
		}

		if (prefix.length > 0)
			text.push(text.pop() + prefix + ';');
		else if (text.length == 1)
			text.push(text.pop() + ' ');			
			
		// Need double escaped quotes since when included in JSP the
		text.push(value.replace(this.reservedChars, '\\\$&'));					
	}
	
	this.appendImage = function(text, image) {

		var prefix = '';
		var structure = '';
			
		for (var i = this.states.length - 1; i >= 0 && this.states[i] == 0; --i) {
		
			structure = this.structures[i] + structure;
			this.states[i] = 1;
		}
		
		if (structure.length > 0)
			prefix += '{' + structure;
				
		if (this.breaks != 0) {
		
			prefix += '@' + this.toHex(this.breaks);
			
			this.breaks = 0;
		}

		if (prefix.length > 0)
			text.push(text.pop() + prefix + ';');
		else if (text.length == 1)
			text.push(text.pop() + ' ');			
			
		text.push('[' + this.toHex(image['id']) + ']');					
	}
		
	this.extractImage = function(images, node, offsets, frameSrc) {

		var src = null;
		var attrs = new Array();
			
		this.findNodePosition(node, attrs, 10, offsets);

		attrs['width'] = xWidth(node);
		attrs['height'] = xHeight(node);
		
		if (node.nodeName.toLowerCase() == 'object') {
		
			src = node.getAttribute('data');				
			attrs['width'] = node.getAttribute('width');
			attrs['height'] = node.getAttribute('height');
			attrs['type'] = 'application/x-shockwave-flash';
			attrs['flashvars'] = this.customFlashVars(node);
							
			for (var child = node.firstChild; child != null; child = child.nextSibling) {
			
				if (child.nodeType == 1) {
				
					var tag = child.tagName.toLowerCase();
					
					if (tag == 'param') {
				
						var name = child.getAttribute('name');
					
						if (name) {
						
							name = name.toLowerCase();
							
							var value = child.getAttribute('value');
							
							if (name == 'movie') {
					
								src = value;
							}
							else if (name == 'base' || name == 'flashvars') {
							
								attrs[name] = value;
							}
						}
					}
					else if (tag == 'embed' && !xIE4Up) {
					
						this.findNodePosition(child, attrs, 10, offsets);

						attrs['width'] = xWidth(child);
						attrs['height'] = xHeight(child);
					}
				}
			}
		}
		else if (node.nodeName.toLowerCase() == 'embed') {
		
			if (node.getAttribute('type') == 'application/x-shockwave-flash') {
			
				src = node.getAttribute('src');
				attrs['type'] = 'application/x-shockwave-flash';
				attrs['flashvars'] = this.customFlashVars(node);
			
				if (node.getAttribute('base'))
					attrs['base'] = node.getAttribute('base');
					
				if (node.getAttribute('flashvars'))
					attrs['flashvars'] = node.getAttribute('flashvars');
			}
		}
		else {
		
			src = node.getAttribute('src');
		}
		
		var image = images[src];

		if ((image != null && attrs['width'] * attrs['height'] > image['width'] * image['height'])
			|| (image == null && attrs['width'] >= 50 && attrs['height'] >= 50)) {
		
			if (node.getAttribute('alt'))
				attrs['alt'] = node.getAttribute('alt');
			
			if (!this.http.test(src) && frameSrc)
				attrs['frame'] = frameSrc;
				
			attrs['href'] = this.href;
			
			if (image)
				attrs['id'] = image['id'];
			else
				attrs['id'] = this.id++;

			images[src] = attrs;
			
			return attrs;
		}
		
		return image;
	}

	this.extractFrame = function(content, images, frame, offsets) {
	
		if (this.DEBUG) window.alert('Extracting iframe: ' + frame.src);
		
		if (frame.src != 'about:blank') {
		
			var frameDocument = null;
			
			var frameBody = null
			
			try {
	
				frameDocument = frame.contentWindow ? frame.contentWindow.document : frame.contentDocument;
				frameBody = frameDocument.body ? frameDocument.body : frameDocument.getElementsByTagName('body')[0];
			}
			catch (e) {}
	
			if (frameBody != null) {
			
				var frameOffsets = new Array();
				
				this.findNodePosition(frame, frameOffsets, 10, offsets);
				
				this.extractNode(content, images, frameBody, frameOffsets, frame.src);
			}
		}
	}
	
	this.getNodePosition = function(node, offsets) {

		this.findNodePosition(node, this.positionArray, 10, offsets);

		return this.toHex(this.positionArray['x']) + ':' + this.toHex(this.positionArray['y']);
	}

	this.getFontInfo = function(node, small) {

		// The format expects the ':' separator even if there is
		// no value, don't change the order of the values either
		// as they are expected in this order by the server-side.

		if (this.view && this.view.getComputedStyle) {

			var style = this.view.getComputedStyle(node, '');

			if (style != null) {
			
				this.fontArray[0] = this.toHex(this.getFontSize(node, style.getPropertyValue("font-size")));
				this.fontArray[1] = this.getFontWeight(style.getPropertyValue("font-weight"));
				this.fontArray[2] = this.getFontStyle(style.getPropertyValue("font-style"));
				this.fontArray[3] = this.getTextDecoration(style.getPropertyValue("text-decoration"));
			}
		}

		else if (node.currentStyle) {

			this.fontArray[0] = this.toHex(this.getFontSize(node, node.currentStyle["fontSize"]));
			this.fontArray[1] = this.getFontWeight(node.currentStyle["fontWeight"]);
			this.fontArray[2] = this.getFontStyle(node.currentStyle["fontStyle"]);
			this.fontArray[3] = this.getTextDecoration(node.currentStyle["textDecoration"]);
			
			if (small) {
			
				this.fontArray[0] *= 3 / 4;
			}
		}

		var style = 0;

		if (this.header)
			style |= 1;

		if (this.href)
			style |= 2;

		this.fontArray[4] = style != 0 ? style : '';
		
		return this.fontArray.join(':');
	}

	this.getFontWeight = function(style) {

		if (style) {

			if (this.fontWeights.test(style)) {

				if (parseInt(style) > 400) {

					return 'b';
				}
			}
			else {

				style = style.toLowerCase ? style.toLowerCase() : style;

				switch (style) {

					case 'bold':
					case 'bolder':

						return 'b';					
				} 
			}
		}		
		return '';
	}

	this.getFontStyle = function(style) {

		if (style) {

			style = style.toLowerCase();

			if (style != 'normal') {

				return style.charAt(0);
			}
		}
		return '';
	}

	this.getTextDecoration = function(style) {

		if (style) {

			style = style.toLowerCase();

			if (style != 'none') {

				return style.charAt(0);
			}
		}
		return '';
	}

	this.getFontSize = function(node, style) {
	
		if (style) {

			style = style.toLowerCase ? style.toLowerCase() : style;

			if (this.fontSizes.test(style)) {

				var postfix;
				var size;

				if (style.charAt(style.length - 1) == '%') {

					postfix = '%';
					size = parseInt(style.substr(0, style.length - 1));
				}
				else {

					postfix = style.substr(style.length - 2);
					size = parseInt(style.substr(0, style.length - 2));
				}

				switch (postfix) {

					case 'pt':

						return size * 4.0 / 3.0;

					case 'pc':

						return size * 16;

					case 'px':

						return size;

					case 'em':
					case 'ex':
					case '%':

						var parentStyle;

						if (this.view && this.view.getComputedStyle) {

							parentStyle = this.view.getComputedStyle(node, '').getPropertyValue("font-size");
						}
						else if (node.currentStyle) {

							parentStyle = node.currentStyle["fontSize"];
						}

						if (postfix == '%') {

							return this.getFontSize(node.parentNode, parentStyle) * size / 100.0;
						}
						else if (postfix == 'ex') {

							return this.getFontSize(node.parentNode, parentStyle) * size / 5.0 * 8.0;
						}
						else {

							return this.getFontSize(node.parentNode, parentStyle) * size;
						}

					default:

						return size * 4.0 / 3.0;
				}
			}
			else {

				var size = this.CSS_FONT_SIZE_LITERALS[style];
				
				if (size) {
				
					return size;
				}
				else {
				
				var parentStyle;

					if (this.view && this.view.getComputedStyle) {
		
						parentStyle = this.view.getComputedStyle(node, '').getPropertyValue("font-size");
					}
					else if (node.currentStyle) {
		
						parentStyle = node.currentStyle["fontSize"];
					}
		
					if ('smaller' == style) {
	
						return this.getFontSize(node.parentNode, parentStyle) * 4.0 / 5.0;
					}
					else if ('larger' == style) {
	
						return this.getFontSize(node.parentNode, parentStyle) * 5.0 / 4.0;
					}
					else if (style.charAt(0) == '-') {
					
						size = this.getFontSize(node.parentNode, parentStyle);
						
						for (var i = -parseInt(style); i > 0; --i) {
						
							size *= 4.0 / 5.0; 
						}
						
						return size;
					}
					else if (style.charAt(0) == '+') {
					
						var max = this.CSS_FONT_SIZE_LITERALS['7'];
						
						size = this.getFontSize(node.parentNode, parentStyle);
						
						for (var i = parseInt(style); i > 0 && size < max; --i) {
						
							size *= 5.0 / 4.0; 
						}
						
						return size < max ? size : max;
					}
				}
			}
		}

		return 16;
	}

	this.findNodePosition = function(obj, pos, scale, offsets) {
		var x = 0;
		var y = 0;
		if(obj.offsetParent) {
			while(obj.offsetParent) {
				x += obj.offsetLeft;
				y += obj.offsetTop;
				obj = obj.offsetParent;
			}
		}
		else {
			if (obj.x)
				x += obj.x;
			if (obj.y)
				y += obj.y;
		}

		if (offsets) {
			pos['x'] = offsets['x'] + parseInt(x / scale);
			pos['y'] = offsets['y'] + parseInt(y / scale);
		}
		else {
			pos['x'] = parseInt(x / scale);
			pos['y'] = parseInt(y / scale);
		}
	}
	
	this.printAttribute = function(name, value) {
		
		// Need double escaped quotes since when included in JSP the
		
		return name + '="' + value.replace(/[\n]/g, ' ').replace(/[\r]/g, '').replace(this.quote, '\\\$&') + '"';
	}

	this.printAttributeNodes = function(n) {
		if (n.attributes) {
			var attrs = n.attributes;
			var attr;
			var ret = new Array();
			for(var i=0; i < attrs.length; i++) {
				attr = attrs[i];
				if(attr.value != '' && attr.value != 'null') {
					if(attr.name.toLowerCase() == 'src') {
						if(xDef(n.src)) { // if node itself has a src value, use that
							ret.push(' ' + this.printAttribute(attr.name, n.src));
						}
						else {
							ret.push(' ' + this.printAttribute(attr.name, attr.value));
						}
					}
					else {
						ret.push(' ' + this.printAttribute(attr.name, attr.value));
					}
				}
			}
			return ret.join('');
		}

		return '';
	}
	
	this.toHex = function(num) {
	
		var value = this.hex[num & 15];
		
		while(num > 15) {
		
			num >>= 4;
			value = this.hex[num & 15] + value;
		}
		
		return value;
	}
	
	this.customFlashVars = function(node) {

		if (typeof(MACYS) != 'undefined' && typeof(MACYS.pdp) != 'undefined' && typeof(MACYS.pdp.defaultProdImgLarge) != 'undefined')
			return "altUrl=" + MACYS.pdp.defaultProdImgLarge;
		
		return "";
	}
	
	this.getMicroformat = function(url) {
	
		var microformat = new Array();
		
		if (/^http(s)?:\/\/.*amazon..*\/.*/ig.test(url)) {
		
			microformat['#btAsinTitle'] = 'T';
			microformat['#productDescription'] = 'D';
			microformat['#priceBlock'] = 'P';
			microformat['#prodImageCell'] = 'I';
		}
		else if (/^http(s)?:\/\/.*ae.com\/.*/ig.test(url)) {
		
			microformat['#prod_equity'] = 'T';
			microformat['#product_price'] = 'P';
			microformat['#product_description'] = 'D';
		}
		else if (/^http(s)?:\/\/.*anthropologie.com\/.*/ig.test(url)) {
		
			microformat['.price'] = 'P';
		}
		else if (/^http(s)?:\/\/.*bestbuy.com\/.*/ig.test(url)) {
		
			microformat['#priceblock'] = 'P';
		}
		else if (/^http(s)?:\/\/.*ebay.com\/.*/ig.test(url)) {
		
			microformat['#EBdescription'] = 'D';
		}
		else if (/^http(s)?:\/\/.*endless.com\/.*/ig.test(url)) {
		
			microformat['#prodTitle'] = 'T';
			microformat['#prodDescription'] = 'D';
			microformat['#prodBullets'] = 'D';
			microformat['#prodAbout'] = 'D';
			microformat['#ddmp'] = 'P';
		}
		else if (/^http(s)?:\/\/.*forever21.com\/.*/ig.test(url)) {
		
			microformat['.items_name'] = 'T';
		}
		else if (/^http(s)?:\/\/.*karmaloop.com\/.*/ig.test(url)) {
		
			microformat['?text-med'] = 'br';
		}
		else if (/^http(s)?:\/\/.*macys.com\/.*/ig.test(url)) {
		
			microformat['.productDetailLong'] = 'D';
		}
		else if (/^http(s)?:\/\/.*zappos.com\/.*/ig.test(url)) {
		
			microformat['#product-description'] = 'D';
		}

		if (this.DEBUG) this.window.alert("microformat=[" + this.map(microformat) + "]");

		return microformat;
	}
	
	this.map = function(obj) {
	
		var params = new Array();
		
		for (var param in obj) {
		
			var value = obj[param];
			
			if (typeof value == 'string')
				params.push(this.printAttribute(param, value));
		}
		
		return params.join(',');
	}
}

function KaboodleAddItemRuntime() {

	this.BUILD_VERSION='@ver@';
	this.FORM_POST_URL='http://www.kaboodle.com/za/additem';
	this.JS_BASE_URL = 'http://www.kaboodle.com/ht/scripts/add';
	this.JS_LIBS = null;
	this.FORM_TARGET = '_blank';

	// If true, exceptions are shown in alert box.
	this.DEBUG = false;

	this.common = null;
	this.window = null;
	this.document = null;
	this.body = null;

	this.run = function(url) {

		this.common = new KaboodleAddItemCommon(this.JS_BASE_URL, this.JS_LIBS, this.BUILD_VERSION);

		var title = 'Adding To Kaboodle...';
		var bgColor = 'rgb(250,210,100)';
		var color = 'black';
		
		// sometimes websites name a frame "top", so we always attempt .top.top.
		this.window = this.hasFrames(window.top.top) ? this.getFrame(window.top.top) : this.window = window;
		this.document = this.window.document;
		try {
			this.body = this.document.getElementsByTagName('body')[0];
		}
		catch (e) {
			this.body = this.document.body;
		}
		var shell = new KaboodleAddItemShell(this.common, this.window, this.document, this.body, this.FORM_POST_URL, this.FORM_TARGET);
		shell.run(title, bgColor, color, null, url);
	}
	
	this.hasFrames = function(_window) {
		try {
			if (this.DEBUG) window.alert('Checking ' + _window.document.body.nodeName + ' for frames');
			return _window.document.body.nodeName == 'FRAMESET';
		}
		catch(e) {
			return false;
		}
	}

	this.getWindowWidth = function(_window) {
		var w=0;
		var found = false;
		var _document = null;
		if (xOp6Dn) {
			try {
				 w=_window.innerWidth;
				 found = true;
			}
			catch(e) {
				this.common.caught(e);
				return w;
			}
		}
		if (!found) {
			try {
				 _document = _window.document;
			}
			catch(e) {
				this.common.caught(e);
				return w;
			}

			try {
				if (_document.compatMode == 'CSS1Compat' && !window.opera && _document.documentElement && _document.documentElement.clientWidth) {
					w=_document.documentElement.clientWidth;
					found = true;
				}
			}
			catch(e) {
				this.common.caught(e);
			}
		}
		if (!found) {
			try {
				if (_document.body && _document.body.clientWidth) {
					w=_document.body.clientWidth;
					found = true;
				}
			}
			catch(e) {
				this.common.caught(e);
			}
		}
		if (!found) {
			try {
				if (xDef(_window.innerWidth,_window.innerHeight,_document.height)) {
					w=_window.innerWidth;
					if (_document.height>_window.innerHeight) w-=16;
					found = true;
				}
			}
			catch(e) {
				this.common.caught(e);
			}
		}
		return w;
	}

	this.getWindowHeight = function(_window) {
		var h=0;
		var found = false;
		var _document = _window.document;
		if (xOp6Dn) {
			h=_window.innerHeight;
			found = true;
		}
		if (!found) {
			try {
				if (_document.compatMode == 'CSS1Compat' && !window.opera && _document.documentElement && _document.documentElement.clientHeight) {
					h=_document.documentElement.clientHeight;
					found = true;
				}
			}
			catch(e) {
				this.common.caught(e);
			}
		}
		if (!found) {
			try {
				if (_document.body && _document.body.clientHeight) {
					h=_document.body.clientHeight;
					found = true;
				}
			}
			catch(e) {
				this.common.caught(e);
			}
		}
		if (!found) {
			try {
				if (xDef(_window.innerWidth,_window.innerHeight,_document.width)) {
					h=_window.innerHeight;
					if (_document.width>_window.innerWidth) h-=16;
					found = true;
				}
			}
			catch(e) {
				this.common.caught(e);
			}
		}
		return h;
	}

	this.getFrame = function(_window) {

		var frames = _window.frames;
		var largestFrame = null;
		var largestFrameArea = 0;
		var frame = null;
		var area = 0;

		if (frames.length == 0) {
			if (this.DEBUG) { window.alert('no more frames, using ' + _window); }
			return _window;
		}
		if (this.DEBUG) { window.alert('found ' + frames.length + ' frames'); }
		for(var i = 0; i < frames.length; i++) {
			if (this.DEBUG) { window.alert('testing frame ' + i); }
			try {
				frame = frames[i];
			}
			catch(e) {
				this.common.caught(e);
				continue;
			}
			if (this.DEBUG) { window.alert('frame[' + frame.name + ']'); }
			area = this.getWindowWidth(frame) * this.getWindowHeight(frame);
			if (this.DEBUG) { window.alert('frame[ ' + frame.name + '](area= ' + this.getWindowWidth(frame) + 'x' + this.getWindowHeight(frame) + ')\n' + frame.document.documentElement.innerHTML); }
			if ((largestFrame == null) || 
				 ((area > largestFrameArea) && 
				(xDef(frame.document.body)))) {
				if (this.DEBUG) { window.alert('setting largestFrame'); }
				largestFrame = frame;
				largestFrameArea = area;
			}
		}
		if (this.hasFrames(largestFrame)) {
			if (this.DEBUG) { window.alert('frame has frames - recursing down'); }
			return this.getFrame(largestFrame);
		}
		else {
			if (this.DEBUG) { window.alert('found largest: frame[ ' + largestFrame.name + '](area=' + largestFrameArea + ')'); }
			return largestFrame;
		}
	}
}
