/*
 * HOW TO ADD PRODUCTGRAM TO A PAGE
 * ---
 * 1. Make sure ProductGram.js and ProductGram.css are available and match the related tags in x6qv.ascx.
 * 2. Add x6prodgram.ascx to the .aspx page. 
 * 3. Add mouse hover handlers to the element that will host the Product Gram button:
 * 
 *     <img ... onmouseover="displayQVButton(this, %URL%);" onmouseout="hideQVButton();" ... />
 *
 * 4. Replace the %URL% parameter in the above example with the standard X6 url for the product.
 *
 * CONTENTS OF THIS FILE
 * ---
 * Product Gram Window Functions
 * Product Gram Window - Banner Display Functions
 * Product Gram Window - Image Display Functions
 * Product Gram Window - Information Display Functions
 * Product Gram Window - Footer Display Functions
 * Ajax Functions
 * Utility Functions
 *  
 */
 
/*
 * Product Gram Window Functions
 */

var PG_WINDOW_OFFSET = { left: 138, top: 100 };
var MAIL_PAGE = "X6SendMail.aspx";

var _pgUrl = null;
var _pgWindow = null;
var _baseURL = null;
var _EventHandlersSet = null;

function clearEmail(){

	if (document.getElementById("ProductGramControl_Email").value == "type your email address" ){
		document.getElementById("ProductGramControl_Email").value = ""
	}
}

function resetEmail(){

	if (document.getElementById("ProductGramControl_Email").value == "" ){
		document.getElementById("ProductGramControl_Email").value = "type your email address"
	}
}
function clearName(){

	if (document.getElementById("ProductGramControl_Name").value == "type your name" ){
		document.getElementById("ProductGramControl_Name").value = ""
	}
}

function resetName(){

		if (document.getElementById("ProductGramControl_Name").value == ""){
		document.getElementById("ProductGramControl_Name").value = "type your name"
	}
}
function clearAddr1(){

	if (document.getElementById("ProductGramControl_Address1").value == "type friend's email address" ){
		document.getElementById("ProductGramControl_Address1").value = ""
	}
}

function resetAddr1(){

	if (document.getElementById("ProductGramControl_Address1").value == "" ){
		document.getElementById("ProductGramControl_Address1").value = "type friend's email address"
	}
}
function clearAddr2(){

	if (document.getElementById("ProductGramControl_Address2").value == "type friend's email address" ){
		document.getElementById("ProductGramControl_Address2").value = ""
	}
}

function resetAddr2(){

	if (document.getElementById("ProductGramControl_Address2").value == "" ){
		document.getElementById("ProductGramControl_Address2").value = "type friend's email address"
	}
}
function clearAddr3(){

	if (document.getElementById("ProductGramControl_Address3").value == "type friend's email address" ){
		document.getElementById("ProductGramControl_Address3").value = ""
	}
}

function resetAddr3(){

	if (document.getElementById("ProductGramControl_Address3").value == "" ){
		document.getElementById("ProductGramControl_Address3").value = "type friend's email address"
	}
}
function clearMsg(){

	if (document.getElementById("ProductGramControl_CustomMsg").value == "type personal message" ){
		document.getElementById("ProductGramControl_CustomMsg").value = ""
	}
}

function resetMsg(){

	if (document.getElementById("ProductGramControl_CustomMsg").value == "" ){
		document.getElementById("ProductGramControl_CustomMsg").value = "type personal message"
	}
}
function CheckForm() {

	if (document.getElementById("ProductGramControl_Email"))
	{
		if (document.getElementById("ProductGramControl_Email").value == "" ){
			var ErrorLabel = document.getElementById("lblError");
			ErrorLabel.innerHTML = "Please enter your email address";
			document.getElementById("ProductGramControl_Email").focus();
			return false;
		}
		else if (document.getElementById("ProductGramControl_Email").value == "type your email address" ){
			var ErrorLabel = document.getElementById("lblError");
			ErrorLabel.innerHTML = "Please enter your email address";
			document.getElementById("ProductGramControl_Email").focus();
			return false;
		}
	}
	if (document.getElementById("ProductGramControl_Name").value == "")
		{
		var ErrorLabel = document.getElementById("lblError");
		ErrorLabel.innerHTML = "Please enter your name";
		document.getElementById("ProductGramControl_Name").focus();
		return false;
	}
	else if (document.getElementById("ProductGramControl_Name").value == "type your name" ){
		var ErrorLabel = document.getElementById("lblError");
		ErrorLabel.innerHTML = "Please enter your name";
		document.getElementById("ProductGramControl_Name").focus();
		return false;
	}
	if (document.getElementById("ProductGramControl_Address1").value == "" && document.getElementById("ProductGramControl_Address2").value == "" && document.getElementById("ProductGramControl_Address3").value == "")
		{
		var ErrorLabel = document.getElementById("lblError");
		ErrorLabel.innerHTML = "Please enter at least one email address";
		document.getElementById("ProductGramControl_Address1").focus();
		return false;
	}
	else if (document.getElementById("ProductGramControl_Address1").value == "type friend's email address" && document.getElementById("ProductGramControl_Address2").value == "type friend's email address" && document.getElementById("ProductGramControl_Address3").value == "type friend's email address")
		{
		var ErrorLabel = document.getElementById("lblError");
		ErrorLabel.innerHTML = "Please enter at least one email address";
		document.getElementById("ProductGramControl_Address1").focus();
		return false;
	}
	if (document.getElementById("ProductGramControl_Address1").value != "" && document.getElementById("ProductGramControl_Address1").value != "type friend's email address")
	{
		if (document.getElementById("ProductGramControl_Address1").value.indexOf ('@',0) == -1 ||
			document.getElementById("ProductGramControl_Address1").value.indexOf ('.',0) == -1) {
			var ErrorLabel = document.getElementById("lblError");
			ErrorLabel.innerHTML = "An email address must contain the '@' symbol and a '.'";
			document.getElementById("ProductGramControl_Address1").select();
			document.getElementById("ProductGramControl_Address1").focus();
			return false;
		}
	}

	if (document.getElementById("ProductGramControl_Address2").value != "" && document.getElementById("ProductGramControl_Address2").value != "type friend's email address")
	{
		if (document.getElementById("ProductGramControl_Address2").value.indexOf ('@',0) == -1 ||
			document.getElementById("ProductGramControl_Address2").value.indexOf ('.',0) == -1) {
			var ErrorLabel = document.getElementById("lblError");
			ErrorLabel.innerHTML = "An email address must contain the '@' symbol and a '.'";
			document.getElementById("ProductGramControl_Address2").select();
			document.getElementById("ProductGramControl_Address2").focus();
			return false;
		}
	}

	if (document.getElementById("ProductGramControl_Address3").value != "" && document.getElementById("ProductGramControl_Address3").value != "type friend's email address")
	{
		if (document.getElementById("ProductGramControl_Address3").value.indexOf ('@',0) == -1 ||
			document.getElementById("ProductGramControl_Address3").value.indexOf ('.',0) == -1) {
			var ErrorLabel = document.getElementById("lblError");
			ErrorLabel.innerHTML = "An email address must contain the '@' symbol and a '.'";
			document.getElementById("ProductGramControl_Address3").select();
			document.getElementById("ProductGramControl_Address3").focus();
			return false;
		}
	}
	
	if (document.getElementById("ProductGramControl_CustomMsg"))
	{
		if (document.getElementById("ProductGramControl_CustomMsg").value == "type personal message")
		{
			document.getElementById("ProductGramControl_CustomMsg").value = ""
		}
	}
	
	if (document.getElementById("ProductGramControl_Address1"))
	{
		if (document.getElementById("ProductGramControl_Address1").value == "type friend's email address")
		{
			document.getElementById("ProductGramControl_Address1").value = ""
		}
	}
	
	if (document.getElementById("ProductGramControl_Address2"))
	{
		if (document.getElementById("ProductGramControl_Address2").value == "type friend's email address")
		{
			document.getElementById("ProductGramControl_Address2").value = ""
		}
	}
	
	if (document.getElementById("ProductGramControl_Address3"))
	{
		if (document.getElementById("ProductGramControl_Address3").value == "type friend's email address")
		{
			document.getElementById("ProductGramControl_Address3").value = ""
		}
	}
	
	 
		//return true;
		if (!_qvWindow) {return true}
		SendMail();
		
		hidePGWindow();
		return false;
	}
	
function ClearText()
{
		document.getElementById("ProductGramControl_Email").value = "type your email address" ;
		document.getElementById("ProductGramControl_Name").value = "type your name" ;
		document.getElementById("ProductGramControl_Address1").value = "type friend's email address"
		document.getElementById("ProductGramControl_Address2").value = "type friend's email address"
		document.getElementById("ProductGramControl_Address3").value = "type friend's email address"
		document.getElementById("ProductGramControl_CustomMsg").value = "type personal message"
		var ErrorLabel = document.getElementById("lblError")
		if (ErrorLabel) {ErrorLabel.innerHTML = "";}
}
function SendMail()
{
	var mailUrl;
    mailUrl = getSendMailURL();
    
    mailUrl = mailUrl + GetQsForMail();
    sendQVAjaxRequest( mailUrl, retrieveMailResponse);
}

function getSendMailURL ()
{
var currUrl = window.location.href;
var idCurrent = currUrl.substring(0,currUrl.indexOf('/jcp/')+5);
var retUrl = idCurrent + MAIL_PAGE + '?';
return retUrl;
}

function GetQsForMail()
{
var qs;
if (_qvUrl){qs = new Querystring(_qvUrl);}

var retQS;
retQS = 'Email=' + document.getElementById("ProductGramControl_Email").value;
retQS = retQS + '&Name=' + document.getElementById("ProductGramControl_Name").value;
retQS = retQS + '&Address1=' + document.getElementById("ProductGramControl_Address1").value;
retQS = retQS + '&Address2=' + document.getElementById("ProductGramControl_Address2").value;
retQS = retQS + '&Address3=' + document.getElementById("ProductGramControl_Address3").value;
retQS = retQS + '&CustomMsg=' + document.getElementById("ProductGramControl_CustomMsg").value;
if (qs)
{
	retQS = retQS + '&ItemID=' + qs.get('itemID','');
	retQS = retQS + '&GrpTyp=' + qs.get('GrpTyp','');
}
return retQS;
}
function retrieveMailResponse(response)
{
}
function displayPGWindow()
{   
	
    if(browser.IEBrowser && parseInt(browser.version) <= 6) { getBGSelectElements(); }
    
    var left = PG_WINDOW_OFFSET.left;

    var top = Math.floor(document.body.scrollTop + PG_WINDOW_OFFSET.top);
    
    _pgWindow = document.getElementById("PGWindow");
    _pgWindow.style.left = left + "px";
    _pgWindow.style.top = top + "px";
    _pgWindow.style.visibility = "visible";
    _pgWindow.style.display = "block";     

      if(_EventHandlersSet == null) { AddListeners()};
              
      if(browser.IEBrowser && parseInt(browser.version) <= 6) {
        hideCoveredSelectionElements( findLeft(_pgWindow), findTop(_pgWindow), _pgWindow.offsetHeight, _pgWindow.offsetWidth);
		}
	
	//document.getElementById("Email").focus(); 
}

function tagProductPage(ShowAddToBagButton)
{
	if (ShowAddToBagButton) _qvProductPageUrl = _qvProductPageUrl + "&tagpageview=" + ShowAddToBagButton;
	else _qvProductPageUrl = _qvProductPageUrl + "&tagpageview=" + ShowAddToBagButton;
}

function hidePGWindow(chkPG)
{
	ClearText();
    if (_pgWindow != null)
    {
    	_pgWindow.style.display = "none";    
    }
    
    if(browser.IEBrowser && parseInt(browser.version) <= 6) { showAllBackGroundSelectElements(); }
    if (chkPG == null)
    {
    cleanupVariables();
    }
}

function cleanupVariables()
{
    _pgUrl = null;
    
   // _pgWindow = null;
}

/*
 * Product Gram Window - Banner Display Functions
 */

function initializeBanner(data)
{
    var heading = document.getElementById("PGHeading");
    //heading.innerHTML = "Type the email addresses for up to 3 friends. They will receive a message with a picture of this item and a link to jcp.com to view."; 
    heading.innerHTML = "email a friend"; 
}

/*
 * Product Gram Window - Image Display Functions
 */

 function clearTextMessage(elementName)
{
    var Text = document.getElementById(elementName);
    Text.innerHTML = "";
    Text.style.visibility = "hidden";
 }

/*
 * Product Gram Window - Information Display Functions
 */

function initializeInformation(data)
{  
   if(browser.IEBrowser) 
   {
      document.getElementById("PGCloseButton").style.marginTop = "3px";
    }
}

/* Make the appropriate areas of the PGWindow hidden or visible  */
function changeElementDisplay(elementName, displayValue)
{
    var Element = document.getElementById(elementName);
    Element.style.display = displayValue;
}

/*
 * Ajax Functions
 */

var _pgAjaxRequest = null;
var _pgAjaxCallback = null;

function sendAjaxRequest(url, callback)
{
    if (_pgAjaxRequest != null)
    {
        try { _pgAjaxRequest.abort(); } catch (e) { /* fail gracefully */ }
    }

    _pgAjaxCallback = callback;
    
    _pgAjaxRequest = createAjaxRequest();
    _pgAjaxRequest.open("GET", url,  true);
    _pgAjaxRequest.onreadystatechange = handleAjaxResponse;
    _pgAjaxRequest.send(null);
}

function createAjaxRequest()
{
    var request = null;
    try { request = new XMLHttpRequest(); } catch (e1) { 
        try { request = new ActiveXObject("Msxml2.XMLHTTP"); } catch (e2) { 
            try { request = new ActiveXObject("Microsoft.XMLHTTP"); } catch (e3) {
                throw new Exception("Product Gram requires a browser that supports Ajax."); } } }
    return request;
}

function handleAjaxResponse()
{
    if (_pgAjaxRequest.readyState != 4)
    {
        return;
    }
    _pgAjaxCallback(_qvAjaxRequest.responseText);
    _pgAjaxRequest = null;
    _pgAjaxCallback = null;
}

/*
 * Utility Functions
 */

function findLeft(element) 
{
   var curleft = 0; 
   if(element.offsetParent) while(1) {
      curleft += element.offsetLeft; 
      if(!element.offsetParent) break; 
      element = element.offsetParent; 
      }
   else if(element.x) curleft += element.x; 
   return curleft; 
}

function findTop(element) 
{
   var curtop = 0; 
   if(element.offsetParent) while(1) {
      curtop += element.offsetTop; 
      if(!element.offsetParent) break; 
      element = element.offsetParent; 
      }
   else if(element.y) curtop += element.y; 
   return curtop; 
}

function setTextContent(element, text)
{
    var textNode = document.createTextNode(text);
    if (element.childNodes.length > 0)
    {
        element.replaceChild(textNode, element.childNodes[0]);
    }
    else
    {
        element.appendChild(textNode);
    }
}

function clearChildren(element)
{
    for (i=element.childNodes.length-1; i>=0; i--)
    {
        element.removeChild(element.childNodes[i]);
    }
}

/* Utility functions for drag-drop / browser identification   */

function Browser() {

  var BrowserName;
  var usrAgent;
  var pos;

  this.IEBrowser    = false;
  this.MozBrowser    = false;
  this.version = null;
  this.MACOS = false;
  usrAgent = navigator.userAgent;
 
 
 //OSTest
 OSName = "Mac";
   if ((pos = usrAgent.indexOf(OSName)) >= 0) 
  {
    this.MACOS = true;
  }
 
  BrowserName = "MSIE";
  if ((pos = usrAgent.indexOf(BrowserName)) >= 0) 
  {
    this.IEBrowser = true;
    this.version = parseFloat(usrAgent.substr(pos + BrowserName.length));
    return;
  }

  BrowserName = "Netscape6/";
  if ((pos = usrAgent.indexOf(BrowserName)) >= 0) 
  {
    this.MozBrowser = true;
    this.version = parseFloat(usrAgent.substr(pos + BrowserName.length));
    return;
  }

  // Treat any other "Gecko" browser as NS 6.1.

  BrowserName = "Gecko";
  if ((pos = usrAgent.indexOf(BrowserName)) >= 0) 
  {
    this.MozBrowser = true;
    this.version = 6.1;
    return;
  }
  
 
}


var browser = new Browser();

// Global object to hold drag information.

var dragObj = new Object();
dragObj.zIndex = 1000;

function dragStart(event, id) {

  var el;
  var x, y;

    dragObj.elNode = document.getElementById("PGWindow"); 
    if (browser.IEBrowser)
    {
        if(window.event.srcElement.id !== "PGWindowDragHeader"  && window.event.srcElement.id !== "PGHeading") { return; }
    }
    
    if (browser.MozBrowser)
    {
        if(event.target.id !== "PGWindowDragHeader"  && event.target.id !== "PGHeading") { return; }
    }

  // Get cursor position on page.

  if (browser.IEBrowser) {
    x = window.event.clientX + document.documentElement.scrollLeft
      + document.body.scrollLeft;
    y = window.event.clientY + document.documentElement.scrollTop
      + document.body.scrollTop;
  }
  if (browser.MozBrowser) {
    x = event.clientX + window.scrollX;
    y = event.clientY + window.scrollY;
  }

  // Save starting positions of cursor and element.

  dragObj.cursorStartX = x;
  dragObj.cursorStartY = y;
  dragObj.elStartLeft  = parseInt(dragObj.elNode.style.left, 10);
  dragObj.elStartTop   = parseInt(dragObj.elNode.style.top,  10);

  if (isNaN(dragObj.elStartLeft)) dragObj.elStartLeft = 0;
  if (isNaN(dragObj.elStartTop))  dragObj.elStartTop  = 0;

  dragObj.elNode.style.zIndex = ++dragObj.zIndex;

  // attach events to the document
  if (browser.IEBrowser) {
    document.attachEvent("onmousemove", dragIt);
    document.attachEvent("onmouseup",   dragRelease);
    window.event.cancelBubble = true;
    window.event.returnValue = false;
  }
  if (browser.MozBrowser) {
    document.addEventListener("mousemove", dragIt,   true);
    document.addEventListener("mouseup",   dragRelease, true);
    event.preventDefault();
  }
}

function dragIt(event) {

  var x, y;

  // Cursor position on page.
  if (browser.IEBrowser) {
    x = window.event.clientX + document.documentElement.scrollLeft
      + document.body.scrollLeft;
    y = window.event.clientY + document.documentElement.scrollTop
      + document.body.scrollTop;
  }
  if (browser.MozBrowser) {
    x = event.clientX + window.scrollX;
    y = event.clientY + window.scrollY;
  }

  // adjust dragObj coordinates to mouse pointer coordinates.
  dragObj.elNode.style.left = (dragObj.elStartLeft + x - dragObj.cursorStartX) + "px";
  dragObj.elNode.style.top  = (dragObj.elStartTop  + y - dragObj.cursorStartY) + "px";
    
    if(browser.IEBrowser && parseInt(browser.version) <= 6) {
        hideCoveredSelectionElements( findLeft(_pgWindow), findTop(_pgWindow), _pgWindow.offsetHeight, _pgWindow.offsetWidth);
    }

  if (browser.IEBrowser) {
    window.event.cancelBubble = true;
    window.event.returnValue = false;
  }
  if (browser.MozBrowser)
    event.preventDefault();
}


function dragRelease(event) 
{

   if (browser.IEBrowser) {
    document.detachEvent("onmousemove", dragIt);
    document.detachEvent("onmouseup",   dragRelease);
  }
  if (browser.MozBrowser) {
    document.removeEventListener("mousemove", dragIt,   true);
    document.removeEventListener("mouseup",   dragRelease, true);
  }
}


/*
functions to resolved IE 6 bugs
*/

var _BGSelects = new Array();
var _BGSelectionSteps = new Array();

function windowDragCleanup()
{
   _BGSelects = null;
}

function setSelectElementVisibility(element, visible)
{
    var visibility = "hidden";
    if( visible == true) { visibility = "visible";   }

    element.style.visibility = visibility;
}

function getBGSelectElements()
{  
	var sel = document.getElementsByTagName("SELECT");
        if (sel==null) {return;}
        var cnt;
	for(cnt=0; cnt < sel.length;cnt++) {
		_BGSelects[cnt] = sel[cnt]; 
	} 
   
}

function hideCoveredSelectionElements(dragBoxLeft, dragBoxTop, dragBoxHeight, dragBoxWidth)
{
    var NextE;
    var qvWindow = document.getElementById("QVWindow");
    for(NextE=0;  NextE < _BGSelects.length; NextE++) 
    {

        if(IsUncovered(_BGSelects[NextE], dragBoxLeft, dragBoxWidth, dragBoxTop, dragBoxHeight))
	{

		if(qvWindow)
		{
		  if(IsUncovered(_BGSelects[NextE],findLeft(qvWindow),  qvWindow.offsetWidth, findTop(qvWindow), qvWindow.offsetHeight))
		   {			
	            	setSelectElementVisibility(_BGSelects[NextE],true); 
		   }
		   else     		    
		   {
	            	setSelectElementVisibility(_BGSelects[NextE],false); 
		   }
		}
		else
		{
	          setSelectElementVisibility(_BGSelects[NextE],true); 
		}
        }
        else { 
            setSelectElementVisibility(_BGSelects[NextE],false); 
        } 
     } 
}

     

function IsUncovered(element, dragBoxLeft, dragBoxWidth, dragBoxTop, dragBoxHeight)
{
    var elementLeft = findLeft(element);
    var elementWidth = element.offsetWidth;
    var elementRight =  elementLeft + elementWidth;
    var dragBoxRight =  dragBoxLeft + dragBoxWidth;
    var elementTop = findTop(element);
    var elementHeight = element.offsetHeight;   
    var elementBottom =  elementTop + elementHeight;
    var dragBoxBottom =  dragBoxTop + dragBoxHeight;

    if(
       (((elementLeft >= dragBoxLeft) && (elementLeft <= dragBoxRight)) ||
       ((elementRight >= dragBoxLeft) && (elementRight <= dragBoxRight)))  &&
       (((elementTop >= dragBoxTop) && (elementTop <= dragBoxBottom)) ||
       ((elementBottom >= dragBoxTop) && (elementBottom <= dragBoxBottom)))
       )
    {return( false); }
    else {return( true); }
}

function showAllBackGroundSelectElements()
{
   var cnt;
   var qvWindow = document.getElementById("QVWindow");

   var currPageUrl = window.location.href;
   var currPage = currPageUrl.split("?")[0].split("/")[4];

   if ((currPage.toLowerCase() == "x5.aspx") || (currPage.toLowerCase() == "searchdepartment.aspx"))
    {
	var tb = document.getElementById("SelectionSteps");
	var sel = tb.getElementsByTagName("SELECT");
        if (sel==null) {return;}
        var index;
	for(index=0; index < sel.length;index++) {
		_BGSelectionSteps[index] = sel[index]; 
	}  
    }


   for(cnt=0; cnt < _BGSelects.length; cnt++) 
	{

    		if(qvWindow) 
		{
			if(IsUncovered(_BGSelects[cnt],findLeft(qvWindow),  qvWindow.offsetWidth, findTop(qvWindow), qvWindow.offsetHeight))
			{
				_BGSelects[cnt].style.visibility = "visible";
			}
			else
			{
				_BGSelects[cnt].style.visibility = "hidden";
			}
		}
		else
		{
 			_BGSelects[cnt].style.visibility = "visible";
		}

	}

   for(count=0; count < _BGSelectionSteps.length; count++) 
	{
    		if(qvWindow) 
		{		
 			_BGSelectionSteps[count].style.visibility = "visible";
		}
	}     
}

function deactivateProductGram(e)
{
    if(_pgWindow == null) { return; }
    if(document.getElementById("PGWindow").style.visibility == "hidden") { return; }

    var element
    if (!e) var e = window.event
    if (e.target) element = e.target
    else if (e.srcElement) element = e.srcElement

    var par;
    if(element.parentNode) while(1) 
    {
      if(!element.parentNode) break; 
      par = element.parentNode;
      if(par.id != null && par.id == "PGWindow") { return; }
      element = element.parentNode; 
    }

   hidePGWindow();
}

var listeners;

function AddListeners()
{
    // for global navigation menu listening
  var eventName =  'mouseover';
  if (browser.IEBrowser) { eventName =  'onmouseover'; }
  
  AddListener(document.getElementById('nm'), eventName, hidePGWindow); 
  _EventHandlersSet = true;
}

function AddListener(element, functionName, functionCode) 
{
     if (element.addEventListener) {
         element.addEventListener (functionName, functionCode, false );
     } 
     else if (element.attachEvent) {
         element.attachEvent( functionName, functionCode);
     } 
} 
 
 
function RemoveListeners()
{
    // for global navigation menu listening
  var eventName =  'mouseover';
  if (browser.IEBrowser) { eventName =  'onmouseover'; }
  RemoveListener(document.getElementById('nm'), eventName, hidePGWindow);
 _EventHandlersSet = null;
}
 
function RemoveListener(element, event, listener) 
{
    var eventId = getEventId(element, event, listener);
    if (!eventId in listeners)
    return false

    var proxy = listeners[eventId].proxy;
    delete listeners[eventId];

    if (element.removeEventListener)
        element.removeEventListener(event, proxy, false);
    else if (element.detachEvent)
        element.detachEvent(event, proxy);
        
    return true;
}

function getEventId(element, event, listener) {
    var listener = listener.length == 2 ? getObjId(listener[0]) + '_' + getObjId(listener[1]) : getObjId(listener);
    return getObjId(element) + "_" + event + "_" + listener;
}

function getObjId(object) 
{
    var curId;
    if (!object.__eventId) { object.__eventId = ++curId; }
    return object.__eventId;
}

function isNumberKey(evt)
{
 var charCode = (evt.which) ? evt.which : event.keyCode
 if (charCode > 31 && (charCode < 48 || charCode > 57))
    return false;

 return true;
}

function GetDomainUrl(url)
{
var currentUrl;
var domainUrl;
var idCurrent;
var idLink;
domainUrl = url;
currentUrl = window.location.href;

idCurrent = currentUrl.substring(0,currentUrl.indexOf('/jcp/'));

idLink = url.substring(0,url.indexOf('/jcp/'));


if (idCurrent != idLink)
{

	domainUrl = currentUrl.substring(0,currentUrl.indexOf('/jcp/')) + url.substring(url.indexOf('/jcp/'),url.length-1);
	
}

 
 return domainUrl;

}
