/*presentation.js*/

function Link (description, imagePath, url)
  {
    this.description = description;
    this.imagePath = imagePath;
    this.url = url;
  }

function PurchaseOption (addedToBasket, hasMessage, monogramRequested, quantity,
  serviceAgreementRequested, status, message, persistString)
  {
    this.addedToBasket = addedToBasket;
    this.hasMessage = hasMessage;
    this.monogramRequested = monogramRequested;
    this.quantity = quantity;
    this.serviceAgreementRequested = serviceAgreementRequested;
    this.status = status;
    this.message = message;
    this.persistString = persistString;
  }
  
 
  function DeliveryMessage (deliveryCharge, factoryShipWeeks, showAdditionalCharges, showCatalogHomeDelivery,
  showDeliveryCharge, showFactoryShip, showHomeDelivery)
  {
    this.deliveryCharge = deliveryCharge;
    this.factoryShipWeeks = factoryShipWeeks;
    this.showAdditionalCharges =showAdditionalCharges
    this.showCatalogHomeDelivery =  showCatalogHomeDelivery;
    this.showDeliveryCharge = showDeliveryCharge;
    this.showFactoryShip = showFactoryShip;
    this.showHomeDelivery = showHomeDelivery;
    
  }
  
function QuickLink (displayName, onClick, pageName)
  {
    this.displayName = displayName;
    this.onClick = onClick;
    this.pageName = pageName;
  }
  
function RelatedItem (price, link)
  {
    this.price = price;
    this.link = link;
  }
  
function SelectionStep (node)
  {
    var childSteps = new Array();
    var childStepNodes;
    var i;
    this.id = node.getAttribute('id');
    this.isLeaf = (node.getAttribute('isLeaf') == 'True');
    this.isSelected = (node.getAttribute('isSelected') == 'True');
    this.hideval = (node.getAttribute('hideval') == 'True');
    this.DeviceType = node.getAttribute('DeviceType');
    this.Status = node.getAttribute('Status');
    this.description = node.childNodes[0].childNodes[0].nodeValue;
    this.instruction = node.childNodes[1].childNodes[0].nodeValue;
    if (node.childNodes.length == 3)
      {
        childStepNodes = node.childNodes[2];
        for (i=0;i<childStepNodes.childNodes.length;i++)
          {
          childSteps.push(new SelectionStep(childStepNodes.childNodes[i]));
          }
      }
    this.childSteps = childSteps;
  }
  
function ScreenImage (alt, border, imgClass, height, onMouseOut, onMouseOver, src, title, width)
  {
    var i;
    this.alt = alt;
    this.border = border;
    this.imgClass = imgClass;
    this.height = height;
    this.onMouseOut = onMouseOut;
    this.onMouseOver = onMouseOver;
    this.src = src;
    this.title = title;
    this.width = width;
    this.buildProperties = function (propertiesNode)
      {
      var property;
      for (i=0;i<propertiesNode.childNodes.length;i++)
        {
          property = propertiesNode.childNodes[i];
          this[property.nodeName] = property.childNodes[0].nodeValue;
        }
      }
  }
  
  
  function divElem (imgClass, onClick)
  {
    var i;
   
    this.CLASS = imgClass;
    this.ONCLICK = onClick;
    this.Anchor = "";
   
    this.buildProperties = function (propertiesNode)
      {
      var property;
      for (i=0;i<propertiesNode.childNodes.length;i++)
        {
          property = propertiesNode.childNodes[i];
          this[property.nodeName.toUpperCase()] = property.childNodes[0].nodeValue;
        }
      }
  }
  
function Anchor (href, image)
  {
    this.href = href;
    this.image = image;
  }
  
/*function Swatch (anchor)
  {
    this.anchor = anchor;
  }*/
  
  function Swatch (div)
  {
    this.div = div;
  }
    
function Presentation (presentationDocument)
  {
  
    var f;
    var handlers = new Array();
    var docElement;
    var node;
    var i;
    var prop;
    
    docElement = presentationDocument.documentElement;
      
    registerFunctions();
    this.canAddToBag = (docElement.getAttribute('canAddToBag') == 'True');
     
    this.catid = docElement.getAttribute('catid');
   
    this.defaultSwatchDescription = docElement.getAttribute('defaultSwatchDescription');
    this.deptID = docElement.getAttribute('deptID');
    this.enableStoreAvailability = (docElement.getAttribute('enableStoreAvailability') == 'True');
    this.hasServiceAgreement = (docElement.getAttribute('hasServiceAgreement') == 'True');
    this.inStoresOnly = (docElement.getAttribute('inStoresOnly') == 'True');
    this.isEditMode = (docElement.getAttribute('isEditMode') == 'True');
    this.isLoggedIntoGiftRegistry = (docElement.getAttribute('isLoggedIntoGiftRegistry') == 'True');
    this.isMonogrammable = (docElement.getAttribute('isMonogrammable') == 'True');
    this.isPartOfEnsemble = (docElement.getAttribute('isPartOfEnsemble') == 'True');
    this.isPromotion = (docElement.getAttribute('isPromotion') == 'True');
    this.showOnlineExclusive = (docElement.getAttribute('showOnlineExclusive') == 'True');
    this.showProductDetail = (docElement.getAttribute('showProductDetail') == 'True');
    this.showStoreAvailability = (docElement.getAttribute('showStoreAvailability') == 'True');
    this.isArchetype = (docElement.getAttribute('isArchetype') == 'True');
    
    for (i=0;i<docElement.childNodes.length;i++)
      {
        node = docElement.childNodes[i];

        f = handlers[node.nodeName];
        if (f)
          {
            f(this, node);
          }
      }
  
    function registerFunctions()
    {
      handlers['copy'] = function(p, node) { p.copy = node.childNodes[0].nodeValue; }
      handlers['detailInfoURL'] = function(p, node) { p.detailInfoURL = node.childNodes[0].nodeValue; }
      handlers['archetypeNewCustomerLink'] = function(p, node) { p.archetypeNewCustomerLink = node.childNodes[0].nodeValue; }
      handlers['archetypeReturnCustomerLink'] = function(p, node) { p.archetypeReturnCustomerLink = node.childNodes[0].nodeValue; }
      handlers['spinViewLink'] = function(p, node) { p.spinViewLink = node.childNodes[0].nodeValue; }
      handlers['spinViewClickStreamLink'] = function(p, node) { p.spinViewClickStreamLink = node.childNodes[0].nodeValue; }
      handlers['emailLink'] = function(p, node) { p.emailLink = node.childNodes[0].nodeValue; }
      handlers['mainImage'] = function(p, node) { p.mainImage = getLink(node); }
       //handlers['swfScript'] = function(p, node) { p.swfScript =  node.childNodes[0].nodeValue; }
        handlers['MainImageScript'] = function(p, node) { p.MainImageScript =  node.childNodes[0].nodeValue; }
         //handlers['AltViewScript'] = function(p, node) { p.AltViewScript =  node.childNodes[0].nodeValue; }
      handlers['promotionMessage'] = function(p, node) { p.promotionMessage = node.childNodes[0].nodeValue; }
      handlers['StoreInventoryOverlayUrl'] = function(p, node) { p.StoreInventoryOverlayUrl = node.childNodes[0].nodeValue; }
      
      handlers['deliveryMessage']= function(p, node) 
      { 
	  var deliveryCharge = node.getAttribute('deliveryCharge');
          var factoryShipWeeks = node.getAttribute('factoryShipWeeks');
	  var showAdditionalCharges = (node.getAttribute('showAdditionalCharges') == 'True') 
          var showCatalogHomeDelivery = (node.getAttribute('showCatalogHomeDelivery') == 'True');
          var showDeliveryCharge = (node.getAttribute('showDeliveryCharge') == 'True');
          var showFactoryShip = (node.getAttribute('showFactoryShip') == 'True');
          var showHomeDelivery = (node.getAttribute('showHomeDelivery') == 'True');
          p.deliveryMessage = new DeliveryMessage(deliveryCharge,factoryShipWeeks,showAdditionalCharges,showCatalogHomeDelivery,showDeliveryCharge,showFactoryShip,showHomeDelivery);
      
      }
		handlers['message'] = function(p, node) 
  			{
	  			p.messageClass = node.getAttribute('class');
		  		p.message = node.childNodes[0].nodeValue;
			  }
      handlers['productDetailURL'] = function(p, node) { p.productDetailURL = node.childNodes[0].nodeValue; }
      handlers['purchaseOption'] = function(p, node)
        {
          var addedToBasket = (node.getAttribute('addedToBasket') == 'True');
          var hasMessage = (node.getAttribute('hasMessage') == 'True');
          var monogramRequested = (node.getAttribute('monogramRequested') == 'True');
          var quantity = node.getAttribute('quantity');
          var serviceAgreementRequested = (node.getAttribute('serviceAgreementRequested') == 'True');
          var status = node.getAttribute('status');
          var message = node.childNodes[0].childNodes[0].nodeValue;
          var persistString = node.childNodes[1].childNodes[0].nodeValue;
          p.purchaseOption = new PurchaseOption(addedToBasket, hasMessage, monogramRequested,
            quantity, serviceAgreementRequested, status, message, persistString);
        }

     


      handlers['quickLinks'] = function(p, node)
        {
          var ql = new Array();
          var n;
          var displayName;
          var onClick;
          var pageName;
          var i;
          for (i=0;i<node.childNodes.length;i++)
            {
              n = node.childNodes[i];
              displayName = n.childNodes[0].childNodes[0].nodeValue;
              onClick = n.childNodes[1].childNodes[0].nodeValue;
              pageName = n.childNodes[2].childNodes[0].nodeValue;
              ql.push(new QuickLink(displayName, onClick, pageName));
            }
          p.quickLinks = ql;
        }
      handlers['relatedItems'] = function(p, node)
        {
          var ri = new Array();
          var n;
          var price;
          var link;
          var i;
          for (i=0;i<node.childNodes.length;i++)
            {
              n = node.childNodes[i];
              price = n.getAttribute('price');
              link = getLink(n.childNodes[0]);
              ri.push(new RelatedItem(price, link));
            }
          p.relatedItems = ri;  
        }
      handlers['returnURL'] = function(p, node) { p.returnURL = node.childNodes[0].nodeValue; }
      handlers['selectionSteps'] = function (p, node)
        {
          var stepArray = new Array();
          var steps = node.childNodes[0].childNodes[2];
          var i;
          for (i=0;i<steps.childNodes.length;i++)
            {
              stepArray.push(new SelectionStep(steps.childNodes[i]));
            }
          p.selectionSteps = stepArray;
        }
      handlers['stepInstructions'] = function (p, node)
        {
          var inst = new Array();
          var i;
          for (i=0;i<node.childNodes.length;i++)
            {
              inst.push(node.childNodes[i].childNodes[0].nodeValue);
            }
          p.stepInstructions = inst;
        }
      handlers['swatchDisplays'] = function (p, node)
        {
          var swatches = new Array();
          var anchorNode;
          var attributeNode;
          var imageNode;
          var hRef;
          var image;
          var i;
          var divNode;
          var div;
          var anchor;
          for (i=0;i<node.childNodes.length;i++)
            {
            
			  if (node.childNodes[i].nodeName == 'div')
				{
					divNode = node.childNodes[i];
					div = new divElem();
					if (divNode && divNode.childNodes)
					{
						div.buildProperties(divNode.childNodes[0]);
					}
					
					if (divNode.childNodes[1].nodeName == 'anchor')
					{
						anchorNode = divNode.childNodes[1];
						attributeNode = anchorNode.childNodes[0];
						hRef = attributeNode.childNodes[0].childNodes[0].nodeValue;
						imageNode = anchorNode.childNodes[1];
						image = new ScreenImage();
						
						if (imageNode && imageNode.childNodes)
							{
							image.buildProperties(imageNode.childNodes[0]);
							anchor  = new Anchor(hRef, image);
							div.Anchor = anchor;
							swatches.push(new Swatch(div));
							}
					}
					else
					{
						imageNode = divNode.childNodes[1];
						image = new ScreenImage();
						
						image.buildProperties(imageNode.childNodes[0]);
						anchor  = new Anchor('', image);
						div.Anchor = anchor;
						swatches.push(new Swatch(div));
					}
					
					
				}
				/*
					div = new divElem();
					if (i == 0)
					{
					div.CLASS = 'ImageViewClass';
					}
					else
					{
					div.CLASS = '';
					}
					div.ONCLICK = '';
						
              else if (node.childNodes[i].nodeName == 'anchor')
					{
					
					
					anchorNode = node.childNodes[i];
					attributeNode = anchorNode.childNodes[0];
					hRef = attributeNode.childNodes[0].childNodes[0].nodeValue;
					imageNode = anchorNode.childNodes[1];
					image = new ScreenImage();
					if (imageNode && imageNode.childNodes)
						{
						image.buildProperties(imageNode.childNodes[0]);
						anchor  = new Anchor(hRef, image);
						div.Anchor = anchor;
						swatches.push(new Swatch(div));
						//swatches.push(new Swatch(new Anchor(hRef, image)));
						}
					}
				else
					{
					imageNode = node.childNodes[i];
					image = new ScreenImage();
					
					image.buildProperties(imageNode.childNodes[0]);
					anchor  = new Anchor('', image);
					div.Anchor = anchor;
					swatches.push(new Swatch(div));
					//swatches.push(new Swatch(new Anchor('', image)));
					}
					*/
            }
          p.swatches = swatches;
        }
    handlers['serviceAgreement'] = function (p, node)
      {
        p.serviceAgreementDescription = node.childNodes[0].childNodes[0].nodeValue;
        p.serviceAgreementURL = node.childNodes[2].childNodes[0].nodeValue;
      }

    handlers['warranty'] = function (p, node)
      {
        p.warrantyDescription = node.childNodes[0].childNodes[0].nodeValue;
        p.warrantyURL = node.childNodes[2].childNodes[0].nodeValue;
      }
    
    function getLink(node)
      {
        return new Link(node.childNodes[0].childNodes[0].nodeValue,
          node.childNodes[1].childNodes[0].nodeValue,
          node.childNodes[2].childNodes[0].nodeValue);
      }
    }
  }
