from calibre.web.feeds.recipes import BasicNewsRecipe
from calibre.ebooks.BeautifulSoup import BeautifulSoup, Tag
#from random import randint
from urllib import quote

class SportsIllustratedRecipe(BasicNewsRecipe) :
    title          = u'Jon Heyman'
    __author__  = 'kwetal'
    oldest_article = 7
    max_articles_per_feed = 100
    no_stylesheets = True
    #template_css = ''

    feeds = [(u'Jon Heyman', u'http://rss.cnn.com/rss/si_jon_heyman.rss')]

    #keep_only_tags = [dict(name = 'div', attrs = {'class' : 'cnnstoryheadline'})]

    def print_version(self, url) :
        # This is the url and the parameters that work to get the print version.
        printUrl = 'http://si.printthis.clickability.com/pt/printThis?clickMap=printThis'
        printUrl += '&fb=Y&partnerID=2356&url=' + quote(url)
        
        return printUrl
        
        # However the original javascript also uses the following parameters, but they can be left out:
        #   title : can be some random string
        #   random : some random number, but I think the number of digits is important
        #   expire : no idea what value to use
        # All this comes from the Javascript function that redirects to the print version. It's called PT() and is defined in the file 48.js

    def preprocess_html(self, soup) :
        temp = soup.find('div', attrs = {'class' : 'cnnstoryheadline'})
        if temp :
            # It's an article, make a valid content container
            homeMadeSoup = BeautifulSoup('<html><head></head><body></body></html>')
            body = homeMadeSoup.find('body')

            headline = temp.find('h1')
            if headline :
                body.append(headline)

            for td in soup.findAll('td', attrs = {'class' : 'cnnstorycontentarea'}) :
                for p in td.findAll('p') :
                    body.append(p)

            return homeMadeSoup
        else :
            # It's a TOC, just return the whole lot
            return soup

