#!/usr/bin/env python -W ignore::DeprecationWarning

from sys import exit,argv

import pdfhelpers

if __name__=='__main__':
    try:
        if len(argv)>1:
            p=pdfhelpers.pdfsort(argv[1])
        else:
            p=pdfhelpers.pdfsort()
    except pdfhelpers.WrongConfigurationFileError as e:
        print "Wrong configuration file '%s'!\n" %e
        exit()
    except pdfhelpers.NoInputDirectoriesErrorInConfig:
        print "There are no input directories in configuration file!\n"
        exit()
    except pdfhelpers.NoFormatsError:
        print "There are no formats in configuration file!\n"
        exit()
    except pdfhelpers.WrongFormatError as e:
        print "Wrong format '%s'!\n" %e
        exit()
    except pdfhelpers.NoGhostscriptError:
        print "Please install GPL Ghostscript 8.xx (http://pages.cs.wisc.edu/~ghost/)!"
        print "Or check path to it's executable module in 'pdfhelpers.conf'!"
        exit()
    except pdfhelpers.NoPdfTkError:
        print "Please install pdftk 1.xx (http://www.accesspdf.com/pdftk/)!"
        print "Or check path to it's executable module in 'pdfhelpers.conf'!"
        exit()
    except pdfhelpers.NoJavaError:
        print "Please install Java Runtime (http://www.java.com/)!"
        print "Or check path to it's executable module in 'pdfhelpers.conf'!"
        exit()
    try:
        p.sort()
    except pdfhelpers.WritePDFError as e:
        print "Error while writing output file '%s'!\n" %e
        exit()
    except pdfhelpers.ReadPDFError as e:
        print "Error while reading input file '%s'!\n" %e
        exit()
    except pdfhelpers.NotADirectoryError as e:
        print "%s is not a directory" %e
        exit()
    except pdfhelpers.UnableToRemoveError as e:
        print "Unable to remove '%s'!\n" %e
        exit()
    print "Total page number: %u\n" %p.input_page_number
    exit()
