#!/usr/bin/env python -W ignore::DeprecationWarning


import warnings

warnings.simplefilter("ignore")
warnings.warn("deprecated",DeprecationWarning)

from sys import exit
from os import mkdir,remove
from os.path import join,abspath,isfile,isdir,exists,walk
from tempfile import mktemp
from string import lower,capitalize
from time import time,strftime,localtime
from glob import glob
try:
    from pyPdf import PdfFileReader,PdfFileWriter
    from pyPdf.generic import NameObject,NumberObject
except:
    _MSG="Please install pyPdf 1.xx (http://pybrary.net/pyPdf)!"
    raise RuntimeError(_MSG)
    
from subprocess import Popen,PIPE
import ConfigParser

class NoGhostscriptError(Exception):
    pass

class NoPdfTkError(Exception):
    pass

class NoJavaError(Exception):
    pass

class NoInputDirectoriesErrorInConfig(Exception):
    pass

class NoInputDirectoriesError(Exception):
    pass

class NoInputFilesError(Exception):
    pass

class WrongConfigurationFileError(Exception):
    pass

class NoFormatsError(Exception):
    pass

class WrongFormatError(Exception):
    pass

class WritePDFError(Exception):
    pass

class ReadPDFError(Exception):
    pass

class NotADirectoryError(Exception):
    pass

class UnableToRemoveError(Exception):
    pass

class internal_tools:
    def __init__(self):
        pass

    def check_ghostscript(self,gs_name):
        cmd=gs_name+"  --version"
        try:
            f=Popen(cmd,shell=False,stdin=None,stdout=PIPE,stderr=None)
            f.wait()
            lines=f.stdout.readlines()
            f.stdout.close()
            if len(lines)==1:
                if lines[0][0]=='8':
                    return
        except:
            pass
        raise NoGhostscriptError(1)

    def check_pdftk(self,pdftk_name):
        cmd=pdftk_name+"  --version"
        try:
            f=Popen(cmd,shell=False,stdin=None,stdout=PIPE,stderr=None)
            f.wait()
            lines=f.stdout.readlines()
            f.stdout.close()
            for l in lines:
                if l[0:8]=='pdftk 1.':
                    return
        except:
            pass
        raise NoPdfTkError(1)

    def check_java(self,java_name):
        cmd=java_name+"  -version"
        try:
            f=Popen(cmd,shell=False,stdin=None,stdout=PIPE,stderr=PIPE)
            f.wait()
            lines_stdout=f.stdout.readlines()
            lines_stderr=f.stderr.readlines()
            f.stdout.close()
            f.stderr.close()
            for l in lines_stdout:
                if l[0:12]=='java version':
                    return
            for l in lines_stderr:
                if l[0:12]=='java version':
                    return
        except:
            pass
        raise NoJavaError(1)

    def get_page_angle(self,page):
        return page.get("/Rotate",0)

    def set_page_angle(self,page,angle):
        page[NameObject("/Rotate")]=NumberObject(angle)

    def get_media_xy(self,page):
        return [int(page.mediaBox.getUpperRight_x()-\
                page.mediaBox.getLowerLeft_x()),
            int(page.mediaBox.getUpperRight_y()-\
                page.mediaBox.getLowerLeft_y())]

    def get_crop_xy(self,page):
        return [int(page.cropBox.getUpperRight_x()-\
                page.cropBox.getLowerLeft_x()),
            int(page.cropBox.getUpperRight_y()-\
                page.cropBox.getLowerLeft_y())]

    def set_cropbox(self,page,bbox):
        page.cropBox.lowerLeft=(int(bbox[0]),int(bbox[1]))
        page.cropBox.upperRight=(int(bbox[2]),int(bbox[3]))

    def set_mediabox(self,page,bbox):
        page.mediaBox.lowerLeft=(int(bbox[0]),int(bbox[1]))
        page.mediaBox.upperRight=(int(bbox[2]),int(bbox[3]))

class directory_visitor:
    def __init__(self):
        self.input_dirs=None
    def visit(self,action,dir,names):
        for name in names:
            fullname=join(dir,name)
            if isfile(fullname):
                action(fullname)

    def actions(self,action):
        if (self.input_dirs is None) or (len(self.input_dirs)==0):
            raise NoInputDirectoriesError(1)
        else:
            for d in self.input_dirs:
                if exists(d) and isdir(d):
                    walk(d,self.visit,action)
                else:
                    raise NotADirectoryError("'"+d+"'")

class pdfsize(internal_tools):
    def __init__(self):
        pass
    def get_media_sizes(self,name):
        if exists(abspath(name)) and isfile(abspath(name)):
            try:
                input_file=PdfFileReader(file(name,"rb"))
            except:
                raise ReadPDFError(abspath(name))
            for pg in xrange(input_file.getNumPages()):
                page=input_file.getPage(pg)
                print abspath(name)+":page %03u:" %pg+\
                    str(self.get_media_xy(page))
            input_file.stream.close()
        else:
            raise  ReadPDFError(abspath(name))

class pdfcrop(directory_visitor,internal_tools):
    def __init__(self,config_file='',config=None):
        self.input_dirs=None
        if config is None:
            if config_file=='':
                config_file='pdfhelpers.conf'
            if exists(config_file) and isfile(config_file):
                try:
                    self.config=ConfigParser.ConfigParser()
                    self.config.read(config_file)
                except:
                    raise WrongConfigurationFileError(config_file)
        else:
            self.config=config
        try:
            self.pdftk=self.config.get('Main','pdftk')
        except ConfigParser.NoOptionError:
            self.pdftk='pdftk'
        self.check_pdftk(self.pdftk)
        try:
            self.gs=self.config.get('Main','ghostscript')
        except ConfigParser.NoOptionError:
            self.gs='gs'
        self.check_ghostscript(self.gs)
        self.crop_function=self.set_cropbox

    def crop_pdf_page(self,page):
        pdf=PdfFileWriter()
        pdf.addPage(page)
        page_angle=self.get_page_angle(page)
        self.set_page_angle(page,0)
        try:
            cmd=self.gs+"  -sDEVICE=bbox -dNOPAUSE -dBATCH - "
            f=Popen(cmd,shell=True,stdin=PIPE,stdout=PIPE,\
                stderr=PIPE)
            pdf.write(f.stdin)
            f.stdin.flush()
            f.stdin.close()
            f.wait()
            for bbox in f.stderr.readlines():
                bbox=bbox.split(' ')
                if bbox[0][2:7]=='Bound':
                    bbox=bbox[1:]
                    bbox[-1]=bbox[-1][:-1]
                    self.crop_function(page,bbox)
            f.stderr.close()
            f.stdout.close()
        except:
            pass
        self.set_page_angle(page,page_angle)

    def crop_pdf_file(self,name):
        if lower(name[-4:])==".pdf":
            try:
                input_file=PdfFileReader(file(name,"rb"))
                tmp_filename_base=mktemp()+".pdfcrop.tmp."
                for pg in xrange(input_file.getNumPages()):
                    page=input_file.getPage(pg)
                    self.crop_pdf_page(page)
                    pdf=PdfFileWriter()
                    pdf.addPage(page)
                    try:
                        cmd=self.pdftk+" - cat output \""+tmp_filename_base+\
                            "%03u.pdf\" flatten compress" %pg
                        f=Popen(cmd,shell=False,stdin=PIPE,stdout=None)
                        pdf.write(f.stdin)
                        f.stdin.flush()
                        f.stdin.close()
                        f.wait()
                    except:
                        raise WritePDFError(tmp_filename_base+"%03u.pdf" %pg)
                input_file.stream.close()
                try:
                    remove(abspath(name))
                except:
                    raise UnableToRemoveError(abspath(name))
                try:
                    cmd=self.pdftk+" "+tmp_filename_base+"???.pdf"+\
                        " cat output \""+name+"\" flatten compress"
                    f=Popen(cmd,shell=False,stdin=None,stdout=None)
                    f.wait()
                except:
                    raise WritePDFError(name)
                try:
                    for f in glob(tmp_filename_base+"???.pdf"):
                        remove(abspath(f))
                except:
                    raise UnableToRemoveError(abspath(f))
            except:
                raise ReadPDFError(name)

    def crop(self,input_dirs_list):
        self.input_dirs=input_dirs_list
        self.actions(self.crop_pdf_file)

class pdfsort(directory_visitor,internal_tools):
    input_page_number=0
    def __init__(self,config_file=''):
        if config_file=='':
            config_file='pdfhelpers.conf'
        if exists(config_file) and isfile(config_file):
            try:
                self.config=ConfigParser.ConfigParser()
                self.config.read(config_file)
            except:
                raise WrongConfigurationFileError(config_file)
        else:
            raise WrongConfigurationFileError(config_file)
        try:
            self.output_dir=self.config.get('Main','output')
        except ConfigParser.NoOptionError:
            self.output_dir='output'
            self.output_path=''
        try:
            self.input_dirs=self.config.items('InputDirectories')
            for id in xrange(len(self.input_dirs)):
                self.input_dirs[id]=self.input_dirs[id][1]
        except ConfigParser.NoOptionError:
            raise NoInputDirectoriesErrorInConfig("1")
        if len(self.input_dirs)==0:
            raise NoInputDirectoriesErrorInConfig("1")
        try:
            self.pdftk=self.config.get('Main','pdftk')
        except ConfigParser.NoOptionError:
            self.pdftk='pdftk'
        self.check_pdftk(self.pdftk)
        try:
            self.gs=self.config.get('Main','ghostscript')
        except ConfigParser.NoOptionError:
            self.gs='gs'
        self.check_ghostscript(self.gs)
        try:
            self.java=self.config.get('Main','java')
        except ConfigParser.NoOptionError:
            self.java='java'
        self.check_java(self.java)
        try:
            self.pdf2up=self.config.get('Main','pdf2up')
        except ConfigParser.NoOptionError:
            self.pdf2up='pdf2up.jar'
        self.pdf2up_cmd=self.java+" -jar "+self.pdf2up
        self.formats=[]
        try:
            fmts=self.config.items('Formats')
        except ConfigParser.NoOptionError:
            raise NoFormatsError(1)
        if len(fmts)<=1:
            raise NoFormatsError(1)
        for f in self.config.items('Formats'):
            try:
                t=f[1].split(',')
            except:
                raise WrongFormatError(capitalize(f[0]))
            if len(t)<2 or len(t)>3:
                raise WrongFormatError(capitalize(f[0]))
            else:
                if (t[0]=='' or t[1]=='') or (len(t)==3 and t[2]!='2up') :
                    raise WrongFormatError(capitalize(f[0]))
                if len(t)==2:
                    t[0:4]=[int(t[0]),int(t[1]),capitalize(f[0]),0]
                else:
                    t[0:5]=[int(t[0]),int(t[1]),capitalize(f[0]),0,t[2]]
                self.formats[:0]=[t]
        self.formats.append([0,0,'unknown',0])

    def get_pdf_page_format(self,page):
        xy=self.get_media_xy(page)
        for a in self.formats:
            if (a[2]=='unknown') or\
            (a[0]*0.9<=xy[0]<=a[0]*1.1 and a[1]*0.9<=xy[1]<=a[1]*1.1) or\
            (a[0]*0.9<=xy[1]<=a[0]*1.1 and a[1]*0.9<=xy[0]<=a[1]*1.1):
                return a[2]
        return None

    def copy_pdf_page(self,input_file,pg):
        page=input_file.getPage(pg)
        try:
            crop=pdfcrop('',self.config)
            crop.crop_function=crop.set_mediabox
            crop.crop_pdf_page(page)
        except:
            pass
        fmt=self.get_pdf_page_format(page)
        for out in self.formats:
            if out[2]==fmt:
                pdf=PdfFileWriter()
                pdf.addPage(page)
                out[3]+=1
                try:
                    cmd=self.pdftk+" - cat output "+self.output_path+out[2]+\
                        "%03u.pdf flatten compress" % out[3]
                    f=Popen(cmd,shell=False,stdin=PIPE,stdout=None)
                    pdf.write(f.stdin)
                    f.stdin.flush()
                    f.stdin.close()
                    f.wait()
                except:
                    raise WritePDFError(self.output_path+out[2]+"%03u.pdf" \
                        % out[3])

    def copy_pdf_files(self,name):
        if lower(name[-4:])==".pdf":
            try:
                input_file=PdfFileReader(file(name,"rb"))
                self.input_page_number+=input_file.getNumPages()
                for pg in xrange(input_file.getNumPages()):
                    self.copy_pdf_page(input_file,pg)
                input_file.stream.close()
            except:
                raise ReadPDFError(name)

    def sort(self):
        if exists(self.output_dir)==0:
            mkdir(self.output_dir)
        self.output_path=join(self.output_dir,
                        strftime("%Y-%m-%d-%H-%M-%S-",localtime(time())))
        self.actions(self.copy_pdf_files)
        for out in self.formats:
            try:
                if out[3]!=0:
                    cmd=self.pdftk+" "+self.output_path+out[2]+\
                        "???.pdf cat output "+\
                        self.output_path+out[2]+".pdf flatten compress"
                    f=Popen(cmd,shell=False,stdin=None,stdout=None)
                    f.wait()
                    try:
                        for f in glob(self.output_path+out[2]+"???.pdf"):
                            remove(abspath(f))
                    except:
                        raise UnableToRemoveError(abspath(f))
                    if len(out)==5 and out[4]=='2up':
                        cmd=self.pdf2up_cmd+" "+\
                            self.output_path+out[2]+".pdf "+\
                            self.output_path+out[2]+"-nup.pdf"
                        f=Popen(cmd,shell=False,stdin=None,stdout=None)
                        f.wait()
            except:
                raise WritePDFError(self.output_path+out[2]+".pdf")
        return self.input_page_number

if __name__=='__main__':
    exit()
