#!/usr/bin/env python -W ignore::DeprecationWarning

from sys import exit,argv

import pdfhelpers

if __name__=='__main__':
    try:
        if len(argv)==1:
            raise pdfhelpers.NoInputDirectoriesError
        else:
            p=pdfhelpers.pdfcrop()
    except pdfhelpers.WrongConfigurationFileError as e:
        print "Wrong configuration file '%s'!\n" %e
        exit()
    except pdfhelpers.NoInputDirectoriesError:
        print "There are no input directories!\n"
        print "Usage: pdfcrop.py <directory_name>\n"
        exit()
    except pdfhelpers.NoGhostscriptError:
        print "Please install GPL Ghostscript 8.xx (http://pages.cs.wisc.edu/~ghost/)!"
        print "Or check path to it's executable module in 'pdfhelpers.conf'!"
        exit()
    except pdfhelpers.NoPdfTkError:
        print "Please install pdftk 1.xx (http://www.accesspdf.com/pdftk/)!"
        print "Or check path to it's executable module in 'pdfhelpers.conf'!"
        exit()
    try:
        p.crop(argv[1:])
    except pdfhelpers.NoInputDirectoriesError:
        print "There are no input directories! \n"
        exit()
    except pdfhelpers.WritePDFError as e:
        print "Error while writing output file '%s'!\n" %e
        exit()
    except pdfhelpers.ReadPDFError as e:
        print "Error while reading input file '%s'!\n" %e
        exit()
    except pdfhelpers.NotADirectoryError as e:
        print "%s is not a directory!\n" %e
        exit()
    except pdfhelpers.UnableToRemoveError as e:
        print "Unable to remove '%s'!\n" %e
        exit()
    exit()
