package pdf2up;

import java.io.File;
import java.io.FileOutputStream;
import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;

public class pdf2up {

    public static void main(String[] args) {
    	if (args.length < 2) {
    		System.err.println("Too few arguments!");
    		System.err.println("Usage: pdf2up srcfile dstfile");
    		System.err.println("Note: all pages in source must be the same format!");
                return;
    	}
        try{
            float offsetX=0, offsetY=0;
            int i,p;
            File src=new File(args[0]);
            File dst=new File(args[1]);
            PdfReader reader = new PdfReader(src.getAbsolutePath());
            int total=reader.getNumberOfPages();
            Rectangle pageSize,currentSize;
            for(i=0; i<total; i++){
                pageSize=reader.getPageSize(i+1);
                if(offsetX<pageSize.getWidth()) offsetX=pageSize.getWidth();
                if(offsetY<pageSize.getHeight()) offsetY=pageSize.getHeight();
            };
            Rectangle newSize = new Rectangle(offsetX*2+16,offsetY+16);
            Document document = new Document(newSize,0,0,0,0);
            PdfWriter writer = PdfWriter.getInstance(document,
                    new FileOutputStream(dst));
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfImportedPage page;
            for (i = 0; i<total; i++){
		if (i%2==0) {
                    document.newPage();
		}
		p=i+1;
                if(p%2!=0){
                    offsetX=4;
                    offsetY=4;
                }
		currentSize=reader.getPageSize(p);
		page=writer.getImportedPage(reader,p);
		cb.addTemplate(page,1,0,0,1,offsetX,offsetY);
		offsetX+=currentSize.getWidth()+8;
//		offsetY+=(newSize.getHeight()-currentSize.getHeight())/2f-8;
            }
            document.close();
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }
}
