/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox;

import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.Versions;
import com.lowagie.tools.Executable;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Toolbox
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -3766198389452935073L;
    private JDesktopPane desktop;
    private JScrollPane console;
    private Properties toolmap = new Properties();
    private int locationX = 0;
    private int locationY = 0;
    private ArrayList<AbstractTool> toolarray = new ArrayList();
    private Vector<String> menulist = new Vector();
    private Vector<String> menuitemlist = new Vector();

    public Toolbox() {
        this.setSize(600, 500);
        this.setDefaultCloseOperation(3);
        this.setResizable(true);
        this.setTitle("iText Toolbox");
        this.desktop = new JDesktopPane();
        this.setJMenuBar(this.getMenubar());
        this.setIconImage(new ImageIcon(Toolbox.class.getResource("1t3xt.gif")).getImage());
        try {
            Console console = new Console();
            this.console = new JScrollPane(console.textArea);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        JSplitPane jSplitPane = new JSplitPane(0, this.desktop, this.console);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(300);
        this.setContentPane(jSplitPane);
        Toolbox.centerFrame(this);
        this.setVisible(true);
    }

    public static void main(String[] stringArray) {
        try {
            Class.forName("com.lowagie.text.Document");
        }
        catch (ClassNotFoundException classNotFoundException) {
            JOptionPane.showMessageDialog(null, "You need the iText.jar in your CLASSPATH!", classNotFoundException.getClass().getName(), 0);
            System.exit(1);
        }
        Toolbox toolbox = new Toolbox();
        if (stringArray.length > 0) {
            try {
                AbstractTool abstractTool = toolbox.createFrame(stringArray[0]);
                String[] stringArray2 = new String[stringArray.length - 1];
                System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
                abstractTool.setMainArguments(stringArray2);
                abstractTool.execute();
            }
            catch (PropertyVetoException propertyVetoException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
    }

    private JMenuBar getMenubar() {
        Serializable serializable;
        Object object;
        Properties properties = new Properties();
        try {
            properties.load(Toolbox.class.getClassLoader().getResourceAsStream("com/lowagie/toolbox/tools.txt"));
            object = System.getProperty("user.home") + System.getProperty("file.separator") + "tools.txt";
            serializable = new File((String)object);
            if (((File)serializable).isFile() && ((File)serializable).exists()) {
                properties.load(new FileInputStream((String)object));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.toolmap = new Properties();
        object = new JMenuBar();
        serializable = new JMenu("File");
        ((AbstractButton)serializable).setMnemonic(84);
        JMenuItem jMenuItem = new JMenuItem("Close");
        jMenuItem.setMnemonic(67);
        jMenuItem.addActionListener(this);
        ((JMenu)serializable).add(jMenuItem);
        JMenu jMenu = new JMenu("View");
        JMenuItem jMenuItem2 = new JMenuItem("Reset");
        jMenuItem2.addActionListener(this);
        jMenu.add(jMenuItem2);
        JMenu jMenu2 = new JMenu("Tools");
        this.buildPluginMenuItems(new TreeMap<Object, Object>(properties), jMenu2);
        JMenu jMenu3 = new JMenu("Help");
        JMenuItem jMenuItem3 = new JMenuItem("About");
        jMenuItem3.setMnemonic(65);
        jMenuItem3.addActionListener(this);
        jMenu3.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Version");
        jMenuItem4.addActionListener(this);
        jMenu3.add(jMenuItem4);
        ((JMenuBar)object).add((JMenu)serializable);
        ((JMenuBar)object).add(jMenu2);
        ((JMenuBar)object).add(jMenu);
        ((Container)object).add(Box.createGlue());
        ((JMenuBar)object).add(jMenu3);
        return object;
    }

    private void buildPluginMenuItems(Map<Object, Object> map, JMenu jMenu) {
        AbstractButton abstractButton = null;
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            String string;
            String string2 = (String)entry.getKey();
            if (abstractButton == null || !string2.startsWith(abstractButton.getText())) {
                string = string2.substring(0, string2.indexOf(46));
                this.menulist.add(string);
                abstractButton = new JMenu(string);
                jMenu.add((JMenuItem)abstractButton);
            }
            string = string2.substring(abstractButton.getText().length() + 1);
            this.menuitemlist.add(string);
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(this);
            String string3 = (String)entry.getValue();
            try {
                if (Class.forName(string3) == null) continue;
                this.toolmap.put(jMenuItem.getText(), string3);
                ((JMenu)abstractButton).add(jMenuItem);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("Plugin " + string2 + " was not found in your CLASSPATH.");
            }
        }
    }

    public AbstractTool createFrame(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException, PropertyVetoException {
        AbstractTool abstractTool = null;
        String string2 = (String)this.toolmap.get(string);
        abstractTool = (AbstractTool)Class.forName(string2).newInstance();
        this.toolarray.add(abstractTool);
        JInternalFrame jInternalFrame = abstractTool.getInternalFrame();
        jInternalFrame.setLocation(this.locationX, this.locationY);
        this.locationX += 25;
        if (this.locationX > this.getWidth() + 50) {
            this.locationX = 0;
        }
        this.locationY += 25;
        if (this.locationY > this.getHeight() + 50) {
            this.locationY = 0;
        }
        jInternalFrame.setVisible(true);
        this.desktop.add(jInternalFrame);
        jInternalFrame.setSelected(true);
        return abstractTool;
    }

    public static void centerFrame(Frame frame) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = frame.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        frame.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("Close".equals(actionEvent.getActionCommand())) {
            System.out.println("The Toolbox is closed.");
            System.exit(0);
        } else if ("About".equals(actionEvent.getActionCommand())) {
            System.out.println("The iText Toolbox is part of iText, a Free Java-PDF Library.\nVisit http://itexttoolbox.sourceforge.net/ for more info.");
            try {
                Executable.launchBrowser("http://itexttoolbox.sourceforge.net/");
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "The iText Toolbox is part of iText, a Free Java-PDF Library.\nVisit http://itexttoolbox.sourceforge.net/ for more info.");
            }
        } else if ("Reset".equals(actionEvent.getActionCommand())) {
            JInternalFrame[] jInternalFrameArray = this.desktop.getAllFrames();
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < jInternalFrameArray.length; ++i) {
                if (jInternalFrameArray[i].isIcon()) continue;
                try {
                    int n3 = jInternalFrameArray[i].getHeight() - jInternalFrameArray[i].getContentPane().getHeight();
                    jInternalFrameArray[i].setMaximum(false);
                    int n4 = jInternalFrameArray[i].getWidth();
                    int n5 = jInternalFrameArray[i].getHeight();
                    jInternalFrameArray[i].reshape(n, n2, n4, n5);
                    n2 += n3;
                    if ((n += n3) + n4 > this.desktop.getWidth()) {
                        n = 0;
                    }
                    if (n2 + n5 <= this.desktop.getHeight()) continue;
                    n2 = 0;
                    continue;
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        } else if ("Version".equals(actionEvent.getActionCommand())) {
            Versions versions = new Versions();
            Toolbox.centerFrame(versions);
            versions.setVisible(true);
        } else {
            try {
                this.createFrame(actionEvent.getActionCommand());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public Vector<String> getMenulist() {
        return this.menulist;
    }

    public class Console {
        PipedInputStream piOut;
        PipedInputStream piErr;
        PipedOutputStream poOut;
        PipedOutputStream poErr;
        ErrorContext errorcontext = new ErrorContext();
        JTextPane textArea = new JTextPane(new DefaultStyledDocument(this.errorcontext));
        PrintStream oriout;
        PrintStream orierr;

        public Console() throws IOException {
            this.piOut = new PipedInputStream();
            this.poOut = new PipedOutputStream(this.piOut);
            this.oriout = System.out;
            System.setOut(new PrintStream(this.poOut, true));
            this.piErr = new PipedInputStream();
            this.poErr = new PipedOutputStream(this.piErr);
            this.orierr = System.err;
            System.setErr(new PrintStream(this.poErr, true));
            this.textArea.setEditable(false);
            new ReaderThread(this.piOut, "StdOut").start();
            new ReaderThread(this.piErr, "Error").start();
        }

        class ReaderThread
        extends Thread {
            PipedInputStream pi;
            String type;

            ReaderThread(PipedInputStream pipedInputStream, String string) {
                this.pi = pipedInputStream;
                this.type = string;
            }

            public void run() {
                byte[] byArray = new byte[1024];
                while (true) {
                    try {
                        int n;
                        while ((n = this.pi.read(byArray)) != -1) {
                            Document document = Console.this.textArea.getDocument();
                            Style style = Console.this.errorcontext.getStyle(this.type);
                            String string = new String(byArray, 0, n);
                            document.insertString(document.getLength(), string, style);
                            Console.this.oriout.print(string);
                            Console.this.textArea.setCaretPosition(Console.this.textArea.getDocument().getLength());
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        continue;
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                    break;
                }
            }
        }

        class ErrorContext
        extends StyleContext {
            private static final long serialVersionUID = 7766294638325167438L;
            public static final String STDERROR = "Error";
            public static final String STDOUT = "StdOut";

            public ErrorContext() {
                Style style = this.getStyle("default");
                Style style2 = this.addStyle(STDERROR, style);
                StyleConstants.setForeground(style2, Color.RED);
                style2 = this.addStyle(STDOUT, style);
                StyleConstants.setForeground(style2, Color.BLACK);
            }
        }
    }
}

