from xml.dom import minidom
from boto.connection import AWSQueryConnection
import sys
import time
import urllib

AWS_ACCESS_KEY = '<Your access key>'
AWS_SECRET_ACCESS_KEY = '<Your secret access key>'

TEST_ISBN = '9781416551720'     # 13 digit ISBN
#TEST_ISBN = '1416551727'        # 10 digit ISBN
#TEST_ISBN = '14165517'         # Test a bogus ISBN

def get_xml_response(key, secret_key, isbn, group):
    aws_conn = AWSQueryConnection(
    aws_access_key_id=key,
    aws_secret_access_key=secret_key, is_secure=False,
    host='ecs.amazonaws.com')
    aws_conn.SignatureVersion = '2'

    params = dict(
            Service='AWSECommerceService', 
            Operation='ItemLookup', 
            IdType='ISBN', 
            ItemId=isbn,
            SearchIndex='Books',
            AWSAccessKeyId=key,  
            ResponseGroup=group,
            Timestamp=time.strftime("%Y-%m-%dT%H:%M:%S", time.gmtime()))

    verb = 'GET'
    path = '/onca/xml'
    qs, signature = aws_conn.get_signature(params, verb, path)
    qs = path + '?' + qs + '&Signature=' + urllib.quote(signature)
    response = aws_conn._mexe(verb, qs, None, headers={})
    response_xml = minidom.parseString(response.read())
    # Check for errors
    for node in response_xml.getElementsByTagName("Error"):
        try:
            if node.tagName == "Error":
                return ""
            break
        except IndexError:
            break
    return response_xml

respXML = get_xml_response(AWS_ACCESS_KEY, AWS_SECRET_ACCESS_KEY, TEST_ISBN, "ItemAttributes")
if respXML != "":
    title = respXML.getElementsByTagName("Title")[0].firstChild.nodeValue
    print "Title:\t\t\t"+title
else:
    # If this fails, something is no good so don't bother with the rest
    print "Bogus parameters! Bailing..."
    sys.exit()

author = publisher = respXML.getElementsByTagName("Author")[0].firstChild.nodeValue
print "Author:\t\t\t"+author

publisher = respXML.getElementsByTagName("Publisher")[0].firstChild.nodeValue
print "Publisher:\t\t"+publisher

date = respXML.getElementsByTagName("PublicationDate")[0].firstChild.nodeValue
print "Publication Date:\t"+date

pages = respXML.getElementsByTagName("NumberOfPages")[0].firstChild.nodeValue
print "Number of Pages:\t"+pages

respXML = get_xml_response(AWS_ACCESS_KEY, AWS_SECRET_ACCESS_KEY, TEST_ISBN, "Images")
cover = respXML.getElementsByTagName("LargeImage")[0].getElementsByTagName("URL")[0].firstChild.nodeValue
print "Cover URL:\t\t"+cover

respXML = get_xml_response(AWS_ACCESS_KEY, AWS_SECRET_ACCESS_KEY, TEST_ISBN, "Reviews")
rating = respXML.getElementsByTagName("AverageRating")[0].firstChild.nodeValue
print "Average Rating:\t\t"+rating

numreviews = respXML.getElementsByTagName("TotalReviews")[0].firstChild.nodeValue
print "Number of Reviews:\t"+numreviews

respXML = get_xml_response(AWS_ACCESS_KEY, AWS_SECRET_ACCESS_KEY, TEST_ISBN, "Subjects")
tags = ""
for node in respXML.getElementsByTagName("Subject"):
    try:
        tags += node.firstChild.nodeValue+", "
    except IndexError:
        break
print "Tags:\t\t\t"+tags

respXML = get_xml_response(AWS_ACCESS_KEY, AWS_SECRET_ACCESS_KEY, TEST_ISBN, "EditorialReview")
review = respXML.getElementsByTagName("Content")[0].firstChild.nodeValue
print "Editorial Review:\t"+review