#!/usr/bin/env  python
__license__   = 'GPL v3'
__copyright__ = '2008, Kovid Goyal kovid@kovidgoyal.net'
__docformat__ = 'restructuredtext en'

'''
Fetch metadata using Amazon AWS
'''
import re
import sys

from xml.dom import minidom
from boto.connection import AWSQueryConnection
import time
import urllib

def get_xml_response(key, secret_key, isbn, group):
    aws_conn = AWSQueryConnection(
    key_id=key,
    secret_key=secret_key, is_secure=False,
    host='ecs.amazonaws.com')
    aws_conn.SignatureVersion = '2'

    params = dict(
            Service='AWSECommerceService',
            Operation='ItemLookup',
            IdType='ISBN',
            ItemId=isbn,
            SearchIndex='Books',
            AWSAccessKeyId=key,
            ResponseGroup=group,
            Timestamp=time.strftime("%Y-%m-%dT%H:%M:%S", time.gmtime()))

    verb = 'GET'
    path = '/onca/xml'
    qs, signature = aws_conn.get_signature(params, verb, path)
    qs = path + '?' + qs + '&Signature=' + urllib.quote(signature)
    response = aws_conn._mexe(verb, qs, None, headers={})
    response_xml = minidom.parseString(response.read())
    # Check for errors
    for node in response_xml.getElementsByTagName("Error"):
        try:
            if node.tagName == "Error":
                return ""
            break
        except IndexError:
            break
    return response_xml

def get_title(isbn, key, secret_key):
    respXML = get_xml_response(AWS_ACCESS_KEY, AWS_SECRET_ACCESS_KEY, TEST_ISBN, "ItemAttributes")
    title = respXML.getElementsByTagName("Title")[0].firstChild.nodeValue
    if title != "":
        return title
    
def get_author(isbn, key, secret_key):
    respXML = get_xml_response(AWS_ACCESS_KEY, AWS_SECRET_ACCESS_KEY, TEST_ISBN, "ItemAttributes")
    title = respXML.getElementsByTagName("Author")[0].firstChild.nodeValue
    if author != "":
        return author

def get_publisher(isbn, key, secret_key):
    respXML = get_xml_response(AWS_ACCESS_KEY, AWS_SECRET_ACCESS_KEY, TEST_ISBN, "ItemAttributes")
    publisher = respXML.getElementsByTagName("Title")[0].firstChild.nodeValue
    if publisher != "":
        return publisher

def get_publication_date(isbn, key, secret_key):
    respXML = get_xml_response(AWS_ACCESS_KEY, AWS_SECRET_ACCESS_KEY, TEST_ISBN, "ItemAttributes")
    date = respXML.getElementsByTagName("PublicationDate")[0].firstChild.nodeValue
    if date != "":
        return date

def get_pages(isbn, key, secret_key):
    respXML = get_xml_response(AWS_ACCESS_KEY, AWS_SECRET_ACCESS_KEY, TEST_ISBN, "ItemAttributes")
    pages = respXML.getElementsByTagName("NumberOfPages")[0].firstChild.nodeValue
    if pages != "":
        return pages

def get_cover_url(isbn, key, secret_key):
	respXML = get_xml_response(key, secret_key, isbn, "Images")
	cover = respXML.getElementsByTagName("LargeImage")[0].getElementsByTagName("URL")[0].firstChild.nodeValue
	if cover != "":
		return cover

def get_rating(isbn, key, secret_key):
    respXML = get_xml_response(key, secret_key, isbn, "Reviews")
    rating = respXML.getElementsByTagName("AverageRating")[0].firstChild.nodeValue
    if rating != "":
        return rating

def get_num_ratings(isbn, key, secret_key):
    respXML = get_xml_response(key, secret_key, isbn, "Reviews")
    rating = respXML.getElementsByTagName("TotalReviews")[0].firstChild.nodeValue
    if rating != "":
        return rating

def get_tags(isbn, key, secret_key):
    respXML = get_xml_response(key, secret_key, isbn, "Subjects")
    tags = ""
    for node in respXML.getElementsByTagName("Subject"):
        try:
            tags += node.firstChild.nodeValue+", "
        except IndexError:
            break
    if tags != "":
        return tags

def get_editorial_review(isbn, key, secret_key):
    respXML = get_xml_response(key, secret_key, isbn, "EditorialReview")
    review = respXML.getElementsByTagName("Content")[0].firstChild.nodeValue
    if review != "":
        return review

def main(args=sys.argv):
    print 'Title:', get_title(args[1], args[2], args[3])
    print 'Author:', get_author(args[1], args[2], args[3])
    print 'Publisher:', get_publisher(args[1], args[2], args[3])
    print 'Publication Date:', get_publication_date(args[1], args[2], args[3])
    print 'Pages:', get_pages(args[1], args[2], args[3])
    print 'Cover:', get_rating(args[1], args[2], args[3])
    print 'Rating:', get_rating(args[1], args[2], args[3])
    print 'Num Ratings:', get_num_ratings(args[1], args[2], args[3])
    print 'Tags:', get_tags(args[1], args[2], args[3])
    print 'EditorialReview:', get_editorial_review(args[1], args[2], args[3])
    return 0

if __name__ == '__main__':
    sys.exit(main())

main(args=['', '<ISBN>', '<Your AWS access key>', '<Your AWS secret access key>'])