----------------------------------------------------------------------
-- filebrowser: not yet
--
-- Copyright (C) 2009  Iñigo Serna <inigoserna@gmail.com>
-- Time-stamp: <2009-10-31 21:09:24 inigo>


require("lfs")

require("lgob.gtk")
require("lgob.gdk")
require("lgob.gobject")
require("lgob.pango")


---------- Vars -------------------------------------------------------

-- constants
PATH = "/home/inigo/Desktop/iliad/"
PATH = "/mnt/free/"
-- PATH = "/"
-- PATH = "/mnt/card/books/Literature/s.XX/Arthur Conan Doyle/"
SORTBY_NONE, SORTBY_NAME, SORTBY_NAME_REV, SORTBY_DATE, SORTBY_DATE_REV,
             SORTBY_SIZE, SORTBY_SIZE_REV = 0, 1, 2, 3, 4, 5, 6
TV_COL_FILE, TV_COL_TYPE, TV_COL_SIZE, TV_COL_MTIME, TV_COL_PATH,
             TV_COL_SELECTED, TV_COL_SIZE_NUM = 0, 1, 2, 3, 4, 5, 6

-- variables
local path = PATH
local opts = { SORT = SORTBY_NAME,
               SORT_MIX_CASES = true,
               SORT_MIX_DIRS_AND_FILES = false }
local tbl_path
local selected_num, selected_size = 0, 0
local ev_x = 1000

-- ui
local lbl_path
local model, iter, selection
local status_txt2, status_txt3, st_selected, st_selected_btn


---------- Utils ------------------------------------------------------

-- format_datetime: return a formated string of date
function format_datetime(timestamp)
   return os.date('%d/%m/%Y %H:%M', timestamp)
end


-- format_size: return a formated string of size
function format_size(size)
   if size >= 1000000 then
      return string.format('%.2f', size/(1024*1024)) .. 'MB'
   elseif size >= 1000 then
      return string.format('%.2f', size/1024) .. 'KB'
   else
      return tostring(size) .. 'B'
   end
end


-- get_filetype: return file extension
function get_filetype(fname, mode)
   if mode == 'directory' then
      return '<dir>'
   elseif mode == 'link' then
      return '<link>'
   else
      local s, e, ext = string.find(fname, "%.(%w+)$")
      return ext or 'file'
   end
end


-- get_files
function get_files(path)
   local entries = {}
   local fullpath
   local curdir = lfs.currentdir()
   local ret = lfs.chdir(path)
   lfs.chdir(curdir)
   if not ret then return nil end
   for f in lfs.dir(path) do
      if f ~= "." and f ~= ".." then
         local file = {}
         if path:sub(-1) == '/' then
            fullpath = path .. f
         else
            fullpath = path .. '/' .. f
         end
         local attr = lfs.symlinkattributes(fullpath)
         file.name = f
         file.type = get_filetype(fullpath, attr.mode) or 'unknown'
         file.size = attr.size or 0
         file.mtime = attr.modification or 0
         if attr.mode == 'directory' then
            if fullpath:sub(-1) ~= '/' then fullpath = fullpath .. '/' end
         end
         file.path = fullpath
         entries[f] = file
      end
   end
   table.sort(entries)
   return entries
end


-- sort_files: return an iterator with files ordered
function sort_files(t)
   -- sort functions
   local sortfunc
   if opts.SORT == SORTBY_NAME then
      if opts.SORT_MIX_CASES then
         sortfunc = function(s1, s2) return (string.lower(s1) < string.lower(s2)) end
      else
         sortfunc = function(s1, s2) return (s1 < s2) end
      end
   elseif opts.SORT == SORTBY_NAME_REV then
      if opts.SORT_MIX_CASES then
         sortfunc = function(s1, s2) return (string.lower(s1) > string.lower(s2)) end
      else
         sortfunc = function(s1, s2) return (s1 > s2) end
      end
   elseif opts.SORT == SORTBY_DATE then
      sortfunc = function(s1, s2) return (t[s1].mtime < t[s2].mtime) end
   elseif opts.SORT == SORTBY_DATE_REV then
      sortfunc = function(s1, s2) return (t[s1].mtime > t[s2].mtime) end
   elseif opts.SORT == SORTBY_SIZE then
      sortfunc = function(s1, s2) return (t[s1].size < t[s2].size) end
   elseif opts.SORT == SORTBY_SIZE_REV then
      sortfunc = function(s1, s2) return (t[s1].size > t[s2].size) end
   end
   -- mix dirs and files
   local a = {}
   if opts.SORT_MIX_DIRS_AND_FILES then
      for n in pairs(t) do table.insert(a, n) end
      table.sort(a, sortfunc)
   else
      local b = {}
      for n in pairs(t) do
         if t[n].type=='<dir>' then
            table.insert(a, n)
         else
            table.insert(b, n)
         end
      end
      table.sort(a, sortfunc)
      table.sort(b, sortfunc)
      for _, n in ipairs(b) do table.insert(a, n) end
   end
   local function iter()
       for _, el in ipairs(a) do coroutine.yield(el, t[el]) end
   end
   return coroutine.wrap(iter)
end


---------- UI ---------------------------------------------------------
-- callbacks
local function cb_row_selected(widget)
   if ev_x >= 1000 then return end
   local res, m = selection:get_selected(iter)
   if res then
      type = m:get(iter, TV_COL_TYPE)
      if type == "<dir>" and ev_x <= 430 then
         path = m:get(iter, TV_COL_PATH)
         ui_refresh(path)
      end
   end
end


local function cb_file_selected(data, pathiter)
       model:get_iter_from_string(iter, pathiter)
       select = not model:get(iter, TV_COL_SELECTED)
       model:set(iter, TV_COL_SELECTED, select)
       if select then
          selected_num = selected_num + 1
          selected_size = selected_size + model:get(iter, TV_COL_SIZE_NUM)
       else
          selected_num = selected_num - 1
          selected_size = selected_size - model:get(iter, TV_COL_SIZE_NUM)
       end
       ui_update_status_selected()
end


local function cb_treeview_click(widget, ev)
   local _, x, y = gdk.Event.get_coords(ev)
   ev_x = x
end


local function helper_path(x)
   local newpath, otherpath
   for i, val in ipairs(tbl_path) do
      if x >= val[1] then newpath = tbl_path[i+1][2] end
   end
   newpath = newpath or '/'
   if newpath == '/' then
      otherpath = path:sub(2, -1)
   else
      otherpath = path:gsub(newpath, "")
   end
   return newpath, otherpath
end


local function cb_inside_path(widget, ev)
   local _, x, y = gdk.Event.get_coords(ev)
   local newpath, oldpath, buf
   newpath, otherpath = helper_path(x)
   buf = "<span weight='bold'><u>" .. newpath .. "</u></span>"
   buf = buf .. "<span weight='bold'>" .. otherpath .. "</span>" 
   lbl_path:set_markup(buf)
end


local function cb_outside_path()
   lbl_path:set_markup("<span weight='bold'>" .. path .. "</span>")
end


local function cb_click_path(widget, ev)
   local _, x, y = gdk.Event.get_coords(ev)
   local newpath, oldpath
   newpath, otherpath = helper_path(x)
   path = newpath
   ui_refresh(path)
end


-- init UI
local function ui_init()
   win = gtk.Window.new()
   win:set("title", "File Explorer", "border-width", 20)
   win:connect("delete-event", gtk.main_quit)

   -- header: title and quit button
   local hbox = gtk.HBox.new(false, 10)
   local evbox = gtk.EventBox.new()
   evbox:modify_bg(gtk.STATE_NORMAL, gdk.color_parse("black"))
   local title = gtk.Label.new()
   title:set_markup("<span size='xx-large' color='white' weight='bold'>Iliad File Explorer</span>")
   evbox:add(title)
   hbox:pack_start(evbox, true, true, 0)
   local btn_quit = gtk.Button.new()
   local img = gtk.Image.new_from_file("_files/quit.png")
   -- btn_quit:connect("clicked", function () win:hide(); win:destroy() end)
   btn_quit:connect("clicked", gtk.main_quit)
   btn_quit:add(img)
   hbox:pack_end(btn_quit, false, false, 0)

   -- path
   local hb_path = gtk.HBox.new(false, 10)
   local ev_path = gtk.EventBox.new()
   ev_path:set_events(gdk.LEAVE_NOTIFY_MASK + gdk.POINTER_MOTION_MASK + gdk.POINTER_MOTION_HINT_MASK + gdk.BUTTON_PRESS_MASK)
   ev_path:connect("leave-notify-event", cb_outside_path)
   ev_path:connect("motion-notify-event", cb_inside_path, ev_path)
   ev_path:connect("button-press-event", cb_click_path, ev_path)
   lbl_path = gtk.Label.new()
   -- lbl_path:set("ellipsize", pango.ELLIPSIZE_END)
   lbl_path:set_markup(" ")
   ev_path:add(lbl_path)
   hb_path:pack_start(ev_path, false, false, 0)
   hb_path:pack_start(gtk.Label.new(""), true, true, 0)
   
   -- renderers for treeview
   local renderer_name = gtk.CellRendererText.new()
   renderer_name:set("scale-set", true, "scale", 0.75, "xpad", 5, "xalign", 0,
                     "ellipsize-set", true, "ellipsize", pango.ELLIPSIZE_MIDDLE)
   local renderer_center = gtk.CellRendererText.new()
   renderer_center:set("scale-set", true, "scale", 0.75, "xpad", 5, "xalign", 0.5)
   local renderer_right = gtk.CellRendererText.new()
   renderer_right:set("scale-set", true, "scale", 0.75, "xpad", 5, "xalign", 1)
   local rend_select = gtk.CellRendererToggle.new()
   rend_select:connect("toggled", cb_file_selected)

   -- treeview
   -- filename, type, size, mtime, fullpath, selected?
   model = gtk.TreeStore.new("gchararray", "gchararray", "gchararray",
                             "gchararray", "gchararray", "gboolean", "glong")
   local view = gtk.TreeView.new()
   view:set("rules-hint", true, "model", model)
   view:connect("button-press-event", cb_treeview_click)
   iter = gtk.TreeIter.new()
   selection = view:get_selection()
   selection:set_mode(gtk.SELECTION_BROWSE)
   selection:connect("changed", cb_row_selected, widget)

   -- columns
   local cols = { {"Filename", renderer_name, 370}, {"Type", renderer_center, 60},
                  {"Size", renderer_right, 100}, {"MTime", renderer_right, 155} }
   for i, coldef in ipairs(cols) do
      local col = gtk.TreeViewColumn.new_with_attributes(coldef[1], coldef[2], "text", i-1)
      col:set("sizing", gtk.TREE_VIEW_COLUMN_FIXED, "fixed-width", coldef[3])
      view:append_column(col)
   end
   local col_select = gtk.TreeViewColumn.new_with_attributes(" ", rend_select,
                                                             "active", TV_COL_SELECTED)
   col_select:set("sizing", gtk.TREE_VIEW_COLUMN_FIXED, "fixed-width", 25)
   view:append_column(col_select)
 
   local scrollwin = gtk.ScrolledWindow.new()
   scrollwin:set("hscrollbar-policy", gtk.POLICY_NEVER,
                 "vscrollbar-policy", gtk.POLICY_ALWAYS)
   scrollwin:add(view)
   
   -- statusbar
   local hb_status = gtk.HBox.new(false, 20)
   local frame = gtk.Frame.new()
   frame:set("shadow-type", gtk.SHADOW_ETCHED_OUT)
   status_txt2 = gtk.Label.new("   ")
   frame:add(status_txt2)
   hb_status:pack_start(frame, true, true, 0)

   local frame = gtk.Frame.new()
   frame:set("shadow-type", gtk.SHADOW_ETCHED_OUT)
   status_txt3 = gtk.Label.new("   ")
   frame:add(status_txt3)
   hb_status:pack_start(frame, false, false, 0)

   st_selected_btn = gtk.Button.new_from_stock("gtk-open")
   st_selected_btn:set("sensitive", false)
   hb_status:pack_end(st_selected_btn, false, false, 0)
   local frame = gtk.Frame.new()
   frame:set("shadow-type", gtk.SHADOW_ETCHED_OUT)
   st_selected = gtk.Label.new("  ")
   frame:add(st_selected)
   hb_status:pack_end(frame, false, false, 0)

   -- widgets packaging
   local vbox = gtk.VBox.new(false, 20)
   vbox:pack_start(hbox, false, false, 10)
   vbox:pack_start(hb_path, false, false, 0)
   vbox:pack_start(scrollwin, true, true, 0)
   vbox:pack_start(hb_status, false, false, 0)
   win:add(vbox)

   -- show
   win:fullscreen()
   win:show_all()
end


function ui_update_path()
   lbl_path:set_markup("<span weight='bold'>" .. path .. "</span>")
   local ps = { '/'}
   path:gsub('([^/]+)/', function (p) table.insert(ps, p..'/') end)
   local l = gtk.Label.new()
   local w = 0
   local fp = ""
   tbl_path = {}
   for _, p in ipairs(ps) do
      l:set_markup("<span weight='bold'>" .. p .. "</span>")
      local layout = l:get_layout()
      local s = layout:get_pixel_size()
      w = w + layout:get_pixel_size()
      fp = fp .. p
      table.insert(tbl_path, {w, fp})
   end
end


function ui_update_status_selected()
   if selected_num == 0 then
      buf = "<span size='small'> No files selected </span>"
      st_selected_btn:set("sensitive", false)
   else
      buf = string.format("<span size='small'> %d files selected, %s </span>",
                          selected_num, format_size(selected_size))
      st_selected_btn:set("sensitive", true)
   end
   st_selected:set_markup(buf)
end


local function ui_update_files(path)
   local files = get_files(path)
   if not files then return end
   local myiter = gtk.TreeIter.new()
   for f, attr in sort_files(files) do
      model:append(myiter)
      -- filename, type, size, mtime, fullpath, selected?
      model:set(myiter, TV_COL_FILE, attr.name, TV_COL_TYPE, attr.type,
                TV_COL_SIZE, format_size(attr.size),
                TV_COL_MTIME, format_datetime(attr.mtime),
                TV_COL_PATH, attr.path, TV_COL_SELECTED, false,
                TV_COL_SIZE_NUM, attr.size)
   end
end


function ui_splash(path)
   local splash = gtk.Window.new(gtk.WINDOW_TOPLEVEL)
   splash:set("window-position", gtk.WIN_POS_CENTER, "decorated", false,
              "width-request", 500, "height-request", 150,
              "resizable", false, "border-width", 20, "app-paintable", true)
   local frame = gtk.Frame.new()
   local vbox = gtk.VBox.new(true, 0)
   local line1 = gtk.Label.new()
   line1:set_markup("Please, wait while loading directory")
   vbox:pack_start(line1, true, true, 10)
   local line2 = gtk.Label.new()
   line2:set_markup("<i>" .. path .. "</i>")
   line2:set("ellipsize", pango.ELLIPSIZE_START)
   vbox:pack_start(line2, true, true, 10)
   frame:add(vbox)
   splash:add(frame)
   splash:show_all()
   while gtk.events_pending() do
      gtk.main_iteration()
   end
   return splash
end

function ui_refresh(path)
   local splash = ui_splash(path)
   selected_num, selected_size = 0, 0
   ev_x = 1000
   model:clear()
   ui_update_path() 
   ui_update_files(path)
   ui_update_status_selected()
   splash:hide()
   splash:destroy()
end


---------- Main -------------------------------------------------------
ui_init()
ui_refresh(PATH)

gtk.main()


----------------------------------------------------------------------

-- todo:
--   . change dir
--   . change toggle by custom image
--   . actions: copy, cut, paste, delete
--   . bookmarks
--   . status: free space
--   . file icon
--   . actions+: rename, make_dir, show_details, view_file
--   . actions++: open_file
