require ("lfs")
local gtk = require("lgob.gtk")             -- Binding for GTK+
local gdk = require("lgob.gdk")             -- Binding for GDK

--function to open an image file chosen by user
function open_file()
	local dialog = gtk.FileChooserDialog.new("Select the file", window, gtk.FILE_CHOOSER_ACTION_OPEN, "gtk-cancel", gtk.RESPONSE_CANCEL, "gtk-ok", gtk.RESPONSE_OK)
	local filter = gtk.FileFilter.new()
	filter:add_pattern("*.jpg")
	filter:add_pattern("*.png")
	filter:add_pattern("*.gif")
	filter:add_pattern("*.bmp")
	filter:add_pattern("*.jpeg")
	filter:set_name("Image files")
	dialog:add_filter(filter)

	local response = dialog:run()

	dialog:hide()

	if response == -6 then
      	--do nothing
      	print ("User click Cancel.")
    else
    	local filename =  dialog:get_filename()
		print (filename)
		buf = gdk.Pixbuf.new_from_file(filename)
		fg_image:set_from_pixbuf(buf)
  end
    
  dialog:destroy()

end

--main program start here
print ("Running image viewer...")

window = gtk.Window.new(gtk.WINDOW_TOPLEVEL)

window:set("title", "Lua Image Viewer", "window-position", gtk.WIN_POS_CENTER,
"app-paintable", true, "width-request", 768, "height-request", 935)

	-- Actions
	local a_open_file = gtk.Action.new("Open File", nil, "Open a file", "gtk-open")
	a_open_file:connect("activate", open_file)
	
	local a_quit = gtk.Action.new("Quit", nil, "Quit from the application", "gtk-quit")
	a_quit:connect("activate", gtk.main_quit)

	-- Toolbar
	local toolbar = gtk.Toolbar.new()
	toolbar:add(a_open_file:create_tool_item())
	toolbar:add(gtk.SeparatorToolItem.new())
	toolbar:add(a_quit:create_tool_item())
	
window:connect("delete-event", gtk.main_quit)

local vbox = gtk.VBox.new(false, 5)
buf = gdk.Pixbuf.new_from_file("lua.gif")
fg_image = gtk.Image.new_from_pixbuf(buf)
local viewport = gtk.Viewport.new()

gtk.Container.add(viewport, fg_image);

local scroll = gtk.ScrolledWindow.new()
scroll:add_with_viewport(viewport)

vbox:pack_start(toolbar, false, false, 0)
vbox:pack_start(scroll, true, true, 0)

window:add(vbox)
window:show_all()
gtk.main()