
from pylrs.pylrs import *

"""
    This program creates an lrf file with "Hello, World!" on the only page.
    The programs uses the "autoappend" form of the classes.  For example,
    
    page = book.Page()

    This is equivalent to:

    page = Page()
    book.append(page)

    TextBlocks can be added to any page at any time, since the entire book is
    kept in memory.  Text can also be added to any paragraph at any time.

"""

def helloworld():
    # create the book
    book = Book()

    # add a page to the book using the default page style
    page = book.Page()

    # add a textblock to the page using defaults for TextStyle and BlockStyle 
    textBlock = page.TextBlock()

    # add a paragraph to the text block 
    textBlock.Paragraph("Hello, World!")

    # generate the lrf file
    book.renderLrf("books/helloworld.lrf")


if __name__ == "__main__":
    helloworld()
