* [pdfread] </viewvc/pdfread/> / trunk </viewvc/pdfread/trunk/> / src
</viewvc/pdfread/trunk/src/> / output.py
</viewvc/pdfread/trunk/src/output.py?view=log> *

(logo) <http://sourceforge.net>


  View of /trunk/src/output.py

Parent Directory Parent Directory </viewvc/pdfread/trunk/src/> |
Revision Log Revision Log
</viewvc/pdfread/trunk/src/output.py?view=log#rev7>

------------------------------------------------------------------------
Revision *7* </viewvc/pdfread?view=rev&revision=7> - (*download*
</viewvc/*checkout*/pdfread/trunk/src/output.py?revision=7>) (*as text*
</viewvc/*checkout*/pdfread/trunk/src/output.py?revision=7&content-type=text%2Fplain>)
(*annotate* </viewvc/pdfread/trunk/src/output.py?annotate=7>)
/Wed Apr 18 12:24:22 2007 UTC/ (5 days, 6 hours ago) by /ashish_kulz/
File size: 6369 byte(s)

first cut at working code

    1 ## Copyright (c) 2007 Ashish Kulkarni
    2 ##
    3 ## Permission is hereby granted, free of charge, to any person obtaining a
    4 ## copy of this software and associated documentation files (the "Software"),
    5 ## to deal in the Software without restriction, including without limitation
    6 ## the rights to use, copy, modify, merge, publish, distribute, sublicense,
    7 ## and/or sell copies of the Software, and to permit persons to whom the
    8 ## Software is furnished to do so, subject to the following conditions:
    9 ##
   10 ## The above copyright notice and this permission notice shall be included in
   11 ## all copies or substantial portions of the Software.
   12 ##
   13 ## THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   14 ## IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   15 ## FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   16 ## AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   17 ## LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
   18 ## FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
   19 ## DEALINGS IN THE SOFTWARE.
   20 
   21 
   22 import os, sys, shutil, traceback
   23 
   24 from common import *
   25 
   26 
   27 ########################################################## HTML OUTPUT
   28 
   29 
   30 """ support for HTML output """
   31 class HtmlOutput(BaseOutput):
   32   __plugin__ = 'html'
   33 
   34   """ generate an HTML table-of-contents """
   35   def toc_text(self):
   36     current  = 0
   37     toc_text = ''
   38     toc_map  = self.input.toc_map
   39 
   40     for title_, level_, page_ in self.input.toc:
   41       title, level, page = title_.strip(), int(level_), int(page_)
   42 
   43       if level > current:
   44         current = level
   45         toc_text += '<ul>'
   46       elif current > level:
   47         current = level
   48         toc_text += '</ul>'
   49 
   50       toc_text += '<li><a href="#img%d">%s</a></li>' % (toc_map[page], title)
   51 
   52     while current > 0:
   53       toc_text += '</ul>'
   54       current  = current - 1
   55 
   56     return toc_text
   57 
   58   """ generate an HTML file """
   59   def generate(self):
   60     output = """
   61 <html>
   62  <head>
   63   <title>%(title)s</title>
   64   <meta name="author"   content="%(author)s">
   65   <meta name="genre"    content="%(category)s">
   66   <meta name="category" content="%(category)s">
   67  </head>
   68  <body>
   69    <h1 align="center">%(title)s</h1>
   70    %(toc)s""" % dict(title=self.title, author=self.author,
   71                      category=self.category, toc=self.toc_text())
   72 
   73     for i in range(self.n):
   74       name = IMAGENAME_SPEC % i
   75       if os.path.exists(name):
   76         output += '<p><a name="img%d"></a><img src="%s"/></p>\n' % (i, name)
   77     output += '</body></html>'
   78     write_file('ebook.html', output)
   79 
   80     return False
   81 
   82 
   83 ############################################################ RB OUTPUT
   84 
   85 
   86 """ support for Rocket eBook (RB) output """
   87 class RocketBookOutput(HtmlOutput):
   88   __plugin__ = 'rb'
   89 
   90   """ generate a rocket ebook """
   91   def generate(self):
   92 
   93     HtmlOutput.generate(self)
   94 
   95     if COMMANDS['rbmake']:
   96       p('\nCreating Rocket eBook ... ')
   97       call('rbmake', '-beio', 'ebook.rb', 'ebook.html')
   98       p('done.\n')
   99 
  100       if self.output:
  101         shutil.move('ebook.rb', self.output)
  102         return True
  103 
  104     return False
  105 
  106 
  107 ########################################################### IMP OUTPUT
  108 
  109 
  110 """ support for IMP output """
  111 class ImpOutput(HtmlOutput):
  112 
  113   """ generate a IMP for the specified device """
  114   def generate_imp(self, device):
  115 
  116     HtmlOutput.generate(self)
  117 
  118     if sys.platform != 'win32':
  119       p('IMP creation disabled (works only on Windows).\n')
  120       return False
  121 
  122     p('\nCreating IMP file ... ')
  123     try:
  124       from win32com.client import Dispatch
  125       from win32com.client import gencache
  126 
  127       gencache.is_readonly = False
  128       gencache.EnsureModule('{1103EA00-3A0C-11D3-A6F6-00104B2947FB}', 0, 1, 0)
  129 
  130       builder = Dispatch('SBPublisher.Builder')
  131       project = Dispatch('SBPublisher.Project')
  132 
  133       project.AuthorFirstName = self.author
  134       project.BookTitle       = self.title
  135       project.Category        = self.category
  136 
  137       project.BookFileName    = 'ebook'
  138       project.OutputDirectory = '.'
  139       project.BuildTarget     = device
  140       project.Compress        = True
  141       project.Encrypt         = False
  142       project.KeepAnchors     = True
  143       project.Language        = 'en'
  144       project.RequireISBN     = False
  145       project.Zoom            = 2
  146 
  147       project.AddSourceFile('ebook.html')
  148       project.Save('ebook.opf')
  149       builder.Build(project)
  150 
  151       p('done.\n')
  152 
  153       if self.output:
  154         shutil.move('ebook.imp', self.output)
  155         return True
  156 
  157     except:
  158       print 'failed, error details follow.\n'
  159       traceback.print_exc(file=sys.stdout)
  160 
  161     return False
  162 
  163 """ support for IMP output for the FullVga profile """
  164 class FullVgaImpOutput(ImpOutput):
  165   __plugin__ = 'imp1'
  166 
  167   def generate(self):
  168     self.generate_imp(1)
  169 
  170 """ support for IMP output for the HalfVga profile """
  171 class HalfVgaImpOutput(ImpOutput):
  172   __plugin__ = 'imp2'
  173 
  174   def generate(self):
  175     self.generate_imp(2)
  176 
  177 
  178 ########################################################## BBEB OUTPUT
  179 
  180 
  181 """ support for Sony BBeB output """
  182 class LrfOutput(BaseOutput):
  183   __plugin__ = 'lrf'
  184 
  185   """ generate a LRF file """
  186   def generate(self):
  187     from pylrs.pylrs import Book, PageStyle, BlockStyle
  188     from pylrs.pylrs import ImageStream, BlockSpace, ImageBlock
  189 
  190     p('\nCreating BBeB file ... ')
  191 
  192     # create book instance
  193     book = Book(title=self.title, author=self.author, category=self.category)
  194 
  195     # create default styles
  196     pageStyle  = PageStyle(topmargin='0', oddsidemargin='0', evensidemargin='0')
  197     blockStyle = BlockStyle(blockwidth='600', blockheight='800')
  198 
  199     # create pages
  200     images = []
  201     for i in range(self.n):
  202       stream = ImageStream(IMAGENAME_SPEC % i)
  203       page   = book.Page(pageStyle)
  204       page.BlockSpace()
  205       image  = page.ImageBlock(refstream=stream, xsize='565', ysize='754',
  206                                blockheight='768', blockStyle=blockStyle)
  207       images.append(image)
  208 
  209     # generate TOC, if present
  210     toc_map = self.input.toc_map
  211     for title, level, page_ in self.input.toc:
  212       imagenum = toc_map[int(page_)]
  213       book.addTocEntry(title.strip(), images[imagenum])
  214 
  215     # generate the ebook
  216     book.renderLrs("ebook.lrs")
  217     book.renderLrf("ebook.lrf")
  218 
  219     p('done.\n')
  220     if self.output:
  221       shutil.move('ebook.lrf', self.output)
  222       return True
  223 
  224     return False
  225 

------------------------------------------------------------------------
Back to SourceForge.net <http://sourceforge.net/>


Powered by ViewVC 1.0.3 <http://viewvc.tigris.org/> 	


      ViewVC and Help </viewvc/*docroot*/help_rootview.html>

