<?php
require_once ('calibre2php.inc.php');

session_start();
if (!isValidSession()) {
        header("Location: login.php?PHPSESSID=".session_id()."&msg=session expired...");
}
UpdateLastAccess();

// Usage: <a href="download.php?book=book_id&format=format_id">Download</a>
// The real location to the files will not be revealed and are protected by being outside the web broswable area.
$hiddenPath = $_SESSION["ebook_store"];

// VARIABLES
if (!empty($_GET["book"])){
// make sure parameters passed to the script are numeric
  if (is_numeric($_GET["book"]) && is_numeric($_GET["format"])) {
    $download_db = new PDO('sqlite:'.$_SESSION["calibre_db"]);
    $query_string = "SELECT books.path AS book_path, data.name AS book_name, data.format as book_format FROM books JOIN data on books.id=data.book WHERE books.id=".$_GET["book"]." AND data.id=".$_GET["format"];
    foreach($download_db->query($query_string) as $db_row) {
      $file_real = $_SESSION["ebook_store"]."/".$db_row["book_path"]."/".$db_row["book_name"].".";
      $file_format = $db_row["book_format"];
    }
    unset ($download_db);
  } else {
// if the parameters are not numeric display a message
    die("<br>Invalid book reference: ".$_GET["book"]."<br>or<br>Invalid format reference: ".$_GET["format"]."<br>");
  }
}
if (file_exists($file_real.$file_format)) $file_real .= $file_format;
if (file_exists($file_real.strtolower($file_format))) $file_real .= strtolower($file_format);

// Check to see if the download script was called
if (basename($_SERVER['PHP_SELF']) == 'download.php'){
  if ($_SERVER['QUERY_STRING'] != null){
// HACK ATTEMPT CHECK
// Make sure the request isn't escaping to another directory
// shouldn't really use this as there is a chekc higher up
// that checks for only numeric values passed to this script
    $book = str_replace('%20', ' ', $_GET['book']);
    if (substr($book, 0, 1) == "." || strpos($book, "..") > 0 || substr($book, 0, 1) == "/" || strpos($book, "/") > 0) {
// Display hack attempt error
      echo("Invalid request detected! $book");
      die();
    }
  $allow_resume = $_SESSION["allow_resume"];
  session_write_close();
  dl_file_resumable($file_real,$allow_resume);

  }
}

function dl_file_resumable($file, $is_resume=TRUE)
{
    //First, see if the file exists
    if (!is_file($file)) die("<b>404 File not found!</b>");

    //Gather relevent info about file
    $size = filesize($file);
    $fileinfo = pathinfo($file);
   
    //workaround for IE filename bug with multiple periods / multiple dots
    //in filename that adds square brackets to filename
    //eg. setup.abc.exe becomes setup[1].abc.exe
    $filename = (strstr($_SERVER['HTTP_USER_AGENT'], 'MSIE')) ?
                  preg_replace('/\./', '%2e', $fileinfo['basename'], substr_count($fileinfo['basename'], '.') - 1) :
                  $fileinfo['basename'];
   
      $ctype='application/force-download';

    //check if http_range is sent by browser (or download manager)
    $range = '';
    if($is_resume && isset($_SERVER['HTTP_RANGE']))
    {
        list($size_unit, $range_orig) = explode('=', $_SERVER['HTTP_RANGE'], 2);

        if ($size_unit == 'bytes')
        {
            //multiple ranges could be specified at the same time, but for simplicity only serve the first range
            //http://tools.ietf.org/id/draft-ietf-http-range-retrieval-00.txt
            @list($range, $extra_ranges) = explode(',', $range_orig, 2);
        }
    }

    //figure out download piece from range (if set)
    @list($seek_start, $seek_end) = explode('-', $range, 2);

    //set start and end based on range (if set), else set defaults
    //also check for invalid ranges.
    $seek_end = (empty($seek_end)) ? ($size - 1) : min(abs(intval($seek_end)),($size - 1));
    $seek_start = (empty($seek_start) || $seek_end < abs(intval($seek_start))) ? 0 : max(abs(intval($seek_start)),0);

    @ob_end_clean(); //turn off output buffering to decrease cpu usage
    //add headers if resumable
    if ($is_resume)
    {
        //Only send partial content header if downloading
        // a piece of the file (IE workaround)
        if ($seek_start > 0 || $seek_end < ($size - 1))
        {
            header('HTTP/1.1 206 Partial Content');
        }

        header('Accept-Ranges: bytes');
        header('Content-Range: bytes '.$seek_start.'-'.$seek_end.'/'.$size);
    }

    //headers for IE Bugs (is this necessary?)
    //header("Cache-Control: cache, must-revalidate");  
    //header("Pragma: public");

    header("Expires: ".gmdate("D, d M Y H:i:s", mktime(date("H"), date("i"), date("s"), date("m"), date("d"), "1972"))." GMT");
    header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");
    header('Content-Type: ' . $ctype);
    header("Content-Disposition: attachment; filename=\"$filename\"");
    header('Content-Length: '.($seek_end - $seek_start + 1));

    //open the file
    $fp = fopen($file, 'rb');
    if ($fp) {
      //seek to start of missing part
      fseek($fp, $seek_start);

      //start buffered download
      while(!feof($fp) && (connection_status()==0))
      {
          //reset time limit for big files
          set_time_limit(0);
            print(fread($fp, 1024*8));
          @ob_flush();
          flush();
      }
    }

    fclose($fp);
    exit;
}

?>
