<?php

// DO NOT CHANGE ANYTHING AFTER THIS LINE!!!!!!!
require_once ('c2psettings.inc.php');

$calibre2php_ver = "0.12";

function PrintHead() {
global $site_title;
print "<html>
<head>
<title>".$site_title."</title>
<link rel=\"icon\" href=\"http://calibre.kovidgoyal.net/chrome/site/favicon.ico\" type=\"image/x-icon\" />
<link type=\"text/css\" href=\"static/calibre2php.css\" rel=\"stylesheet\">
</head>";
}

function PrintLoginLogoutLink() {

  if (isValidSession()) {
    print "\n      <a class=\"link1\" href=\"login.php?logout=".session_id()."\" title=\"Logout of the session\">Logout</a>\n";
  } else {
    print "\n      <a class=\"link1\" href=\"login.php\" title=\"login to the the library\">Login</a>\n";
  }
}

function PrintFooter() {
global $calibre2php_ver;
print "<hr>
<table id=\"c2p_table\" border=\"0\" width=\"100%\">
  <tr>
    <td width=\"20%\" align=\"left\">";
if (!isValidSession()) {
        print "&nbsp";
} else {
        print "<p><span style=\"color:#4f4f4f; font-size:10px\">Books in library:".CountBooks(TRUE)."</span></p>";
}
print "    </td>
    <td align=\"center\">
	<p><span style=\"color:#4f4f4f; font-size:10px\">calibre2php ver ".$calibre2php_ver."</span></p>
    </td>
    <td align=\"right\" width=\"20%\">
	<p><span style=\"color:#4f4f4f; font-size:10px\"><a class=\"link1\" href=\"credits.php\" title=\"show the credits...\">Credits</a></span></p>
    </td>
  </tr>
</table>
</body>
</html>";
}

function SetupQueryString($count = false) {
  global $query_string, $num_books;
  $sort_fields = array("Title" => "book_title", "Author" => "book_author", "Rating" => "book_rating", "Date" => "book_date", "Series" => "book_series");
  // setup query string
  $query_string = "SELECT ";
  /*if ($count) {
    $query_string .= "COUNT(DISTINCT books.id) as counter, ";
  }*/ 
  $query_string .= "books.id AS book_id, ".$_SESSION["display_title"]." AS book_title, ".$_SESSION["display_author"]." AS book_author, books.timestamp AS book_date, ratings.rating AS book_rating, series.name AS book_series_name, books.series_index AS book_series_index ";
  
  $query_string .= "FROM books ";
  $query_string .= "JOIN books_authors_link on books.id=books_authors_link.book ";
  $query_string .= "JOIN authors on books_authors_link.author=authors.id ";
  $query_string .= "LEFT JOIN books_ratings_link on books.id=books_ratings_link.book ";
  $query_string .= "LEFT JOIN ratings on books_ratings_link.rating=ratings.id ";
  $query_string .= "LEFT JOIN books_series_link on books.id=books_series_link.book ";
  $query_string .= "LEFT JOIN series on books_series_link.series=series.id ";

  switch ($_SESSION["display_type"]) {
    /*case 0: // default display
      $query_string .= "GROUP BY book_id ORDER BY book_date ".$_SESSION["sort_direction"];
      break;*/
    case 1:  // index by title
      $query_string .= "WHERE book_title ";
      if ($_SESSION["display_alpha"] == "#") {
        $query_string .= "NOT GLOB ( '[a-zA-Z]*' ) ";
      } else {
        $query_string .= "LIKE '".$_SESSION["display_alpha"]."%' ";
      }
      break;
    case 2: // index by author
      $query_string .= "WHERE book_author ";
      if ($_SESSION["display_alpha"] == "#") {
        $query_string .= "NOT GLOB ( '[a-zA-Z]*' ) ";
      } else {
        $query_string .= "LIKE '".$_SESSION["display_alpha"]."%' ";
      }
      break;
  }
  $query_string .= "GROUP BY book_id ORDER BY ".$sort_fields[$_SESSION["sort_by"]]." ".$_SESSION["sort_direction"];
  if (!$count) {
    $query_string .= ($num_books > $_SESSION["display_lines"]) ? " LIMIT ".$_SESSION["display_lines_start"].", ".$_SESSION["display_lines"] : "";
  }
  //if (!$count) $_SESSION["query_string"] = $query_string;
}

function CountBooks($cnt_all = FALSE) {
  global $query_string;
/*
  $query_string = "SELECT COUNT(DISTINCT books.id) as counter FROM books ";
  $query_string .= "JOIN books_authors_link on books.id=books_authors_link.book ";
  $query_string .= "JOIN authors on books_authors_link.author=authors.id ";
  switch ($cnt_type) {
    case 0:
      $query_string = "SELECT COUNT(DISTINCT books.id) as counter FROM books";
      break;
    case 1:
      if ($cnt_letter == "num") {
        $query_string .= " WHERE ".$_SESSION["display_title"]." NOT GLOB ( '[a-zA-Z]*' ) ";
      } else {
        $query_string .= " WHERE ".$_SESSION["display_title"]." LIKE '".$cnt_letter."%'";
      }
      break;
    case 2:
      if ($cnt_letter == "num") {
        $query_string .= " WHERE ".$_SESSION["display_author"]." NOT GLOB ( '[a-zA-Z]*' ) ";
      } else {
        $query_string .= " WHERE ".$_SESSION["display_author"]." LIKE '".$cnt_letter."%'";
      }
      break;
  }
*/
  if ($cnt_all) {
    $query_string = "SELECT COUNT(books.id) as counter FROM books";
  } else {
    SetupQueryString(true);
  }
  if (!is_file($_SESSION["calibre_db"])) die ("<br>404 Database not found...<br>please check the &quot;ebook_store&quot; and &quot;calibre_db&quot; variables in your settings file...<br>");
  $count_db = new PDO('sqlite:'.$_SESSION["calibre_db"]);
  $book_count = 0;
  foreach($count_db->query("$query_string") as $row) {
    if ($cnt_all) {
      $book_count = $row["counter"];
    } else {
      $book_count++;
    }
  }

  unset ($count_db);
  return $book_count;
}

function SetupIndexArrays() {
  $index_chars = array_merge(array("#"), range("A", "Z"));
  $display_alpha = $_SESSION["display_alpha"];
  $display_type = $_SESSION["display_type"];
  unset($_SESSION["title_index"]);
  $_SESSION["display_type"] = 1;
  foreach($index_chars as $index_char) {
    $_SESSION["display_alpha"] = $index_char;
    $_SESSION["title_index"]["$index_char"] = CountBooks();
  }

  unset($_SESSION["author_index"]);
  $_SESSION["display_type"] = 2;
  foreach($index_chars as $index_char) {
    $_SESSION["display_alpha"] = $index_char;
    $_SESSION["author_index"]["$index_char"] = CountBooks();
  }

  $_SESSION["display_alpha"] = $display_alpha;
  $_SESSION["display_type"] = $display_type;
}

function PrintAlphaIndex() {

  $index_chars = array_merge(array("#"), range("A", "Z"));
  if (!is_numeric($_SESSION["title_index"]["#"]) || !is_numeric($_SESSION["author_index"]["#"])) SetupIndexArrays();

  print "<p><span style=\"color:#d5d5d5; font-size:14px\">\n";

  for($cnt_index = 0; $cnt_index < count($index_chars); $cnt_index++) {
    $tmp_cnt = ($_SESSION["display_type"] == 1) ? $_SESSION["title_index"][$index_chars[$cnt_index]] : $_SESSION["author_index"][$index_chars[$cnt_index]];
    if ($index_chars[$cnt_index] == $_SESSION["display_alpha"] && $tmp_cnt == 0) $_SESSION["display_alpha"] = $index_chars[$cnt_index + 1];

    if ($tmp_cnt > 0) {
      if ($index_chars[$cnt_index] == $_SESSION["display_alpha"]) {
        print "<span style=\"color:#000000; font-size:17px\"><b>$index_chars[$cnt_index]</b></span>&nbsp;&nbsp;\n";
      } else {
        print "<a class=\"alphaindex\" href=\"".$_SERVER['PHP_SELF']."?alpha=";
        if ($index_chars[$cnt_index] == "#") {
          print "num";
        } else {
          print $index_chars[$cnt_index];
        }
        print "\" title=\"$index_chars[$cnt_index]: $tmp_cnt book";
        if ($tmp_cnt > 1)  print "s";
        print "\">$index_chars[$cnt_index]</a>&nbsp;&nbsp;\n";
      }
    } else {
        print "$index_chars[$cnt_index]&nbsp;&nbsp;\n";
    }
  }
  print "</span></p>\n";
}

function PrintPaganationLinks() {
    global $num_books;
       // build paganation links
      if ($num_books <= $_SESSION["display_lines"]) {
	print "&nbsp;";
      } else {
	// set first & previous images
	if ($_SESSION["display_lines_start"] >= $_SESSION["display_lines"]) {
	// set first image
	  print "<a style=\"border: 0pt\" href=\"".$_SERVER["PHP_SELF"]."?";
	  if (!$_SESSION["display_type"] == 0) {
	    if ($_SESSION["display_alpha"] == "#") {
	      print "alpha=num&";
	    } else {
	      print "alpha=".$_SESSION["display_alpha"]."&";
	    }
	  }
	  print "page=1\" alt=\"jump to page 1\" title=\"jump to page 1\"><img style=\"border:0pt\" src=\"static/first.png\" alt=\"jump to page 1\" /></a>&nbsp;\n";
	// set previous image
	  print "<a style=\"border: 0pt\" href=\"".$_SERVER["PHP_SELF"]."?";
	  if (!$_SESSION["display_type"] == 0) {
	    if ($_SESSION["display_alpha"] == "#") {
	      print "alpha=num&";
	    } else {
	      print "alpha=".$_SESSION["display_alpha"]."&";
	    }
	  }
	  print "page=".$_SESSION["display_lines_start"] / $_SESSION["display_lines"]."\" alt=\"jump to previous page\" title=\"jump to previous page\"><img style=\"border:0pt\" src=\"static/previous.png\" alt=\"jump to previous page\" /></a>&nbsp;\n";
	} else {
	// set first image - no link
	  print "<img style=\"border:0pt\" src=\"static/first.png\" alt=\"jump to page 1\" />&nbsp;\n";
	// set previous image - no link
	  print "<img style=\"border:0pt\" src=\"static/previous.png\" alt=\"jump to previous page\" />&nbsp;\n";
	}

	// set page number links
	$num_pages = (($num_books % $_SESSION["display_lines"]) > 0) ? (($num_books - ($num_books % $_SESSION["display_lines"])) / $_SESSION["display_lines"]) + 1 : ($num_books / $_SESSION["display_lines"]);

	for ($counter=1; $counter <= $num_pages; $counter++) {
	  if ((($counter - 1) * $_SESSION["display_lines"]) == $_SESSION["display_lines_start"]) {
	    print "<b>$counter</b>&nbsp;\n";
	  } else {
	    print "<a class=\"paganation\" href=\"".$_SERVER["PHP_SELF"]."?";
	    if (!$_SESSION["display_type"] == 0) {
	      if ($_SESSION["display_alpha"] == "#") {
	        print "alpha=num&";
	      } else {
	        print "alpha=".$_SESSION["display_alpha"]."&";
	      }
	    }
	    print "page=".$counter."\">".$counter."</a>&nbsp;\n";
	  }
	}

	// set next & last images
	if ((($_SESSION["display_lines_start"] / $_SESSION["display_lines"]) + 1) < $num_pages) {
	// set next image
	  print "<a style=\"border: 0pt\" href=\"".$_SERVER["PHP_SELF"]."?";
	  if (!$_SESSION["display_type"] == 0) {
	    if ($_SESSION["display_alpha"] == "#") {
	      print "alpha=num&";
	    } else {
	      print "alpha=".$_SESSION["display_alpha"]."&";
	    }
	  }
	  print "page=".(($_SESSION["display_lines_start"] + $_SESSION["display_lines"]) / $_SESSION["display_lines"] + 1)."\" alt=\"jump to next page\" title=\"jump to next page\"><img style=\"border:0pt\" src=\"static/next.png\" alt=\"jump to next page\" /></a>&nbsp;\n";
	// set last image
	  print "<a style=\"border: 0pt\" href=\"".$_SERVER["PHP_SELF"]."?";
	  if (!$_SESSION["display_type"] == 0) {
	    if ($_SESSION["display_alpha"] == "#") {
	      print "alpha=num&";
	    } else {
	      print "alpha=".$_SESSION["display_alpha"]."&";
	    }
	  }
	  print "page=".$num_pages."\" alt=\"jump to last page\" title=\"jump to last page\"><img style=\"border:0pt\" src=\"static/last.png\" alt=\"jump to last page\" /></a>&nbsp;\n";
	} else {
	// set next image - no link
	  print "<img style=\"border:0pt\" src=\"static/next.png\" alt=\"jump to next page\" />&nbsp;\n";
	// set last image - no link
	  print "<img style=\"border:0pt\" src=\"static/last.png\" alt=\"jump to last page\" />&nbsp;\n";
	}

      }
}

function PrintTableHeadings() {
  $table_headings = array(array("Title", "45%"), array("Author", "28%"), array("Rating", "7%"), array("Date", "10%"), array("Series", "10%"));

  print "
<tr>\n";

  for ($cnt_head=0; $cnt_head < count($table_headings); $cnt_head++) {
    print "    <td width=\"".$table_headings[$cnt_head][1]."\" align=\"center\" style=\"border-style: none none solid; border-bottom-width: medium;\"><p>";
    if ($table_headings[$cnt_head][0] == "Series") {
      print $table_headings[$cnt_head][0]; 
    } else {
      print "<a class=\"heading\" href=\"".$_SERVER["PHP_SELF"]."?sort=".$table_headings[$cnt_head][0]."\"><b>".$table_headings[$cnt_head][0];
    }
    if ($table_headings[$cnt_head][0] == "Author") print "(s)";
    print "</b></a>";
    if ($table_headings[$cnt_head][0] == $_SESSION["sort_by"]) {
        $sort_indicator = ($_SESSION["sort_direction"] == "DESC") ? "↓" : "↑";
        print "<span class=\"sort_indicator\">$sort_indicator</span>";
    }
    print "</p></td>\n";
  }

print "  </tr>
\n";
}

function PrintTableRow() {
  global $row;
  // print each row of the table
  // Title
  print "  <tr>\n    <td><span class=\"subtitle\">".$row["book_title"]."<br>\n";
  // print download links
  PrintDownloadLinks($row["book_id"]);
  // print book tags
  PrintBookTags($row["book_id"]);
  print "</span>\n    </td>\n";
  // Author
  print "    <td><span class=\"subtitle\">".$row["book_author"]."</span></td>\n";
  // Rating
  //$row["book_rating"] = ($row["book_rating"] == 0) ? "&nbsp;" : $row["book_rating"];
  $book_rating = ($row["book_rating"] == 0) ? "&nbsp;" : "";
  for ($cnt_rating=1; $cnt_rating <= ($row["book_rating"] / 2); $cnt_rating++) {
    $book_rating .= "&#9733;";
  }
  print "    <td align=\"right\"><span class=\"rating\">$book_rating</span></td>\n";
  // Date
  print "    <td align=\"left\"><span class=\"subtitle\">".date($_SESSION["display_date"], strtotime($row["book_date"]))."</span></td>\n";
  // Series
  $book_series = (empty($row["book_series_name"])) ? "&nbsp;" : $row["book_series_name"]." [".$row["book_series_index"]."]";
  print "    <td><span class=\"subtitle\">".$book_series."</span></td>\n";
  print "  </tr>\n";
}

function PrintDownloadLinks($book_id) {
  $download_db = new PDO('sqlite:'.$_SESSION["calibre_db"]);
  foreach($download_db->query("SELECT data.id as data_id, data.format as data_format, data.uncompressed_size as data_size FROM data WHERE data.book=$book_id ORDER BY data.format ASC") as $download_row) {
    print "<a class=\"format\" href=\"download.php?book=$book_id&format=".$download_row["data_id"]."\" title=\"".$download_row["data_format"].": ";FormatFileSize($download_row["data_size"]);print "\"><span style=\"font-size:10px\">".$download_row["data_format"]."</span></a>&nbsp;&nbsp;";
  }
  unset ($download_db);
}

function FormatFileSize($file_size) {
  switch (strlen($file_size)) {
    case (strlen($file_size) > 6):
      printf("%.1f Mb", ($file_size / 1024 / 1024));
      break;
    case (strlen($file_size) > 3):
      printf("%.1f Kb", ($file_size / 1024));
      break;
    default:
      printf("%.1f Bytes", $file_size);
      break;
  }
}

function PrintBookTags($book_id) {
  $tags = "";
  $tag_db = new PDO('sqlite:'.$_SESSION["calibre_db"]);
  foreach($tag_db->query("SELECT tags.name AS tag_name FROM tags JOIN books_tags_link on books_tags_link.tag=tags.id WHERE books_tags_link.book=$book_id ORDER BY tag_name ASC") as $tag_row) {
    $tags .= ((!empty($tags)) ? ", " : "");
    $tags .= $tag_row["tag_name"];
  }
  if (!empty($tags)) print "<span style=\"font-size:10px\">[$tags]</span>";
  unset ($tag_db);
}

// Session related functions
function SetSessionVars() {
  global $site_title, $ebook_store, $calibre_db, $session_expiry, $default_display, $display_lines, $display_date, $display_title, $display_author, $allow_resume, $my_network;
  $_SESSION["session_started"] = time();
  $_SESSION["last_access"] = time();
  $_SESSION["site_title"] = $site_title;
  $_SESSION["ebook_store"] = $ebook_store;
  $_SESSION["calibre_db"] = $calibre_db;
  $_SESSION["session_expiry"] = $session_expiry;
  $_SESSION["display_type"] = (isset($_SESSION["display_type"])) ? $_SESSION["display_type"] : $default_display;
  $_SESSION["display_lines"] = $display_lines;
  $_SESSION["display_lines_start"] = (isset($_SESSION["display_lines_start"])) ? $_SESSION["display_lines_start"] : 0;
  $_SESSION["display_date"] = $display_date;
  $_SESSION["display_title"] = ($display_title == 0) ? "books.sort" : "books.title";
  $_SESSION["display_author"] = ($display_author == 0) ? "books.author_sort" : "authors.name";
  $_SESSION["allow_resume"] = ($allow_resume == 0) ? FALSE : TRUE;
  $_SESSION["my_network"] = $my_network;
  $_SESSION["sort_by"] = "Date";
  $_SESSION["sort_direction"] = "DESC";
  $_SESSION["title_index"]["#"] = "";
  $_SESSION["author_index"]["#"] = "";
}

function UnsetSession() {
  session_destroy();
  unset($_SESSION["last_access"]);
  unset($_SESSION["session_started"]);
  unset($_SESSION["site_title"]);
  unset($_SESSION["ebook_store"]);
  unset($_SESSION["calibre_db"]);
  unset($_SESSION["session_expiry"]);
  unset($_SESSION["display_type"]);
  unset($_SESSION["display_lines"]);
  unset($_SESSION["display_lines_start"]);
  unset($_SESSION["display_date"]);
  unset($_SESSION["display_title"]);
  unset($_SESSION["display_author"]);
  unset($_SESSION["allow_resume"]);
  unset($_SESSION["my_network"]);
  unset($_SESSION["sort_by"]);
  unset($_SESSION["sort_direction"]);
  unset($_SESSION["dbh"]);
}

function isValidSession() {
  if (!isset($_SESSION["session_started"]) || (time() - ((isset($_SESSION["last_access"])) ? $_SESSION["last_access"] : 0)) > $_SESSION["session_expiry"]) {
    return 0;
  } else {
    return 1;
  }
}

function UpdateLastAccess() {
  if (isset($_SESSION["last_access"])) {
    $_SESSION["last_access"] = time();
  }
}

?>
