#!/bin/sh

SCRIPTDIR=`pwd`
LOG=$SCRIPTDIR/logfile.txt
APPDIR=`/usr/bin/dirname $SCRIPTDIR`
APP=`/usr/bin/basename $APPDIR`

# Update manifest.xml for next run.
# this script runs in <appdir>/_files
# the manifestr goes to <appdir>
adjust_manifest() {
  sed -e "s|_TITLE_|$1|" template.xml \
  |sed -e "s|_INFO_|$2|" | sed -e "s|_SCRIPT_|_files/$3|"\
  |sed -e "s|_ICON_|_files/$4|" > ../manifest.xml
  echo "adjust_manifest('$1','$2','$3','$4')" >> $LOG
}

check_firmware() {
  FirmwareILiad=`cat /etc/er_version_commercial`
  FirmwareWanted=2.12
  echo "check_firmware(Iliad='$FirmwareILiad', wanted='$FirmwareWanted')" >> $LOG
  echo $FirmwareILiad | grep $FirmwareWanted - >/dev/null
}
