#!/usr/local/bin/lua


require("lgob.gtk")
require("lgob.gdk")
require("lgob.pango")


local win = gtk.Window.new()
win:set("title", "Recent files", "border-width", 20)
win:connect("delete-event", gtk.main_quit)

-- header: title and quit button
local hbox = gtk.HBox.new(false, 20)
hbox:set("border-width", 10)

local evbox = gtk.EventBox.new()
evbox:modify_bg(gtk.STATE_NORMAL, gdk.color_parse("black"))
local title = gtk.Label.new()
title:set_markup("<span size='xx-large' color='white' weight='bold'>Iliad Toolbox</span>")
evbox:add(title)
hbox:pack_start(evbox, true, true, 0)

local btn_quit = gtk.Button.new_from_stock("gtk-quit")
btn_quit:connect("clicked", gtk.main_quit)
hbox:pack_start(btn_quit, false, false, 0)


-- local i1 = gtk.ImageMenuItem.new_from_stock("gtk-open")


-- body
local data, evboxi, hboxi, imgi, lbli
data = { {"sysinfo","System Information", "Show Iliad system information."},
         {"recentfiles", "Recent Files", "Clean your recent files list."},
         {"test", "Title and this", "And here comes the description."} }
local vbox2 = gtk.VBox.new(false, 15)
vbox2:set("border-width", 10)
for i, val in pairs(data) do
   evboxi = gtk.EventBox.new()
   evboxi:modify_bg(gtk.STATE_NORMAL, gdk.color_parse("gray60"))
   evboxi:set_events(gdk.BUTTON_PRESS_MASK)
   evboxi:connect("button_press_event", function() dofile("_files/modules/"..val[1]..".lua") end)
   hboxi = gtk.HBox.new(false, 20)
   imgi = gtk.Image.new_from_file("_files/data/"..val[1]..".png")
   hboxi:pack_start(imgi, false, false, 0)
   lbli = gtk.Label.new()
   buf = string.format("<span size='x-large'>%s</span>\n<i>%s</i>", val[2], val[3])
   lbli:set("xalign", 0)
   lbli:set_markup(buf)
   hboxi:pack_start(lbli, true, true, 0)
   evboxi:add(hboxi)
   vbox2:pack_start(evboxi, false, false, 0)
end

-- widgets packaging
local vbox = gtk.VBox.new(false, 5)
vbox:pack_start(hbox, false, false, 10)
vbox:pack_start(vbox2, false, false, 10)
win:add(vbox)

-- show and run
win:fullscreen()
win:show_all()
gtk.main()
