#!/bin/sh

# Version 0.06 (20091006), ebs, jya
V="0.06"

U=/mnt/us
L=$U/usbnetwork_install.log
R=$U/usbnet
T=/test/bin
S=usbnetwork
PSTARTSCRIPT=/etc/init.d/usbnet
STARTSCRIPT=usbnet

# Result codes,
# at the moment we don't really return an error - don't want to scare people :)
OK=0
ERR=$OK

RS=$R/$S
TS=$T/$S

echo >> $L
echo "usbnetwork v$V, `date`" >> $L

# Create usbnet directory on user partition and copy our custom stuff there
mkdir -p $R/bin >> $L 2>&1 || exit $ERR
cp $S $RS >> $L 2>&1 || exit $ERR
cp busybox $R/bin >> $L 2>&1 || exit $ERR
cp dropbear $R/bin >> $L 2>&1 || exit $ERR
cp scp $R/bin >> $L 2>&1 || exit $ERR
cp usbnet-enable $R/bin >> $L 2>&1 || exit $ERR
cp usbnet-disable $R/bin >> $L 2>&1 || exit $ERR

mkdir -p $R/etc >> $L 2>&1 || exit $ERR
cp dropbear_rsa_host_key $R/etc >> $L 2>&1 || exit $ERR
cp dropbear_dss_host_key $R/etc >> $L 2>&1 || exit $ERR

# Make sure /test/bin directory exists
mkdir -p $T >> $L 2>&1 || exit $ERR

update_progressbar 50

# Link already exists ?
if [ -L $TS ]; then
	echo "symbolic link $TS -> `readlink $TS` already exists, skipping..." >> $L
else
	# Save normal file in case it exists already
	if [ -f $TS ]; then
		echo "$TS exists, saving..." >> $L
		cp $TS $RS-save.$V >> $L 2>&1 || exit $ERR
		rm $TS >> $L 2>&1 || exit $ERR
	fi

	update_progressbar 80

	# Create a link
	ln -s $RS $TS >> $L 2>&1 || exit $ERR
fi

# Create startup script
if [ -f $PSTARTSCRIPT ]; then
	# Save file in case it exists already
	echo "$PSTARTSCRIPT exists, saving..." >> $L
	cp $PSTARTSCRIPT $R/$STARTSCRIPT-save.$V >> $L 2>&1 || exit $ERR
	rm $PSTARTSCRIPT >> $L 2>&1 || exit $ERR
fi
cp usbnet-init $PSTARTSCRIPT >> $L 2>&1 || exit $ERR
chmod +x $PSTARTSCRIPT >> $L 2>&1 || exit $ERR

if [ -L /etc/rcS.d/S72usbnet ]; then
	echo "symbolic link /etc/rcS.d/S72usbnet already exists, skipping..." >> $L
else
	ln -s $PSTARTSCRIPT /etc/rcS.d/S72usbnet >> $L 2>&1 || exit $ERR
fi
rm -f $R/AUTO >> $L 2>&1 | exit $ERR

echo "Done!" >> $L

update_progressbar 100

exit $OK
