#/usr/bin/env python
# -*- coding: utf-8 -*-

# bat.py: show iLiad's battery status
#
# Copyright (C) 2009  Iñigo Serna <mailto:inigoserna@gmail.com>
# Time-stamp: <2009-10-05 23:00:37 inigo>
#
# code translated from eventPoller function in powerMgr.c file:
#    http://iliad.hpelbers.org/irexdox/powerMgr/powerMgr_8c-source.html


import fcntl
import struct
import os


IOCPARM_MASK = 0x7f
IOC_READ = 0x80000000
def FIX(x): return struct.unpack("i", struct.pack("I", x))[0]
def _IOR(x,y,t): return FIX(IOC_READ|((t&IOCPARM_MASK)<<16)|(ord(x)<<8)|y)

BAT_IO_READ_CHARGE = _IOR('b', 1, struct.calcsize("I")) # -2147196415
BAT_IO_READ_TIME = _IOR('b', 2, struct.calcsize("I"))   # -2147196414

fd = os.open('/dev/battery', os.O_RDONLY)
bat_pct = ord(fcntl.ioctl(fd, BAT_IO_READ_CHARGE, '  ')[0]) # percentage 0..100
buf = fcntl.ioctl(fd, BAT_IO_READ_TIME, '  ')    # in minutes, 65535 = charging
if buf == '\xff\xff':
    bat_mins = -1
else:
    bat_mins = ord(buf[1])*256 + ord(buf[0])
os.close(fd)

if bat_mins == -1 :
    print 'Battery: %d%%, now charging' % (bat_pct, )
else:
    h, m = divmod(bat_mins, 60)
    print 'Battery: %d%%, %d hours %d minutes remaining' % (bat_pct, h, m)
