/*
  Copyright (c) 2007 Scott Turner scotty1024@mac.com All Rights Reserved.

  This software is subject to, and may be distributed under, the
  GNU General Public License, Version 2. The license should have
  accompanied the software or you may obtain a copy of the license
  from the Free Software Foundation at http://www.fsf.org .

  This code is provided "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO ANY WARRANTY OF NON-INFRINGEMENT,
  OR ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
  PURPOSE.
*/
package java.awt;

public class Panel extends Container {

    private static final String base = "panel";
    private static int nameCounter = 0;

    private static final long serialVersionUID = -2728009084054400034L;

    public Panel() {
	this(new FlowLayout());
    }

    public Panel(LayoutManager layout) {
	setName( base + nameCounter++);
	setLayout(layout);
    }

    public Dimension getPreferredSize() {
	return new Dimension(width, height);
    }
}
