/*
  Copyright (c) 2007 Scott Turner scotty1024@mac.com All Rights Reserved.

  This software is subject to, and may be distributed under, the
  GNU General Public License, Version 2. The license should have
  accompanied the software or you may obtain a copy of the license
  from the Free Software Foundation at http://www.fsf.org .

  This code is provided "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO ANY WARRANTY OF NON-INFRINGEMENT,
  OR ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
  PURPOSE.
*/
package java.awt;

import java.io.Serializable;

public class CheckboxGroup implements Serializable {

    Checkbox selectedCheckbox = null;

    private static final long serialVersionUID = 3729780091441768983L;

    public CheckboxGroup() {
    }

    public Checkbox getCurrent() {
	return getSelectedCheckbox();
    }

    public synchronized void setCurrent(Checkbox box) {
	setSelectedCheckbox(box);
    }

    public Checkbox getSelectedCheckbox() {
	return selectedCheckbox;
    }

    public void setSelectedCheckbox(Checkbox box) {
	if ((box != null) && (box.group != this)) {
	    return;
	}

	Checkbox curChoice = selectedCheckbox;
	selectedCheckbox = box;

	if ((curChoice != null) && ((curChoice != box) && (curChoice.group == this))) {
	    curChoice.setState(false);
	}

	if ((box != null) && ((curChoice != box) && !box.getState())) {
	    box.setStateInternal(true);
	}
    }
}
