import java.awt.Button;
import java.awt.Color;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.GridLayout;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

import com.scotty1024.iliadviewer.DisplayControl;
import com.scotty1024.iliadviewer.ToolBar;
import com.scotty1024.iliadviewer.ToolBarIcon;

//import com.irex.sdk.ErToolBar;

public class test3 extends Frame implements ActionListener, TextListener {

    Button button;
    Button button2;
    Button button3;
    Label label;
    Label label2;
    Label label3;
    Label label4;
    Panel panel;
    TextField textField;

    public test3() {
	setSize(768, 935);

	setLayout(new FlowLayout());

	panel = new Panel(new GridLayout(0, 2));

	label = new Label("Left label");
	label2 = new Label("Centered Label", Label.CENTER);
	label3 = new Label("Right Label", Label.RIGHT);
	label4 = new Label("Enter Text", Label.LEFT);

	button = new Button("Quit");
	button.setActionCommand("CLOSE");
	button.addActionListener(this);
	button2 = new Button("Set");
	button2.setActionCommand("SET_TF");
	button2.addActionListener(this);
	button3 = new Button("Clear");
	button3.setActionCommand("CLEAR_TF");
	button3.addActionListener(this);
	textField = new TextField(30);
	textField.addTextListener(this);

	panel.add(label);
	panel.add(button);

	panel.add(label2);
	panel.add(button2);

	panel.add(label3);
	panel.add(button3);

	panel.add(label4);
	panel.add(textField);

	panel.setBounds( 10, 0, 700, 400);

	add(panel);
	//	pack();

	// Make us the target for events
	requestFocus();

	setVisible(true);

	// Pop up the keyboard
	ToolBar.init(103);
	ToolBar.showIcon(ToolBarIcon.Keyboard);
	ToolBar.setIconSelected(ToolBarIcon.Keyboard);
	ToolBar.unlock();

	DisplayControl.fullRefresh();
    }

    public void actionPerformed(ActionEvent e) {
	String command = e.getActionCommand();
	System.out.println("Got command: " + command);
	if (command.equals("CLOSE")) {
	    ToolBar.setIconDisabled(ToolBarIcon.Keyboard);
	    System.exit(0);
	} else 	if (command.equals("SET_TF")) {
	    textField.setText("Some Text");
	    textField.repaint();
	    DisplayControl.quickRefresh();
	} else 	if (command.equals("CLEAR_TF")) {
	    textField.setText("");
	    textField.repaint();
	    DisplayControl.quickRefresh();
	}
    }

    public void textValueChanged(TextEvent event) {
	TextField tf = (TextField)event.getSource();
	tf.repaint();
	DisplayControl.quickRefresh();
    }

    public static void main(String[] args) {
	test3 test = new test3();
    }

}
