
#############################################################
# def parse_cmdline():										#
#															#
#############################################################
def parse_cmdline():

	global cmdline

	cmdline = OptionParser(usage="usage: %prog [options] infile outfile")

	# option(s), action, type, dest (destination), and help
	cmdline.add_option("-i", "--infile", dest="infile",
					   action="store",   type="string",
					   help="Input text file to convert to lrf")
	cmdline.add_option("-o", "--outfile", dest="outfile",
					   action="store",    type="string",
					   help="Output lrf file for converted text")

	cmdline.add_option("-t", "--title", dest="title",default="Unknown Title",
					   action="store",  type="string",
					   help="Specify Book Title")
	cmdline.add_option("-a", "--author",dest="author",default="Unknown Author",
					   action="store",  type="string",
					   help="Specify Book Author")

	#
	# How to calculate linebreaks
	#
	cmdline.add_option("-b", "--breakon", dest="linebreak",
					   default="auto", metavar="auto|cr|tab|space",
					   help="Specify how to break paragraphs: "
					        "'auto' (default) - use algorithm "
					        "'cr' - paragraphs begin after line break"
					        "'tab' - paragraphs begin with tab-indented line"
					        "'space' - paragraphs begin with multi-spaced line"
					   )

	(options, args) = cmdline.parse_args()

	infile  = options.infile
	outfile = options.outfile

	author  = options.author
	title   = options.title

	if not infile :
		cmdline.print_help()
		print "No Input File Specified"
		return False
	if not outfile :
		cmdline.print_help()
		print "No Output File Specified"
		return False

	if not os.path.exists(infile) :
		cmdline.print_help()
		print "Input File \"", infile, "\" does not exist"
		return False
	
	print "Title = ", title
	print "Author = ", author
	print "Infile = ", infile
	print "Outfile = ", outfile
	print "Fold Quoes = ", fold_rdquotes

	return True

# enddef parse_cmdline()

