#ifndef __SCRIBBLE_H__
#define __SCRIBBLE_H__

#include <gtk/gtk.h>

// copied from erscribble....

// NOTE, the point defined here is same as X11 and GDK
// Scribble library also provides another struct ScbDevPoint, which contains pressure info
// ScbPoint is used when scribble library needs to expose data to gdk/X11
typedef struct _ScbPoint
{
    int      x;         /**< x weight of the point */
    int      y;         /**< y weiget of the point */
} ScbPoint;

typedef ScbPoint * ScbPointPtr;

// NOTE, device point has pressure value. It serves as input parameter
typedef struct _ScbDevPoint
{
    ScbPoint point;     /**< coorindate point */
    int      pressure;  /**< pressure */
} ScbDevPoint;

typedef ScbDevPoint * ScbDevPointPtr;

void erscribble_driver_init();
void erscribble_driver_close();

void erscribble_driver_draw_reset_context();

gboolean erscribble_driver_draw_now();

void erscribble_driver_draw_record(const ScbDevPointPtr ptr, 
                                   const unsigned char size, 
                                   const unsigned char color,
                                   const unsigned char pen_down);

void erscribble_driver_draw();

// Select only one of the following by setting: ui.scribble_update_mode
// SCRIBBLE_MODE_DRIVER uses the erscribble_driver functions from liberscribble.
//   issues: erscribble uses real screen coordinates while xournal has 'translated'
//           coordinates. The current code does not handle this, but it gives you an
//           impresison of what should be possible
//           Appart from the wrong positions, the reaction is also very slow, when drawing
//           quickly, the updates appear late.
// SCRIBBLE_MODE_LABEL uses a label widget to force a screen update
//   issues: the update will only happen when not touching the screen for ~2s.
// (See on_optionsScribbleUpdatePrefs_activate() in xo-callbacks.c for its use.)

#define SCRIBBLE_MODE_DRIVER 1
#define SCRIBBLE_MODE_LABEL 2

// function using erscribble
void scribble_init(void);
void scribble_close(void);
void scribble_driver_new(void);
void scribble_driver_draw(int posx, int posy, int size, guint color, gboolean is_last_point);

// protect erscribble function. Temporally do not draw with actual driver.
// call this function when it is expected that the DR does a refresh of the
// screen. It seems that multiple users of the display driver can hang the DR.
void scribble_protect( void);

// functions using low level driver directly
void scribble_ll_init(void);
void scribble_ll_close(void);
void scibble_ll_update_display(void);

// function using label
void scribble_force_update(void);

// do a forced update now!
void scribble_force_update_now(void);

#endif //__SCRIBBLE_H__
