/*
 * File Name: mxFileChooser.c
 */

/*
 * mxFileChooser is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * mxFileChooser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2009 Marcel Hendrickx
 * All rights reserved.
 */

// This is a very ugly implementation of a FileChooser to work around the 
// patch in the gtk-version of the DR that limits the size to 300x300 pixels.
// I copied some gtk code and limited the size to 700 x 700 ;-)
// I am sure that some usefull functionality is missing from this implementation!!
// As an alternative you can use gtk_file_selection (see leafpad for its usage).

// This file is further a violation of common programming practices that would
// seperate the generic file dialog code and the program specific code (e.g. setting
// of format specific file filters into seperate files). This makes this file not
// very reusable for other programs ...
//------------------------------------------------------------------------------
// Include Files
//------------------------------------------------------------------------------

// configuration parameters of the project
#include "config.h"

#include <glib/gi18n.h>

// The implemented interface
#include "mx-filechooser.h"

// system include files
#include <glib.h>
#include <gtk/gtk.h>
#include <signal.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>

#include <glib/gstdio.h>

// local include files
#include "xournal.h"


//------------------------------------------------------------------------------
// Type Declarations
//------------------------------------------------------------------------------
typedef struct _local_data
{
	int nr;
} local_data;


//------------------------------------------------------------------------------
// Global Constants
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// Static Variables
//------------------------------------------------------------------------------

static local_data instance_data;

//==============================================================================
// Local Function Definitions
//==============================================================================

static void response_cb (GtkDialog *dialog,
			 gint       response_id);

//==============================================================================
// Functions Implementation
//==============================================================================

/* Callback used when the user activates a file in the file chooser widget */
static void
file_chooser_widget_file_activated (GtkFileChooser       *chooser,
				    				GtkDialog *dialog)
{
  	GList *children, *l;

  	if (gtk_window_activate_default (GTK_WINDOW (dialog)))
    	return;

  	/* There probably isn't a default widget, so make things easier for the
 	 * programmer by looking for a reasonable button on our own.
  	 */

  	children = gtk_container_get_children (GTK_CONTAINER (GTK_DIALOG (dialog)->action_area));

  	for (l = children; l; l = l->next)
    {
      	GtkWidget *widget;
      	int response_id;

      	widget = GTK_WIDGET (l->data);
      	response_id = gtk_dialog_get_response_for_widget (GTK_DIALOG (dialog), widget);
      	if (response_id == GTK_RESPONSE_ACCEPT
	  		|| response_id == GTK_RESPONSE_OK
	  		|| response_id == GTK_RESPONSE_YES
	  		|| response_id == GTK_RESPONSE_APPLY)
		{
	  		gtk_widget_activate (widget); /* Should we gtk_dialog_response (dialog, response_id) instead? */
	  		break;
		}
    }

  	g_list_free (children);
}

static void
clamp_to_screen (GtkWidget *widget,
		 		gint      *width,
		 		gint      *height)
{
  	GdkScreen *screen;
  	int monitor_num;
  	GdkRectangle monitor;

  	g_return_if_fail (GTK_WIDGET_REALIZED (widget));
  
  	screen = gtk_widget_get_screen (widget);
  	monitor_num = gdk_screen_get_monitor_at_window (screen, widget->window);

  	gdk_screen_get_monitor_geometry (screen, monitor_num, &monitor);

  	if (width)
    	*width = MIN (*width, monitor.width);

  	if (height)
    	*height = MIN (*height, monitor.height);
}

static void
file_chooser_widget_default_size_changed (GtkWidget            *widget,
					  					  GtkDialog            *dialog)
{
  	gint width, height;
  	gint default_width, default_height;
  	GtkRequisition req, widget_req;
  	gboolean resizable = FALSE;

#if 0
  	/* Unset any previously set size */
  	gtk_widget_set_size_request (GTK_WIDGET (dialog), -1, -1);

  	if (GTK_WIDGET_DRAWABLE (widget))
    {
      	/* Force a size request of everything before we start.  This will make sure
      	 * that widget->requisition is meaningful. */
      	gtk_widget_size_request (GTK_WIDGET (dialog), &req);
      	gtk_widget_size_request (widget, &widget_req);

      	width = req.width - widget_req.width;
      	height = req.height - widget_req.height;
    }
  	else
    {
      	width = GTK_WIDGET (dialog)->allocation.width - widget->allocation.width;
      	height = GTK_WIDGET (dialog)->allocation.height - widget->allocation.height;
    }

  	resizable = _gtk_file_chooser_embed_get_resizable (GTK_FILE_CHOOSER_EMBED (priv->widget));
  	_gtk_file_chooser_embed_get_default_size (GTK_FILE_CHOOSER_EMBED (priv->widget),
					    &default_width, &default_height);

  	/* Ideal target size plus any extra size */
  	width = default_width + width + (2 * GTK_CONTAINER (dialog)->border_width);
  	height = default_height + height + (2 * GTK_CONTAINER (dialog)->border_width);
#endif

  /* for small screens we just hard code a sensible value */
  width = 700;
  height = 700;

  	if (GTK_WIDGET_REALIZED (dialog))
    	clamp_to_screen (GTK_WIDGET (dialog), &width, &height);

  	if (resizable)
    {
      	gtk_window_set_resizable (GTK_WINDOW (dialog), resizable);
      	gtk_window_resize (GTK_WINDOW (dialog), width, height);
    }
  	else
    {
      	gtk_widget_set_size_request (GTK_WIDGET (dialog), width, height);
      	gtk_window_set_resizable (GTK_WINDOW (dialog), resizable);
    }
}

static void
file_chooser_widget_response_requested (GtkWidget           *widget,
										GtkDialog 			*dialog)
{
  	GList *children, *l;

  	/* There probably isn't a default widget, so make things easier for the
  	 * programmer by looking for a reasonable button on our own.
  	 */

  	children = gtk_container_get_children (GTK_CONTAINER (GTK_DIALOG (dialog)->action_area));

  	for (l = children; l; l = l->next)
    {
      	GtkWidget *widget;
      	int response_id;

      	widget = GTK_WIDGET (l->data);
      	response_id = gtk_dialog_get_response_for_widget (GTK_DIALOG (dialog), widget);
      	if (response_id == GTK_RESPONSE_ACCEPT
	  	 || response_id == GTK_RESPONSE_OK
	  	 || response_id == GTK_RESPONSE_YES
	  	 || response_id == GTK_RESPONSE_APPLY)
		{
	  		gtk_widget_activate (widget); /* Should we gtk_dialog_response (dialog, response_id) instead? */
	  		break;
		}
    }

  	g_list_free (children);
}
  
char *mx_file_chooser_dialog_open(const gchar          *title,
						          GtkWindow            *parent)
{
	GtkWidget *widget;
	GtkWidget *background;
    GtkWidget *dialog;
    GtkFileFilter *filt_all, *filt_xoj;
    char *filename;

    // object hierarchy:
	//       dialog
	//         |
    /* Create the widgets */
    dialog = gtk_dialog_new_with_buttons (title,
                                          parent,
                                          GTK_DIALOG_DESTROY_WITH_PARENT,
										  GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
     									  GTK_STOCK_OPEN, GTK_RESPONSE_OK,
                                          NULL);
  	gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);
  	gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);
  	gtk_box_set_spacing (GTK_BOX (GTK_DIALOG (dialog)->vbox), 2); /* 2 * 5 + 2 = 12 */
    gtk_container_set_border_width (GTK_CONTAINER (GTK_DIALOG (dialog)->action_area), 5);

  	g_signal_connect (dialog, "response",
		    G_CALLBACK (response_cb), NULL);

	/* Ensure that the dialog box is destroyed when the user responds. */
    //g_signal_connect_swapped (dialog,
    //                         "response",
    //                         G_CALLBACK (gtk_widget_destroy),
    //                         dialog);
	//             |- file_chooser_widget
    widget = g_object_new (GTK_TYPE_FILE_CHOOSER_WIDGET, NULL);

	g_signal_connect (widget, "file-activated",
		    G_CALLBACK (file_chooser_widget_file_activated), dialog);
  	g_signal_connect (widget, "default-size-changed",
		    G_CALLBACK (file_chooser_widget_default_size_changed), dialog);
  	g_signal_connect (widget, "response-requested",
		    G_CALLBACK (file_chooser_widget_response_requested), dialog);

  	gtk_container_set_border_width (GTK_CONTAINER (widget), 5);
  	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), widget, TRUE, TRUE, 0);

    filt_all = gtk_file_filter_new();
    gtk_file_filter_set_name(filt_all, _("All files"));
    gtk_file_filter_add_pattern(filt_all, "*");
    filt_xoj = gtk_file_filter_new();
    gtk_file_filter_set_name(filt_xoj, _("Xournal files"));
    gtk_file_filter_add_pattern(filt_xoj, "*.xoj");
    gtk_file_chooser_add_filter(GTK_FILE_CHOOSER (widget), filt_xoj);
    gtk_file_chooser_add_filter(GTK_FILE_CHOOSER (widget), filt_all);
    if (ui.default_path!=NULL) gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER (widget), ui.default_path);

  	gtk_widget_show (widget);

  	if (gtk_dialog_run(GTK_DIALOG(dialog)) != GTK_RESPONSE_OK) {
    	gtk_widget_destroy(dialog);
    	return NULL;
  	}
  	filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (widget));
  	gtk_widget_destroy(dialog);

	//printf("Filename: %s\n", filename);
	
	return filename;
}

char *mx_file_chooser_dialog_save(const gchar          *title,
						          GtkWindow            *parent)
{
	GtkWidget *widget;
	GtkWidget *background;
    GtkWidget *dialog;
    GtkWidget *warning_dialog;
    GtkFileFilter *filt_all, *filt_xoj;
  	char *filename;
  	char stime[30];
  	time_t curtime;
  	gboolean warn;
   	struct stat stat_buf;

    // object hierarchy:
	//       dialog
	//         |
    /* Create the widgets */
    dialog = gtk_dialog_new_with_buttons (title,
                                          parent,
                                          GTK_DIALOG_DESTROY_WITH_PARENT,
										  GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
     									  GTK_STOCK_SAVE, GTK_RESPONSE_OK,
                                          NULL);
  	gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);
  	gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);
  	gtk_box_set_spacing (GTK_BOX (GTK_DIALOG (dialog)->vbox), 2); /* 2 * 5 + 2 = 12 */
    gtk_container_set_border_width (GTK_CONTAINER (GTK_DIALOG (dialog)->action_area), 5);

  	g_signal_connect (dialog, "response",
		    G_CALLBACK (response_cb), NULL);

	/* Ensure that the dialog box is destroyed when the user responds. */
    //g_signal_connect_swapped (dialog,
    //                         "response",
    //                         G_CALLBACK (gtk_widget_destroy),
    //                         dialog);
	//             |- file_chooser_widget
    widget = g_object_new (GTK_TYPE_FILE_CHOOSER_WIDGET, NULL);

	g_signal_connect (widget, "file-activated",
		    G_CALLBACK (file_chooser_widget_file_activated), dialog);
  	g_signal_connect (widget, "default-size-changed",
		    G_CALLBACK (file_chooser_widget_default_size_changed), dialog);
  	g_signal_connect (widget, "response-requested",
		    G_CALLBACK (file_chooser_widget_response_requested), dialog);

  	gtk_container_set_border_width (GTK_CONTAINER (widget), 5);
  	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), widget, TRUE, TRUE, 0);

	gtk_file_chooser_set_action(GTK_FILE_CHOOSER (widget), GTK_FILE_CHOOSER_ACTION_SAVE);
  	if (ui.filename!=NULL) 
	{
    	gtk_file_chooser_set_filename(GTK_FILE_CHOOSER (widget), ui.filename);
    	gtk_file_chooser_set_current_name(GTK_FILE_CHOOSER (widget), g_basename(ui.filename));
  	} 
  	else
	{
  		if (bgpdf.status!=STATUS_NOT_INIT && bgpdf.file_domain == DOMAIN_ABSOLUTE 
      		&& bgpdf.filename != NULL) 
		{
    		filename = g_strdup_printf("%s.xoj", bgpdf.filename->s);
    		gtk_file_chooser_set_filename(GTK_FILE_CHOOSER (widget), filename);
    		gtk_file_chooser_set_current_name(GTK_FILE_CHOOSER (widget), g_basename(filename));
    		g_free(filename); 
  		}
		else 
		{
			curtime = time(NULL);
			strftime(stime, 30, "%F-Note-%H-%M.xoj", localtime(&curtime));
			if (ui.default_path!=NULL)
				gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER (widget), ui.default_path);
			gtk_file_chooser_set_current_name(GTK_FILE_CHOOSER (widget), stime);
		}
	}
     
  	filt_all = gtk_file_filter_new();
  	gtk_file_filter_set_name(filt_all, _("All files"));
  	gtk_file_filter_add_pattern(filt_all, "*");
  	filt_xoj = gtk_file_filter_new();
  	gtk_file_filter_set_name(filt_xoj, _("Xournal files"));
  	gtk_file_filter_add_pattern(filt_xoj, "*.xoj");
  	gtk_file_chooser_add_filter(GTK_FILE_CHOOSER (widget), filt_xoj);
  	gtk_file_chooser_add_filter(GTK_FILE_CHOOSER (widget), filt_all);
  
  	// somehow this doesn't seem to be set by default
  	gtk_dialog_set_default_response(GTK_DIALOG(dialog), GTK_RESPONSE_OK);

  	gtk_widget_show (widget);

  	do 
	{
    	if (gtk_dialog_run(GTK_DIALOG(dialog)) != GTK_RESPONSE_OK) {
      		gtk_widget_destroy(dialog);
      		return NULL;
    	}
    	filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (widget));
		// MH check if .xoj extension is added, if not add!
		if ( strstr(filename, ".xoj") == NULL)
		{
			char *tmp_file;
		
			// create copy of filename to release it and create a new one, using old name
			tmp_file = g_strdup(filename);
			g_free(filename);
        	filename = g_strdup_printf("%s.xoj", tmp_file);
			g_free(tmp_file);
		}
    	warn = g_file_test (filename, G_FILE_TEST_EXISTS);
    	if (warn) 
		{ // ok to overwrite an empty file
      		if (!g_stat(filename, &stat_buf))
        		if (stat_buf.st_size == 0) warn=FALSE;
    	}
    	if (warn && ui.filename!=NULL) 
		{ // ok to overwrite oneself
      		if (ui.filename[0]=='/' && !strcmp(ui.filename, filename)) warn=FALSE;
      		if (ui.filename[0]!='/' && g_str_has_suffix(filename, ui.filename)) warn=FALSE;
    	}
    	if (warn) 
		{
      		warning_dialog = gtk_message_dialog_new(GTK_WINDOW(winMain), 
        		GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO,
        		_("Should the file %s be overwritten?"), filename);
      			if (gtk_dialog_run(GTK_DIALOG(warning_dialog)) == GTK_RESPONSE_YES)
        			warn = FALSE;
      				gtk_widget_destroy(warning_dialog);
       	}
    } while (warn);

    gtk_widget_destroy(dialog);

	//printf("Filename: %s\n", filename);
	
	return filename;
}

char *mx_file_chooser_dialog_open_bg(const gchar          *title,
						             GtkWindow            *parent,
									 gboolean             *pAttach)
{
	GtkWidget *widget, *attach_opt;
	GtkWidget *background;
    GtkWidget *dialog;
    GtkFileFilter *filt_all, *filt_pspdf;
    char *filename;

    // object hierarchy:
	//       dialog
	//         |
    /* Create the widgets */
    dialog = gtk_dialog_new_with_buttons (title,
                                          parent,
                                          GTK_DIALOG_DESTROY_WITH_PARENT,
										  GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
     									  GTK_STOCK_OPEN, GTK_RESPONSE_OK,
                                          NULL);
  	gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);
  	gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);
  	gtk_box_set_spacing (GTK_BOX (GTK_DIALOG (dialog)->vbox), 2); /* 2 * 5 + 2 = 12 */
    gtk_container_set_border_width (GTK_CONTAINER (GTK_DIALOG (dialog)->action_area), 5);

  	g_signal_connect (dialog, "response",
		    G_CALLBACK (response_cb), NULL);

	/* Ensure that the dialog box is destroyed when the user responds. */
    //g_signal_connect_swapped (dialog,
    //                         "response",
    //                         G_CALLBACK (gtk_widget_destroy),
    //                         dialog);
	//             |- file_chooser_widget
    widget = g_object_new (GTK_TYPE_FILE_CHOOSER_WIDGET, NULL);

	g_signal_connect (widget, "file-activated",
		    G_CALLBACK (file_chooser_widget_file_activated), dialog);
  	g_signal_connect (widget, "default-size-changed",
		    G_CALLBACK (file_chooser_widget_default_size_changed), dialog);
  	g_signal_connect (widget, "response-requested",
		    G_CALLBACK (file_chooser_widget_response_requested), dialog);

  	gtk_container_set_border_width (GTK_CONTAINER (widget), 5);
  	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), widget, TRUE, TRUE, 0);

    filt_all = gtk_file_filter_new();
    gtk_file_filter_set_name(filt_all, _("All files"));
    gtk_file_filter_add_pattern(filt_all, "*");
    filt_pspdf = gtk_file_filter_new();
    gtk_file_filter_set_name(filt_pspdf, _("PS/PDF files (as bitmaps)"));
    gtk_file_filter_add_pattern(filt_pspdf, "*.ps");
    gtk_file_filter_add_pattern(filt_pspdf, "*.PS");
    gtk_file_filter_add_pattern(filt_pspdf, "*.pdf");
    gtk_file_filter_add_pattern(filt_pspdf, "*.PDF");
    gtk_file_chooser_add_filter(GTK_FILE_CHOOSER (widget), filt_pspdf);
    gtk_file_chooser_add_filter(GTK_FILE_CHOOSER (widget), filt_all);

    attach_opt = gtk_check_button_new_with_label(_("Attach file to the journal"));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(attach_opt), FALSE);
    gtk_file_chooser_set_extra_widget(GTK_FILE_CHOOSER (widget), attach_opt);

	if (ui.default_path!=NULL) gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER (widget), ui.default_path);

  	gtk_widget_show (widget);

  	if (gtk_dialog_run(GTK_DIALOG(dialog)) != GTK_RESPONSE_OK) {
    	gtk_widget_destroy(dialog);
    	return NULL;
  	}
  	filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (widget));
    *pAttach = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(attach_opt));
  	gtk_widget_destroy(dialog);

	//printf("Filename: %s\n", filename);
	
	return filename;
}

char *mx_file_chooser_dialog_savePDF(const gchar          *title,
						             GtkWindow            *parent)
{
	GtkWidget *widget;
  	GtkWidget *dialog, *warning_dialog;
  	GtkFileFilter *filt_all, *filt_pdf;
  	char *filename, *in_fn;
  	char stime[30];
  	time_t curtime;
  	gboolean warn;
	
    // object hierarchy:
	//       dialog
	//         |
    /* Create the widgets */
    dialog = gtk_dialog_new_with_buttons (title,
                                          parent,
                                          GTK_DIALOG_DESTROY_WITH_PARENT,
										  GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
     									  GTK_STOCK_SAVE, GTK_RESPONSE_OK,
                                          NULL);
  	gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);
  	gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);
  	gtk_box_set_spacing (GTK_BOX (GTK_DIALOG (dialog)->vbox), 2); /* 2 * 5 + 2 = 12 */
    gtk_container_set_border_width (GTK_CONTAINER (GTK_DIALOG (dialog)->action_area), 5);

  	g_signal_connect (dialog, "response",
		    G_CALLBACK (response_cb), NULL);

	/* Ensure that the dialog box is destroyed when the user responds. */
    //g_signal_connect_swapped (dialog,
    //                         "response",
    //                         G_CALLBACK (gtk_widget_destroy),
    //                         dialog);
	//             |- file_chooser_widget
    widget = g_object_new (GTK_TYPE_FILE_CHOOSER_WIDGET, NULL);

	g_signal_connect (widget, "file-activated",
		    G_CALLBACK (file_chooser_widget_file_activated), dialog);
  	g_signal_connect (widget, "default-size-changed",
		    G_CALLBACK (file_chooser_widget_default_size_changed), dialog);
  	g_signal_connect (widget, "response-requested",
		    G_CALLBACK (file_chooser_widget_response_requested), dialog);

  	gtk_container_set_border_width (GTK_CONTAINER (widget), 5);
  	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), widget, TRUE, TRUE, 0);

	gtk_file_chooser_set_action(GTK_FILE_CHOOSER (widget), GTK_FILE_CHOOSER_ACTION_SAVE);

  	gtk_widget_show (widget);

	// Create filename
  	if (ui.filename!=NULL) 
	{
    	if (g_str_has_suffix(ui.filename, ".xoj")) 
		{
      		in_fn = g_strdup(ui.filename);
      		g_strlcpy(g_strrstr(in_fn, "xoj"), "pdf", 4);
    	} 
    	else
		{
      		in_fn = g_strdup_printf("%s.pdf", ui.filename);
		}
    	gtk_file_chooser_set_filename(GTK_FILE_CHOOSER (widget), in_fn);
    	gtk_file_chooser_set_current_name(GTK_FILE_CHOOSER (widget), g_basename(in_fn));
  	} 
	else 
	{
    	curtime = time(NULL);
    	strftime(stime, 30, "%F-Note-%H-%M.pdf", localtime(&curtime));
    	if (ui.default_path!=NULL)
      		gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER (widget), ui.default_path);
    	gtk_file_chooser_set_current_name(GTK_FILE_CHOOSER (widget), stime);
    	in_fn = NULL;
  	}
     
  	filt_all = gtk_file_filter_new();
  	gtk_file_filter_set_name(filt_all, _("All files"));
  	gtk_file_filter_add_pattern(filt_all, "*");
  	filt_pdf = gtk_file_filter_new();
  	gtk_file_filter_set_name(filt_pdf, _("PDF files"));
  	gtk_file_filter_add_pattern(filt_pdf, "*.pdf");
  	gtk_file_filter_add_pattern(filt_pdf, "*.PDF");
  	gtk_file_chooser_add_filter(GTK_FILE_CHOOSER (widget), filt_pdf);
  	gtk_file_chooser_add_filter(GTK_FILE_CHOOSER (widget), filt_all);
  	gtk_dialog_set_default_response(GTK_DIALOG(dialog), GTK_RESPONSE_OK);
  	g_free(in_fn);
  
  	do {
    	if (gtk_dialog_run(GTK_DIALOG(dialog)) != GTK_RESPONSE_OK) 
		{
      		gtk_widget_destroy(dialog);
      		return NULL;
    	}
    	filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (widget));
    	warn = g_file_test(filename, G_FILE_TEST_EXISTS);
    	if (warn) 
		{
      		warning_dialog = gtk_message_dialog_new(GTK_WINDOW(winMain),
        		GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO,
        		_("Should the file %s be overwritten?"), filename);
      		if (gtk_dialog_run(GTK_DIALOG(warning_dialog)) == GTK_RESPONSE_YES)
        		warn = FALSE;
      		gtk_widget_destroy(warning_dialog);
    	}
  	} while(warn);
    
  	gtk_widget_destroy(dialog);

	return filename;
}


/* GtkDialog::response handler */
static void
response_cb (GtkDialog *dialog,
	     gint       response_id)
{
}
