#ifndef __IPC_H__
#define __IPC_H__

/**
 * File Name  : ipc.h
 *
 * Description: The dbus-based eripc functions 
 */

/*
 * This file is part of hello_world.
 *
 * hello_world is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * hello_world is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2009 iRex Technologies B.V.
 * All rights reserved.
 */


//----------------------------------------------------------------------------
// Include Files
//----------------------------------------------------------------------------

#include <liberipc/eripc.h>

G_BEGIN_DECLS


//----------------------------------------------------------------------------
// Definitions
//---------------------------------------------------------------------------- 


//----------------------------------------------------------------------------
// Forward Declarations
//----------------------------------------------------------------------------


//----------------------------------------------------------------------------
// Type Declarations
//----------------------------------------------------------------------------


//----------------------------------------------------------------------------
// Global Constants
//----------------------------------------------------------------------------

//============================================================================
// Public Functions
//============================================================================

/**---------------------------------------------------------------------------
 *
 * Name :  ipc_set_services
 *
 * @brief  Setup IPC connection and register API functions
 *
 * @param  --
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void ipc_set_services ( void );

/**---------------------------------------------------------------------------
 *
 * Name :  ipc_unset_services
 *
 * @brief  Unregister API functions
 *
 * @param  --
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void ipc_unset_services ( void );


/**---------------------------------------------------------------------------
 *
 * Name :  ipc_sys_startup_complete
 *
 * @brief  Report "application started" to sysd
 *
 * @param  --
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void ipc_sys_startup_complete ( void );


G_END_DECLS

#endif /* __IPC_H__ */
