#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "dr-file.h"
#include "xournal.h"

#include <string.h>
#include <gtk/gtk.h>

#define TEMP_PATH "/media/mmcblk0p1/Programs"

// writing and reading a temp file.
gboolean
save_to_temp_file(void)
{
  	gchar *tmpfn;
  	gboolean success;

  	end_text();
  	reset_focus();
  	if (ui.filename == NULL) 
	{
	  	tmpfn = g_build_filename(TEMP_PATH, ".xournal_sav.xoj", NULL);
  	}
	else
	{
		tmpfn = g_strdup(ui.filename);
	}
	
  	// overwrite any exsisting!
  	success = save_journal(tmpfn);
  	// we can not take any action, since we are running in background or
  	// we are shutting down
	
  	g_free(tmpfn);
	
  	return success;
}

gboolean
read_from_temp_file(void)
{
  gchar *tmpfn;
  gboolean success;

  tmpfn = g_build_filename(TEMP_PATH, ".xournal_sav.xoj", NULL);

  success = open_journal(tmpfn);
  if (success)
  {
	  // The file exsisted and is now read, so remove it.
	  g_remove(tmpfn);
  }
	
  g_free(tmpfn);
	
  return success;
}

