/**
 * File Name  : delta.h
 *
 * Description: Delta driver for iOn platform
 */

/*
 * This file is part of display.
 *
 * display is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * display is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#include <linux/ioctl.h>

#define WAVEFORM_SIZE 		(128*1024)

#define DEPTH_1BPP		(1)
#define DEPTH_2BPP	    	(2)
#define DEPTH_4BPP		(4)

#define WAVEFORM_4BPP_IMAGE	(1)
#define WAVEFORM_DRAW           (4)

struct display_update_info 
{
    int waveform;
    int color;
};

struct point_info
{
    unsigned short x;
    unsigned short y;
    unsigned char  size;
    unsigned char  color;
    unsigned char  pen_down;
};

struct wave_info
{
    int wave_type;
    unsigned long size;
    char *wave;
};    

#define PIXELBUFSIZE 25
struct transfer_buffer 
{
        unsigned int count;
        struct point_info point_list [PIXELBUFSIZE];
};

struct brush_draw_info
{
        /* Parameters refering to the brush source picture, as stored in the DELTA SRAM */
        unsigned short sourcex;
        unsigned short sourcey;
        unsigned short sizex;
        unsigned short sizey;
        /* Parameters refering to the destination position of the brush on the screen. */
        unsigned short destx;
        unsigned short desty;
        /* Parameter that specifies the two LSB's of the brush. 
         * The MSB's are specified by the brush image as stored in the DELTA SRAM 
         */
        unsigned short brushlsb;
};

struct busy_info
{
    unsigned short delay;
    unsigned short x;
    unsigned short y;
};

#define FBIO_DELTA_BASE                	'v'
#define FBIO_DELTA_UPDATE_DISPLAY      	_IOW(FBIO_DELTA_BASE, 1, struct display_update_info)
#define FBIO_DELTA_ERASE               	_IOW(FBIO_DELTA_BASE, 2, struct display_update_info)
#define FBIO_DELTA_DRAWMODE_PIXELS     	_IOW(FBIO_DELTA_BASE, 3, struct transfer_buffer)
#define FBIO_DELTA_BUSY             	_IOW(FBIO_DELTA_BASE, 4, struct busy_info) 
#define FBIO_DELTA_PROGRESS         	_IOW(FBIO_DELTA_BASE, 5, int)
#define FBIO_DRAW_BRUSH_GENERIC         _IOW(FBIO_DELTA_BASE, 9, struct brush_draw_info)
#define FBIO_DELTA_REDRAW             	_IOW(FBIO_DELTA_BASE, 10, struct display_update_info)
/* Temporary experimental IOCTLs */
#define FBIO_DELTA_UPLOADWAVES          _IOW(FBIO_DELTA_BASE, 1001, struct wave_info)
#define FBIO_DETA_VCOM_SET              _IOW(FBIO_DELTA_BASE, 1002, signed long)
