#!/usr/bin/env python
# -*- coding: utf-8 -*-

import getopt, os, sys, codecs, time
from pmodules import *

def main():
	
	
	#testA = pString()
	#testA += "This is a test.\r\nAnd alls is as\r\nexpected."
	
	#print len(testA.pText)
	#print len(testA.format)
	
	#testA = testA.Replace('\r\n', '\n') 
	#testA = testA.Replace('s is ', 's ain\'t ') 
	
	#print len(testA.pText)
	#print len(testA.format)
	
	#sys.exit(0)
	
	try:
		opts, args = getopt.getopt(sys.argv[1:], "?hp:i:o:", ["help", "profile=", "input=", "output="])
	except getopt.GetoptError, err:
		print u'\nERROR: ' + str(err)+u'\n'
		usage()
	
	args = {}
	
	for o, a in opts:
		if o == "-?": usage()
		elif o == "-h": usage()
		elif o in ("-i", "--input"):
			infilename = a
			args['infilename'] = a
			args['filename'] = a.strip()[0:a.rfind('.')]
			if infilename[-4:].lower() == '.rtf':
				args['type'] = u'rtf'
			elif infilename[-4:].lower() == '.htm' or infilename[-5:].lower() == '.html':
				args['type'] = u'html'
			else:
				args['type'] = u'txt'
		elif o in ("-p", "--profile"):
			if (a.lower().strip() == 'en') or (a.lower().strip() == 'hu'):
				args['profile'] = a.lower().strip()
			else:
				print u'\nERROR: profile must be \'en\' (english) or \'hu\' (magyar)'
				sys.exit(2)
		elif o in ("-o", "--output"):
			if a.lower().strip() == 'rtf':
				args['output'] = 'rtf'
			elif a.lower().strip() == 'txt':
				args['output'] = 'txt'
			elif a.lower().strip() == 'htm':
				args['output'] = 'html'
			elif a.lower().strip() == 'html':
				args['output'] = 'html'
			elif a.lower().strip() == 'latex':
				args['output'] = 'tex'
			elif a.lower().strip() == 'tex':
				args['output'] = 'tex'
			elif a.lower().strip() == 'xelatex':
				args['output'] = 'tex'
			else:
				print u'\nERROR: output must be \'txt\', \'latex\', \'rtf\', or \'html\''
				sys.exit(2)
	
	if not(args.has_key('infilename')):
		usage()
	
	if not(args.has_key('output')):
		args['output'] = 'txt'
	
	if not(args.has_key('profile')):
		args['profile'] = 'en'
	
	if args['type'] == 'html':
		print u'\nERROR: HTML input not yet supported, but coming soon.'
		sys.exit(2)
	
	pacify = Pacify(args)
	
	return

def usage():
	print u"\nUsage: pacify.py -p [en|hu] -i input.[txt|rtf|htm|html] -o [txt|rtf|htm|html]]"
	sys.exit(1)

if __name__ == "__main__":
	main()
