/*
 * Decompiled with CFR 0.152.
 */
package Catalog.util;

import Catalog.util.Viewer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Viewers
extends ArrayList<Viewer> {
    private static final String VERSION = "0.2";
    private static final long serialVersionUID = 1L;
    private static Viewers instance = null;
    String fileName = "viewers.dat";

    Viewers() {
        this.load();
    }

    public static Viewers getInstance() {
        if (instance == null) {
            instance = new Viewers();
        }
        return instance;
    }

    public ArrayList<Viewer> get(String suffix) {
        if (suffix == null || suffix.length() == 0) {
            return null;
        }
        ArrayList<Viewer> list = new ArrayList<Viewer>();
        for (Viewer v : this) {
            if (!v.getSuffix().equalsIgnoreCase(suffix)) continue;
            list.add(v);
        }
        if (list.isEmpty()) {
            list = null;
        }
        return list;
    }

    public boolean load() {
        this.clear();
        try {
            File file = new File(this.fileName);
            if (!file.exists()) {
                return true;
            }
            BufferedReader f = new BufferedReader(new FileReader(file));
            boolean ok = true;
            while (f.ready() && ok) {
                Viewer v = new Viewer();
                if (!v.read(f)) {
                    JOptionPane.showMessageDialog(null, "ERROR loading viewer:\n" + this.get(this.size() - 1), "Error", 0);
                    break;
                }
                this.add(v);
            }
            f.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "ERROR loading viewer:\n" + this.get(this.size() - 1), "Error", 0);
            return false;
        }
        return true;
    }

    public boolean save() {
        try {
            BufferedWriter f = new BufferedWriter(new FileWriter(this.fileName));
            for (Viewer v : this) {
                v.write(f);
            }
            f.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "ERROR saving converter:\n\nEXCEPTION:\n" + e, "Error", 0);
            return false;
        }
        return true;
    }

    public String getFileName() {
        return this.fileName;
    }
}

