/*
 * Decompiled with CFR 0.152.
 */
package Catalog.util;

import Catalog.Book;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class ToolBox {
    public static String getSuffix(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        int startPos = name.lastIndexOf(".");
        return name.substring(startPos + 1, name.length()).toLowerCase();
    }

    public static String getSuffix(Book book) {
        if (book == null) {
            return null;
        }
        return ToolBox.getSuffix(book.getFileName());
    }

    public static String getFileName(Book book) {
        if (book == null) {
            return null;
        }
        return book.getFileName();
    }

    public static String getPathName(Book book) {
        if (book == null) {
            return null;
        }
        String name = book.getFileName();
        if (name == null || name.length() == 0) {
            return null;
        }
        int startPos = name.lastIndexOf(File.separator);
        if (startPos < 0) {
            return "";
        }
        return name.substring(0, startPos);
    }

    public static String getBaseName(Book book) {
        if (book == null) {
            return null;
        }
        String name = book.getFileName();
        if (name == null || name.length() == 0) {
            return null;
        }
        int startPos = name.lastIndexOf(File.separator);
        int stopPos = name.lastIndexOf(".");
        if (startPos < 0) {
            startPos = 0;
        }
        if (stopPos < startPos) {
            stopPos = name.length();
        }
        return name.substring(startPos + 1, stopPos);
    }

    public static String readFile(String fileName) {
        StringBuffer buffer = new StringBuffer();
        try {
            BufferedReader f = new BufferedReader(new FileReader(fileName));
            while (f.ready()) {
                buffer.append(f.readLine().trim() + "\n");
            }
            f.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buffer.toString();
    }

    public static boolean copy(String src, String dest) {
        try {
            int c;
            BufferedReader in = new BufferedReader(new FileReader(src));
            BufferedWriter out = new BufferedWriter(new FileWriter(dest));
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean move(String src, String dest) {
        if (ToolBox.copy(src, dest)) {
            return new File(src).delete();
        }
        return false;
    }

    public static void provideMetaData(Book book, String fileName) {
        String text;
        book.setFileName(fileName);
        String suffix = fileName;
        int startPos = suffix.lastIndexOf(".");
        suffix = suffix.substring(startPos + 1, suffix.length()).toLowerCase();
        String author = book.getAuthor();
        String title = book.getTitle();
        String series = "";
        boolean i = false;
        int start = -1;
        int stop = -1;
        int pos = -1;
        start = -1;
        stop = -1;
        pos = -1;
        pos = stop = fileName.lastIndexOf(File.separator, fileName.length());
        start = fileName.lastIndexOf(File.separator, stop - 1);
        if (author.length() == 0) {
            author = fileName.substring(start + 1, stop).trim();
        }
        if ((start = fileName.lastIndexOf("-", (stop = fileName.lastIndexOf(".", fileName.length())) - 1)) == -1) {
            start = pos;
        }
        if (title.length() == 0) {
            title = fileName.substring(start + 1, stop).trim();
        }
        if ((start = fileName.lastIndexOf("-", (stop = start) - 1)) != -1 && start < stop) {
            series = fileName.substring(start + 1, stop).trim();
            book.setSeries(series);
        }
        if (author.length() == 0 || title.length() == 0) {
            if (suffix.equals("pdf")) {
                text = ToolBox.readFile(fileName);
                start = text.indexOf("/Author");
                if (start > 0) {
                    start = text.indexOf("(", start);
                    stop = text.indexOf(")", start);
                    author = text.substring(start + 1, stop);
                }
                if ((start = text.indexOf("/Title", stop)) > 0) {
                    start = text.indexOf("(", start);
                    stop = text.indexOf(")", start);
                    title = text.substring(start + 1, stop);
                }
            } else if (suffix.equals("html")) {
                text = ToolBox.readFile(fileName);
                start = text.indexOf("<title>");
                if (start == -1) {
                    start = text.indexOf("<TITLE>");
                }
                if (start > 0) {
                    stop = text.indexOf("</", start);
                    title = text.substring(start + 7, stop);
                }
            } else if (suffix.equals("lit")) {
                text = ToolBox.readFile(fileName);
                start = text.indexOf("OverDriveGUID");
                if ((start = text.indexOf("\u0001\u0002\u0000", start)) > 0) {
                    stop = text.indexOf("aut\u0000", start) - 1;
                    if (stop < 0) {
                        stop = text.indexOf(0, start + 4);
                    }
                    title = text.substring(start + 3, stop);
                }
                if ((start = text.indexOf("aut\u0000", start)) > 0) {
                    stop = text.indexOf(0, start + 4);
                    author = text.substring(start + 4, stop);
                }
            } else if (suffix.equals("mobi")) {
                text = ToolBox.readFile(fileName);
                start = text.indexOf("\u0000MOBI");
                if ((start = text.indexOf("\u0013", start)) > 0) {
                    stop = text.indexOf("\u0000", start);
                    author = text.substring(start + 1, stop);
                    start = stop;
                }
                if (start > 0) {
                    stop = text.indexOf("\u0000", start + 1);
                    title = text.substring(start + 1, stop);
                }
            }
        }
        text = null;
        book.setTitle(title);
        book.setAuthor(author);
    }
}

