/*
 * Decompiled with CFR 0.152.
 */
package Catalog.util;

import Catalog.Book;
import Catalog.prefs.ViewPrefs;
import Catalog.util.LaunchBase;
import Catalog.util.LocaleSupport;
import Catalog.util.ToolBox;
import Catalog.util.Viewer;
import Catalog.util.Viewers;
import java.util.ArrayList;
import java.util.ResourceBundle;

public class LaunchViewer
extends LaunchBase {
    private static final String VERSION = "0.1";
    static LaunchViewer instance = null;
    static String[] labels = new String[]{"Choose a viewer from the list:", "Choose viewer", "Create a new Viewer", "Cancel", "No matching viewer found", "Message"};
    Viewers viewers = Viewers.getInstance();

    private LaunchViewer() {
        System.out.println("get ResourceBundle");
        ResourceBundle msgs = LocaleSupport.getMessages();
        System.out.println("msgs in LaunchViewer: " + msgs);
        LaunchViewer.labels[0] = msgs.getString("view_choose");
        LaunchViewer.labels[1] = msgs.getString("view_view");
        LaunchViewer.labels[2] = msgs.getString("pref_create");
        LaunchViewer.labels[3] = msgs.getString("pref_cancel");
        LaunchViewer.labels[4] = msgs.getString("pref_msgtext");
        LaunchViewer.labels[5] = msgs.getString("pref_msgtitle");
    }

    public static LaunchBase getInstance() {
        if (instance == null) {
            instance = new LaunchViewer();
        }
        return instance;
    }

    public void launch(Book book, Object object) {
        if (book == null || object == null) {
            return;
        }
        Viewer viewer = (Viewer)object;
        this.outputLog = null;
        this.errorLog = null;
        String[] cmd = new String[viewer.argc() + 1];
        cmd[0] = viewer.getProgram();
        if (cmd[0] == null || cmd[0].length() == 0) {
            return;
        }
        for (int i = 0; i < viewer.argc(); ++i) {
            cmd[i + 1] = this.parse(viewer.getArg(i), book);
        }
        this.execute(cmd);
    }

    public Object findProgram(Book book) {
        if (book == null) {
            return null;
        }
        String suffix = ToolBox.getSuffix(book.getFileName());
        ArrayList<Viewer> list = this.viewers.get(suffix);
        if (list != null) {
            int n = list.size();
            if (n == 1) {
                return list.get(0);
            }
            if (n > 1) {
                Object[] options = new String[n];
                for (int i = 0; i < n; ++i) {
                    options[i] = list.get(i).getProgram();
                }
                String s = this.getStringChoice(labels, options);
                if (s == null || s.length() == 0) {
                    return null;
                }
                for (int i = 0; i < n; ++i) {
                    Viewer v = list.get(i);
                    if (!s.equals(v.getProgram())) continue;
                    return v;
                }
                return null;
            }
        } else {
            Object[] options = new Object[]{labels[2], labels[3]};
            if (this.getBooleanChoice(labels, options)) {
                ViewPrefs.getInstance().newEntry(suffix, null);
                this.startPrefs(1);
            }
            return null;
        }
        return null;
    }
}

