/*
 * Decompiled with CFR 0.152.
 */
package Catalog.util;

import Catalog.Book;
import Catalog.prefs.ConvPrefs;
import Catalog.util.Converter;
import Catalog.util.Converters;
import Catalog.util.LaunchBase;
import Catalog.util.LocaleSupport;
import Catalog.util.ToolBox;
import Catalog.util.Viewer;
import java.util.ArrayList;
import java.util.ResourceBundle;

public class LaunchConverter
extends LaunchBase {
    private static final String VERSION = "0.1";
    static LaunchConverter instance = null;
    static String[] tokens = new String[]{"%file", "%path", "%base", "%/", "%author", "%title", "%image", "%description"};
    static String[] methods = new String[]{"getFileName", "getPathName", "getBaseName", "getSeparator", "getAuthor", "getTitle", "getImageName", "getDescription"};
    static String[] labels = new String[]{"Choose a converter from the list:", "Choose converter", "Create a new Converter", "Cancel", "No matching converter found", "Message"};
    Converters converters = Converters.getInstance();

    private LaunchConverter() {
        ResourceBundle msgs = LocaleSupport.getMessages();
        LaunchConverter.labels[0] = msgs.getString("conv_choose");
        LaunchConverter.labels[1] = msgs.getString("conv_conv");
        LaunchConverter.labels[2] = msgs.getString("pref_create");
        LaunchConverter.labels[3] = msgs.getString("pref_cancel");
        LaunchConverter.labels[4] = msgs.getString("pref_msgtext");
        LaunchConverter.labels[5] = msgs.getString("pref_msgtitle");
    }

    public static LaunchBase getInstance() {
        if (instance == null) {
            instance = new LaunchConverter();
        }
        return instance;
    }

    public void launch(Book book, Object object) {
        if (book == null || object == null) {
            return;
        }
        Converter converter = (Converter)object;
        this.outputLog = null;
        this.errorLog = null;
        String[] cmd = new String[converter.argc() + 1];
        cmd[0] = converter.getProgram();
        if (cmd[0] == null || cmd[0].length() == 0) {
            return;
        }
        for (int i = 0; i < converter.argc(); ++i) {
            cmd[i + 1] = this.parse(converter.getArg(i), book);
        }
        this.execute(cmd);
    }

    public Object findProgram(Book book) {
        Converters convs = Converters.getInstance();
        if (book == null) {
            return null;
        }
        String suffix = ToolBox.getSuffix(book.getFileName());
        ArrayList<Viewer> list = this.converters.get(suffix);
        if (list != null) {
            int n = list.size();
            System.out.println(list);
            if (n == 1) {
                return list.get(0);
            }
            if (n > 1) {
                Object[] options = new String[n];
                for (int i = 0; i < n; ++i) {
                    options[i] = list.get(i).getProgram();
                }
                String s = this.getStringChoice(labels, options);
                if (s == null || s.length() == 0) {
                    return null;
                }
                for (int i = 0; i < n; ++i) {
                    Converter c = (Converter)list.get(i);
                    if (!s.equals(c.getProgram())) continue;
                    return c;
                }
                return null;
            }
        } else {
            Object[] options = new Object[]{labels[2], labels[3]};
            if (this.getBooleanChoice(labels, options)) {
                ConvPrefs.getInstance().newEntry(suffix, null, null);
                this.startPrefs(2);
            }
            return null;
        }
        return null;
    }
}

