/*
 * Decompiled with CFR 0.152.
 */
package Catalog.prefs;

import Catalog.prefs.ArgsPrefs;
import Catalog.prefs.BasePrefs;
import Catalog.util.LocaleSupport;
import Catalog.util.Viewer;
import Catalog.util.Viewers;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.event.ListSelectionEvent;

public class ViewPrefs
extends BasePrefs {
    private static final String VERSION = "0.4";
    private static ViewPrefs instance = null;
    Viewers viewers = Viewers.getInstance();

    private ViewPrefs() {
        ResourceBundle msgs = LocaleSupport.getMessages();
        this.labels[0] = msgs.getString("pref_program");
        this.labels[1] = msgs.getString("view_suffix");
        this.labels[3] = msgs.getString("pref_new");
        this.labels[4] = msgs.getString("pref_args");
        this.labels[5] = msgs.getString("pref_delete");
        this.labels[6] = msgs.getString("pref_ok");
        this.labels[7] = msgs.getString("pref_cancel");
        this.labels[8] = msgs.getString("view_list");
        this.labels[9] = msgs.getString("view_title");
        this.initGUI();
    }

    public static ViewPrefs getInstance() {
        if (instance == null) {
            instance = new ViewPrefs();
        }
        return instance;
    }

    public void initGUI() {
        super.initGUI();
        this.setListData();
        Viewer v = (Viewer)this.list.getSelectedValue();
        if (v != null) {
            this.programText.setText(v.getProgram());
            this.suffixText.setText(v.getSuffix());
        } else {
            this.programText.setText("");
            this.suffixText.setText("");
        }
        this.programText.grabFocus();
    }

    public void newEntry(String from, String program) {
        Viewer v = new Viewer();
        v.setProgram(program != null ? program : "?");
        v.setSuffix(from != null ? from : "?");
        this.viewers.add(v);
        this.programText.setText(v.getProgram());
        this.suffixText.setText(v.getSuffix());
        this.setListData(-1);
        this.enableUI(false);
    }

    void setListData(int i) {
        this.list.setListData(this.viewers.toArray());
        this.list.setSelectedIndex(i < 0 ? this.viewers.size() - 1 : i);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        Object src = e.getSource();
        Viewer v = (Viewer)this.list.getSelectedValue();
        if (src == this.programText) {
            if (v == null) {
                return;
            }
            v.setProgram(this.programText.getText());
            this.setListData();
        } else if (src == this.suffixText) {
            if (v == null) {
                return;
            }
            v.setSuffix(this.suffixText.getText());
            this.setListData();
            this.enableUI(true);
            this.argButton.grabFocus();
        } else if (src == this.newButton) {
            this.newEntry("?", "?");
        } else if (src == this.argButton) {
            if (v == null) {
                return;
            }
            ArgsPrefs argsPrefs = ArgsPrefs.getInstance();
            argsPrefs.setViewer(v);
            if (v.argc() == 0) {
                argsPrefs.newEntry("?");
            }
            argsPrefs.show(this);
        } else if (src == this.delButton) {
            int i = this.list.getSelectedIndex();
            if (i < 0) {
                return;
            }
            this.viewers.remove(i);
            this.setListData(i);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        Viewer c = (Viewer)this.list.getSelectedValue();
        if (c == null) {
            return;
        }
        if (this.programText != null) {
            this.programText.setText(c.getProgram());
        }
        if (this.suffixText != null) {
            this.suffixText.setText(c.getSuffix());
        }
    }
}

