/*
 * Decompiled with CFR 0.152.
 */
package Catalog.prefs;

import Catalog.util.LocaleSupport;
import Catalog.util.UIFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class GeneralPrefs
implements ActionListener,
DropTargetListener {
    private static final String VERSION = "0.1";
    private static GeneralPrefs instance = null;
    String lang;
    String path = "";
    String plugIn = "Catalog.devs.Iliad";
    JTextField langText;
    JTextField pathText;
    JTextField plugInText;
    JButton pathBT;
    JButton plugInBT;
    JPanel mainPanel;
    String[] labels = new String[]{"Language", "eBook-Path", "eBook-Plugin"};

    private GeneralPrefs() {
        this.load(new String[0]);
    }

    public static GeneralPrefs getInstance() {
        if (instance == null) {
            instance = new GeneralPrefs();
        }
        return instance;
    }

    public void load(String[] args) {
        String propFile = System.getProperties().getProperty("user.home") + File.separator + "." + "Catalog" + "rc";
        try {
            Properties config = new Properties();
            config.load(new FileInputStream(new File(propFile)));
            this.lang = config.getProperty("lang");
            this.path = config.getProperty("path");
            this.plugIn = config.getProperty("plugin", this.plugIn);
        }
        catch (IOException e) {
            // empty catch block
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-lang") && i + 1 < args.length) {
                this.lang = args[i + 1];
            }
            if (args[i].equals("-path") && i + 1 < args.length) {
                this.path = args[i + 1];
            }
            if (!args[i].equals("-plugin") || i + 1 >= args.length) continue;
            this.plugIn = args[i + 1];
        }
        LocaleSupport.setLocale(this.lang);
        this.initLocale();
    }

    public void save() {
        this.getLang();
        this.getPath();
        this.getPlugIn();
        String propFile = System.getProperties().getProperty("user.home") + File.separator + "." + "Catalog" + "rc";
        try {
            PrintWriter f = new PrintWriter(new FileWriter(propFile));
            if (this.lang.length() > 0) {
                f.println("lang: " + this.lang);
            }
            if (this.path.length() > 0) {
                f.println("path: " + this.path);
            }
            if (this.plugIn.length() > 0) {
                f.println("plugin: " + this.plugIn);
            }
            f.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getLang() {
        if (this.langText != null) {
            this.lang = this.langText.getText();
            LocaleSupport.setLocale(this.lang);
        }
        return this.lang;
    }

    public String getPath() {
        if (this.pathText != null) {
            this.path = this.pathText.getText();
        }
        return this.path;
    }

    public void setPath(String s) {
        this.path = s;
        if (this.pathText != null) {
            this.pathText.setText(this.path);
        }
    }

    public String getPlugIn() {
        if (this.plugInText != null) {
            this.plugIn = this.plugInText.getText();
        }
        return this.plugIn;
    }

    public void setPlugIn(String s) {
        this.plugIn = s;
        if (this.plugInText != null) {
            this.plugInText.setText(s);
        }
    }

    void initLocale() {
        ResourceBundle msgs = LocaleSupport.getMessages();
        this.labels[0] = msgs.getString("pref_lang");
        this.labels[1] = msgs.getString("pref_path");
        this.labels[2] = msgs.getString("pref_plugin");
    }

    public void initGUI() {
        String osType = System.getProperty("os.name").toLowerCase();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("Oops!");
            e.printStackTrace();
        }
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.langText = UIFactory.newTextField(20, LocaleSupport.getLang(), "TXT::lang", this, null);
        this.mainPanel.add(UIFactory.addElements(this.labels[0], this.langText));
        this.pathBT = UIFactory.newButton(this.labels[1], "BT::path", 'P', this);
        this.pathText = UIFactory.newTextField(20, this.path, "TXT::path", this, null);
        UIFactory.addElements(this.mainPanel, (JComponent)this.pathBT, this.pathText);
        this.plugInBT = UIFactory.newButton(this.labels[2], "BT::plugin", 'I', this);
        this.plugInText = UIFactory.newTextField(20, this.plugIn, "TXT:plugin", this, null);
        UIFactory.addElements(this.mainPanel, (JComponent)this.plugInBT, this.plugInText);
        new DropTarget(this.pathText, this);
        new DropTarget(this.plugInText, this);
    }

    public JPanel getPanel() {
        return this.mainPanel;
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void dragEnter(DropTargetDragEvent e) {
    }

    public void dragExit(DropTargetEvent e) {
    }

    public void dragOver(DropTargetDragEvent e) {
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void drop(DropTargetDropEvent e) {
        Transferable tr = null;
        DataFlavor[] flavors = null;
        List fileList = null;
        try {
            tr = e.getTransferable();
            flavors = tr.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].isFlavorJavaFileListType()) continue;
                e.acceptDrop(3);
                fileList = (List)tr.getTransferData(flavors[i]);
                e.dropComplete(true);
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            e.rejectDrop();
            return;
        }
        String file = "";
        Component src = ((DropTarget)e.getSource()).getComponent();
        if (fileList.size() > 1) {
            System.out.println("Only one file expected and thus accepted");
        }
        File f = (File)fileList.get(0);
        if (src == this.plugInText) {
            try {
                file = f.getCanonicalPath();
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (file == null || file.length() == 0) {
                return;
            }
            this.plugInText.setText(file);
        }
    }
}

