/*
 * Decompiled with CFR 0.152.
 */
package Catalog.prefs;

import Catalog.prefs.ArgsPrefs;
import Catalog.prefs.BasePrefs;
import Catalog.util.Converter;
import Catalog.util.Converters;
import Catalog.util.LocaleSupport;
import Catalog.util.UIFactory;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;

public class ConvPrefs
extends BasePrefs {
    private static final String VERSION = "0.4";
    private static ConvPrefs instance = null;
    Converters converters = Converters.getInstance();
    JTextField targetText;

    private ConvPrefs() {
        ResourceBundle msgs = LocaleSupport.getMessages();
        this.labels[0] = msgs.getString("pref_program");
        this.labels[1] = msgs.getString("conv_suffix");
        this.labels[2] = msgs.getString("conv_target");
        this.labels[3] = msgs.getString("pref_new");
        this.labels[4] = msgs.getString("pref_args");
        this.labels[5] = msgs.getString("pref_delete");
        this.labels[6] = msgs.getString("pref_ok");
        this.labels[7] = msgs.getString("pref_cancel");
        this.labels[8] = msgs.getString("conv_list");
        this.labels[9] = msgs.getString("conv_title");
        this.initGUI();
    }

    public static ConvPrefs getInstance() {
        if (instance == null) {
            instance = new ConvPrefs();
        }
        return instance;
    }

    public void initGUI() {
        super.initGUI();
        this.setListData();
        this.targetText = UIFactory.newTextField(20, "", this.labels[2], this, null);
        this.inputPanel.add(UIFactory.addElements(this.labels[2], this.targetText));
        Converter c = (Converter)this.list.getSelectedValue();
        if (c != null) {
            this.programText.setText(c.getProgram());
            this.suffixText.setText(c.getSuffix());
            this.targetText.setText(c.getTarget());
        } else {
            this.programText.setText("");
            this.suffixText.setText("");
            this.targetText.setText("");
        }
        this.programText.grabFocus();
    }

    public void newEntry(String from, String to, String program) {
        Converter c = new Converter();
        c.setProgram(program != null ? program : "?");
        c.setSuffix(from != null ? from : "?");
        c.setTarget(to != null ? to : "?");
        this.converters.add(c);
        this.programText.setText(c.getProgram());
        this.suffixText.setText(c.getSuffix());
        this.targetText.setText(c.getTarget());
        this.setListData(-1);
        this.enableUI(false);
    }

    void setListData(int i) {
        this.list.setListData(this.converters.toArray());
        this.list.setSelectedIndex(i < 0 ? this.converters.size() - 1 : i);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        Object src = e.getSource();
        Converter c = (Converter)this.list.getSelectedValue();
        if (src == this.programText) {
            if (c == null) {
                return;
            }
            c.setProgram(this.programText.getText());
            this.setListData();
        } else if (src == this.suffixText) {
            if (c == null) {
                return;
            }
            c.setSuffix(this.suffixText.getText());
            this.setListData();
            this.targetText.grabFocus();
        } else if (src == this.targetText) {
            if (c == null) {
                return;
            }
            c.setTarget(this.targetText.getText());
            this.setListData();
            this.enableUI(true);
            this.argButton.grabFocus();
        } else if (src.equals(this.newButton)) {
            this.newEntry("?", "?", "?");
        } else if (src == this.argButton) {
            if (c == null) {
                return;
            }
            ArgsPrefs argsPrefs = ArgsPrefs.getInstance();
            argsPrefs.setViewer(c);
            if (c.argc() == 0) {
                argsPrefs.newEntry("?");
            }
            argsPrefs.show(this);
        } else if (src == this.delButton) {
            int i = this.list.getSelectedIndex();
            if (i < 0) {
                return;
            }
            this.converters.remove(i);
            this.setListData(i);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        Converter c = (Converter)this.list.getSelectedValue();
        if (c == null) {
            return;
        }
        if (this.programText != null) {
            this.programText.setText(c.getProgram());
        }
        if (this.suffixText != null) {
            this.suffixText.setText(c.getSuffix());
        }
        if (this.targetText != null) {
            this.targetText.setText(c.getTarget());
        }
    }
}

