/*
 * Decompiled with CFR 0.152.
 */
package Catalog.prefs;

import Catalog.Catalog;
import Catalog.prefs.ConvPrefs;
import Catalog.prefs.GeneralPrefs;
import Catalog.prefs.ViewPrefs;
import Catalog.util.Converters;
import Catalog.util.LocaleSupport;
import Catalog.util.UIFactory;
import Catalog.util.Viewers;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class CatalogPrefs
implements ActionListener {
    private static final String VERSION = "0.1";
    private static CatalogPrefs instance = null;
    Viewers viewers = null;
    Converters converters = null;
    JDialog window;
    JTabbedPane tabPanel;
    String[] labels = new String[]{"General", "Viewers", "Converters", "OK", "Cancel", "Save"};

    private CatalogPrefs() {
        ResourceBundle msgs = LocaleSupport.getMessages();
        this.converters = Converters.getInstance();
        this.viewers = Viewers.getInstance();
        this.labels[0] = msgs.getString("pref_general");
        this.labels[1] = msgs.getString("view_list");
        this.labels[2] = msgs.getString("conv_list");
        this.labels[3] = msgs.getString("pref_ok");
        this.labels[4] = msgs.getString("pref_cancel");
        this.labels[5] = msgs.getString("label_save");
        this.initGUI();
    }

    public static CatalogPrefs getInstance() {
        if (instance == null) {
            instance = new CatalogPrefs();
        }
        return instance;
    }

    public void initGUI() {
        ConvPrefs convPrefs;
        JPanel convPanel;
        ViewPrefs viewPrefs;
        JPanel viewPanel;
        if (this.window != null) {
            return;
        }
        String osType = System.getProperty("os.name").toLowerCase();
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("Oops!");
            e.printStackTrace();
        }
        GeneralPrefs generalPrefs = GeneralPrefs.getInstance();
        JPanel generalPanel = generalPrefs.getPanel();
        if (generalPanel == null) {
            generalPrefs.initGUI();
            generalPanel = generalPrefs.getPanel();
        }
        if ((viewPanel = (viewPrefs = ViewPrefs.getInstance()).getPanel()) == null) {
            viewPrefs.initGUI();
            viewPanel = viewPrefs.getPanel();
        }
        if ((convPanel = (convPrefs = ConvPrefs.getInstance()).getPanel()) == null) {
            convPrefs.initGUI();
            convPanel = convPrefs.getPanel();
        }
        this.tabPanel = new JTabbedPane();
        this.tabPanel.add(this.labels[0], generalPanel);
        this.tabPanel.add(this.labels[1], viewPanel);
        this.tabPanel.add(this.labels[2], convPanel);
        JPanel confirmPanel = new JPanel();
        confirmPanel.setBorder(BorderFactory.createEtchedBorder());
        confirmPanel.add(UIFactory.newButton(this.labels[4], "BT:" + this.labels[4], 'c', this));
        confirmPanel.add(UIFactory.newButton(this.labels[3], "BT:" + this.labels[3], 'o', this));
        confirmPanel.add(UIFactory.newButton(this.labels[5], "BT:" + this.labels[5], 's', this));
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.tabPanel, "Center");
        mainPanel.add((Component)confirmPanel, "South");
        JFrame owner = Catalog.getInstance().getWindow();
        this.window = new JDialog(owner, "Catalog-Prefs", true);
        this.window.add(mainPanel);
    }

    public void show() {
        if (this.window == null) {
            return;
        }
        this.window.pack();
        this.window.validate();
        this.window.repaint();
        ViewPrefs.getInstance().setListData();
        ConvPrefs.getInstance().setListData();
        this.window.setVisible(true);
    }

    public void selectTab(int i) {
        if (this.tabPanel == null) {
            return;
        }
        if (i != this.tabPanel.getSelectedIndex()) {
            this.tabPanel.setSelectedIndex(i);
        }
    }

    public boolean isSetUp() {
        return this.window != null;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("BT:" + this.labels[3])) {
            this.window.setVisible(false);
        } else if (cmd.equals("BT:" + this.labels[4])) {
            this.viewers.load();
            this.converters.load();
            this.window.setVisible(false);
        } else if (cmd.equals("BT:" + this.labels[5])) {
            this.viewers.save();
            this.converters.save();
            GeneralPrefs.getInstance().save();
        }
        ViewPrefs.getInstance().enableUI(true);
        ConvPrefs.getInstance().enableUI(true);
    }
}

