/*
 * Decompiled with CFR 0.152.
 */
package Catalog.prefs;

import Catalog.prefs.BasePrefs;
import Catalog.util.LocaleSupport;
import Catalog.util.UIFactory;
import Catalog.util.Viewer;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;

public class ArgsPrefs
extends BasePrefs {
    private static final String VERSION = "0.4";
    private static ArgsPrefs instance = null;
    JDialog window;
    JPanel confirmPanel;
    JButton okButton;
    JButton cancelButton;
    Viewer originalViewer;
    Viewer viewer;
    BasePrefs caller;

    private ArgsPrefs() {
        ResourceBundle msgs = LocaleSupport.getMessages();
        this.labels[3] = msgs.getString("pref_new");
        this.labels[5] = msgs.getString("pref_delete");
        this.labels[6] = msgs.getString("pref_ok");
        this.labels[7] = msgs.getString("pref_cancel");
        this.labels[8] = msgs.getString("args_list");
        this.labels[9] = msgs.getString("args_title");
        this.initGUI();
    }

    public static ArgsPrefs getInstance() {
        if (instance == null) {
            instance = new ArgsPrefs();
        }
        return instance;
    }

    public void initGUI() {
        if (this.window != null) {
            return;
        }
        super.initGUI();
        this.inputPanel.removeAll();
        this.inputPanel.add(this.programText);
        this.buttonPanel.removeAll();
        this.okButton = UIFactory.newButton(this.labels[6], "BT:" + this.labels[6], 'o', this);
        this.cancelButton = UIFactory.newButton(this.labels[7], "BT:" + this.labels[7], 'c', this);
        this.buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.buttonPanel.add(this.newButton);
        this.buttonPanel.add(this.delButton);
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        if (this.viewer != null) {
            if (this.viewer.argc() == 0) {
                this.newEntry("?");
            }
            this.setListData(-1);
            this.programText.grabFocus();
        }
        this.window = new JDialog((Frame)null, this.labels[9], true);
        this.window.add(this.mainPanel);
        this.window.pack();
    }

    void show(BasePrefs calledBy) {
        this.caller = calledBy;
        this.setListData();
        this.window.setVisible(true);
    }

    public void setViewer(Viewer v) {
        this.originalViewer = v;
        this.viewer = v.clone();
    }

    public void newEntry(String arg) {
        this.viewer.addArg(arg);
        this.programText.setText(arg);
        this.setListData(-1);
        this.enableUI(false);
    }

    void setListData(int i) {
        this.list.setListData(this.viewer.getArgsArray());
        this.list.setSelectedIndex(i < 0 ? this.viewer.argc() - 1 : i);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        Object src = e.getSource();
        if (src.equals(this.programText)) {
            int i = this.list.getSelectedIndex();
            if (i < 0) {
                return;
            }
            this.viewer.setArg(i, this.programText.getText());
            this.enableUI(true);
            this.setListData(i);
            this.newButton.grabFocus();
        } else if (src.equals(this.newButton)) {
            this.newEntry("?");
        } else if (src.equals(this.delButton)) {
            int i = this.list.getSelectedIndex();
            if (i < 0) {
                return;
            }
            this.viewer.remove(i);
            if (--i < 0) {
                this.newEntry("?");
            } else {
                this.setListData(i);
            }
        } else if (src.equals(this.okButton)) {
            this.originalViewer.setArgs(this.viewer.getArgs());
            this.window.setVisible(false);
            if (this.caller != null) {
                this.caller.enableUI(true);
            }
        } else if (src.equals(this.cancelButton)) {
            this.window.setVisible(false);
            if (this.caller != null) {
                this.caller.enableUI(true);
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        String arg = (String)this.list.getSelectedValue();
        if (arg == null) {
            return;
        }
        if (this.programText != null) {
            this.programText.setText(arg);
        }
    }
}

