/*
 * Decompiled with CFR 0.152.
 */
package Catalog.devs;

import Catalog.Book;
import Catalog.devs.EBook;
import Catalog.util.LocaleSupport;
import Catalog.util.ToolBox;
import Catalog.util.UIFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public class Iliad
extends EBook {
    private static final String VERSION = "0.0";
    static String[] dialogStr = new String[]{"Catalog-Error", "An error occurred loading the booklist.", "No filename given.", "No desitination path given.", "Cannot create destination directory.", "The given file does not exist.", "Cannot copy the book.", "Cannot copy the image.", "Cannot write Manifest file", "Select file", "Select image", "Path to the eBook:", "Catalog-Dialog", "A runtime error occurred.", "This file-type is not supported.", "Accept this book?", "There are unsaved changes!\nDo you want them before leaving?"};

    public Iliad() {
        ResourceBundle msgs = LocaleSupport.getMessages();
        Iliad.dialogStr[0] = msgs.getString("dialog_err");
        Iliad.dialogStr[2] = msgs.getString("dialog_no_file");
        Iliad.dialogStr[11] = msgs.getString("dialog_device_path");
        Iliad.dialogStr[12] = msgs.getString("dialog_dialog");
        Iliad.dialogStr[3] = msgs.getString("dialog_no_path");
        Iliad.dialogStr[4] = msgs.getString("dialog_dir_err");
        Iliad.dialogStr[5] = msgs.getString("dialog_file_nex");
        Iliad.dialogStr[6] = msgs.getString("dialog_cant_copy_book");
        Iliad.dialogStr[7] = msgs.getString("dialog_cant_copy_image");
        Iliad.dialogStr[8] = msgs.getString("dialog_cant_write_manif");
        Iliad.dialogStr[1] = msgs.getString("dialog_load_err");
        Iliad.dialogStr[9] = msgs.getString("dialog_select_file");
        Iliad.dialogStr[10] = msgs.getString("dialog_select_image");
        Iliad.dialogStr[13] = msgs.getString("dialog_runtime_err");
        Iliad.dialogStr[14] = msgs.getString("dialog_conv_err");
        Iliad.dialogStr[15] = msgs.getString("dialog_dnd_accept");
        Iliad.dialogStr[16] = msgs.getString("dialog_save");
    }

    public String setPath(String path) {
        this.eBookPath = (String)JOptionPane.showInputDialog(null, dialogStr[11], dialogStr[12], -1, null, null, path);
        return this.eBookPath;
    }

    public boolean send(Book book) {
        File f;
        String srcBook = book.getFileName();
        String srcImage = book.getImageName();
        String dirName = null;
        String destBook = null;
        String destImage = null;
        if (srcBook.length() == 0) {
            UIFactory.errorMsg(dialogStr[0], dialogStr[2]);
            return false;
        }
        if (this.eBookPath.length() == 0) {
            UIFactory.errorMsg(dialogStr[0], dialogStr[3]);
            return false;
        }
        if (!this.eBookPath.endsWith(File.separator)) {
            this.eBookPath = this.eBookPath + File.separator;
        }
        if (!(f = new File(dirName = this.eBookPath + book.getTitle() + File.separator)).exists() && !f.mkdir()) {
            UIFactory.errorMsg(dialogStr[0], dialogStr[4] + " '" + dirName + "'");
            return false;
        }
        f = new File(srcBook);
        if (!f.exists()) {
            UIFactory.errorMsg(dialogStr[0], dialogStr[5]);
            return false;
        }
        destBook = f.getName();
        if (!ToolBox.copy(srcBook, dirName + destBook)) {
            UIFactory.errorMsg(dialogStr[0], dialogStr[6]);
            return false;
        }
        if (srcImage != null && srcImage.length() > 0) {
            f = new File(book.getImageName());
            if (f.exists()) {
                destImage = f.getName();
                if (!ToolBox.copy(srcImage, dirName + destImage)) {
                    UIFactory.errorMsg(dialogStr[0], dialogStr[7]);
                    return false;
                }
            } else {
                destImage = "";
            }
        }
        Date today = new Date();
        DateFormat date = LocaleSupport.getDateFormat();
        try {
            PrintWriter out = new PrintWriter(new FileWriter(dirName + "manifest.xml"));
            out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!--manifest generated by Catalog V2.0-->\n<package>\n  <metadata>\n    <dc-metadata>\n      <Title>" + book.getTitle() + "</Title>\n" + "      <Description>" + book.getAuthor() + (book.getSeries().length() > 0 ? " - " + book.getSeries() : "") + "</Description>\n" + "      <Date>" + date.format(today) + "</Date>\n" + "    </dc-metadata>\n" + "    <y-metadata>\n" + "      <startpage>" + destBook + "</startpage>\n" + "      <image>" + destImage + "</image>\n" + "      <version>000</version>\n" + "    </y-metadata>\n" + "  </metadata>\n" + "</package>");
            out.close();
        }
        catch (IOException e) {
            UIFactory.errorMsg(dialogStr[0], dialogStr[8]);
        }
        return true;
    }
}

