/*
 * Decompiled with CFR 0.152.
 */
package Catalog;

import Catalog.Book;
import Catalog.Books;
import Catalog.Catalog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class RemoteControl {
    public static void main(String[] args) {
        Object[] options = new Object[]{"Yeah, so be it", "Nah, skip it", "Stop it!"};
        if (args == null || args.length == 0) {
            JOptionPane.showMessageDialog(null, "No file given.", "Remote-Control", 0);
            System.exit(1);
        }
        ArrayList<String> files = new ArrayList<String>();
        try {
            BufferedReader f = new BufferedReader(new FileReader(args[0]));
            while (f.ready()) {
                files.add(f.readLine().trim());
            }
            f.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Error reading file '" + args[0] + "'.", "Remote-Control", 0);
            System.exit(2);
        }
        Catalog catalog = Catalog.getInstance();
        Books books = Books.getInstance();
        books.load();
        JOptionPane.showMessageDialog(null, "Start", "Remote-Control", 1);
        for (int i = 0; i < files.size(); ++i) {
            String line = (String)files.get(i);
            String author = "";
            String title = "";
            String series = "";
            String fileName = "";
            int start = -1;
            int stop = -1;
            int pos = -1;
            Book book = new Book();
            book.createGUID();
            pos = stop = line.lastIndexOf(File.separator, line.length());
            start = line.lastIndexOf(File.separator, stop - 1);
            author = line.substring(start + 1, stop).trim();
            book.setAuthor(author);
            stop = line.lastIndexOf(".", line.length());
            start = line.lastIndexOf("-", stop - 1);
            if (start == -1) {
                start = pos;
            }
            title = line.substring(start + 1, stop).trim();
            book.setTitle(title);
            stop = start;
            start = line.lastIndexOf("-", stop - 1);
            if (start != -1 && start < stop) {
                series = line.substring(start + 1, stop).trim();
            }
            book.setSeries(series);
            File file = new File(line);
            if (file.exists()) {
                fileName = file.getAbsolutePath();
            }
            book.setFileName(fileName);
            books.add(book);
        }
        catalog.init(args);
    }
}

