/*
 * Decompiled with CFR 0.152.
 */
package Catalog;

import Catalog.Book;
import Catalog.Books;
import Catalog.devs.EBook;
import Catalog.prefs.CatalogPrefs;
import Catalog.prefs.GeneralPrefs;
import Catalog.util.AWTFileChooser;
import Catalog.util.Docu;
import Catalog.util.FileChooser;
import Catalog.util.LaunchBase;
import Catalog.util.LaunchConverter;
import Catalog.util.LaunchViewer;
import Catalog.util.LocaleSupport;
import Catalog.util.SwingFileChooser;
import Catalog.util.ToolBox;
import Catalog.util.UIFactory;
import Catalog.util.Viewer;
import Catalog.util.Viewers;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class Catalog
implements WindowListener,
ActionListener,
MouseListener,
KeyListener,
DropTargetListener {
    public static final String PRG = "Catalog";
    public static final String AUTHOR = "T.Berndt";
    public static final String VERSION = "2.0";
    private static String[] labels = new String[]{"eBook-Catalog", "Authors", "Titles", "Book", "Author", "Title", "Genre", "Series", "File", "Image", "Description", "New", "Add", "Save", "Delete", "eBook", "Edit", "Cancel", "Open", "Find", "Convert", "Yes", "No", "Preferences", "Info", "Documentation", "Quit", "File"};
    private static String[] dialogStr = new String[]{"Catalog-Error", "An error occurred loading the booklist.", "No filename given.", "No desitination path given.", "Cannot create destination directory.", "The given file does not exist.", "Cannot copy the book.", "Cannot copy the image.", "Cannot write Manifest file", "Select file", "Select image", "Path to the eBook:", "Catalog-Dialog", "A runtime error occurred.", "This file-type is not supported.", "Accept this book?", "There are unsaved changes!\nDo you want them before leaving?"};
    private static Catalog instance = null;
    Books books;
    Book book;
    Book backup;
    JFrame window;
    JList authorList;
    JList titleList;
    DefaultListModel authorModel;
    DefaultListModel titleModel;
    JTextField authorText;
    JTextField titleText;
    JComboBox genreCB;
    DefaultComboBoxModel genreModel;
    JTextField seriesText;
    JButton fileBT;
    JTextField fileText;
    JButton imageBT;
    JTextField imageText;
    JLabel imageLabel;
    JEditorPane descriptionText;
    JButton newBT;
    JButton addBT;
    JButton saveBT;
    JButton deleteBT;
    JButton eBookBT;
    JButton openBT;
    JToggleButton editBT;
    JButton cancelBT;
    JToggleButton searchBT;
    JTextField searchText;
    JButton convertBT;
    FileChooser fc;
    boolean changes;
    String[] keyMapping = new String[Book.keys.length];
    boolean macOS = false;

    public static void main(String[] args) {
        GeneralPrefs.getInstance().load(args);
        Catalog.getInstance().init();
    }

    private Catalog() {
        this.books = Books.getInstance();
    }

    public static Catalog getInstance() {
        if (instance == null) {
            instance = new Catalog();
        }
        return instance;
    }

    public JFrame getWindow() {
        return this.window;
    }

    public Book getBook() {
        return this.book;
    }

    public void init() {
        this.initLocale();
        for (int i = 0; i < Book.keys.length; ++i) {
            this.keyMapping[i] = labels[i + 3];
        }
        this.initUI();
        this.loadBooks();
        this.window.validate();
        this.window.pack();
        this.window.setVisible(true);
    }

    void initLocale() {
        ResourceBundle msgs = LocaleSupport.getMessages();
        Catalog.labels[0] = msgs.getString("label_window_title");
        Catalog.labels[1] = msgs.getString("label_authors");
        Catalog.labels[2] = msgs.getString("label_titles");
        Catalog.labels[3] = msgs.getString("label_book");
        Catalog.labels[4] = msgs.getString("label_author");
        Catalog.labels[5] = msgs.getString("label_title");
        Catalog.labels[6] = msgs.getString("label_genre");
        Catalog.labels[7] = msgs.getString("label_series");
        Catalog.labels[8] = msgs.getString("label_file");
        Catalog.labels[9] = msgs.getString("label_image");
        Catalog.labels[10] = msgs.getString("label_desc");
        Catalog.labels[11] = msgs.getString("label_new");
        Catalog.labels[12] = msgs.getString("label_add");
        Catalog.labels[13] = msgs.getString("label_save");
        Catalog.labels[14] = msgs.getString("label_delete");
        Catalog.labels[15] = msgs.getString("label_ebook");
        Catalog.labels[16] = msgs.getString("label_edit");
        Catalog.labels[17] = msgs.getString("label_cancel");
        Catalog.labels[18] = msgs.getString("label_open");
        Catalog.labels[19] = msgs.getString("label_search");
        Catalog.labels[20] = msgs.getString("label_convert");
        Catalog.labels[21] = msgs.getString("label_yes");
        Catalog.labels[22] = msgs.getString("label_no");
        Catalog.labels[23] = msgs.getString("item_prefs");
        Catalog.labels[24] = msgs.getString("item_info");
        Catalog.labels[25] = msgs.getString("item_docu");
        Catalog.labels[26] = msgs.getString("item_quit");
        Catalog.labels[27] = msgs.getString("menu_file");
        Catalog.dialogStr[0] = msgs.getString("dialog_err");
        Catalog.dialogStr[1] = msgs.getString("dialog_load_err");
        Catalog.dialogStr[2] = msgs.getString("dialog_no_file");
        Catalog.dialogStr[3] = msgs.getString("dialog_no_path");
        Catalog.dialogStr[4] = msgs.getString("dialog_dir_err");
        Catalog.dialogStr[5] = msgs.getString("dialog_file_nex");
        Catalog.dialogStr[6] = msgs.getString("dialog_cant_copy_book");
        Catalog.dialogStr[7] = msgs.getString("dialog_cant_copy_image");
        Catalog.dialogStr[8] = msgs.getString("dialog_cant_write_manif");
        Catalog.dialogStr[9] = msgs.getString("dialog_select_file");
        Catalog.dialogStr[10] = msgs.getString("dialog_select_image");
        Catalog.dialogStr[11] = msgs.getString("dialog_device_path");
        Catalog.dialogStr[12] = msgs.getString("dialog_dialog");
        Catalog.dialogStr[13] = msgs.getString("dialog_runtime_err");
        Catalog.dialogStr[14] = msgs.getString("dialog_conv_err");
        Catalog.dialogStr[15] = msgs.getString("dialog_dnd_accept");
        Catalog.dialogStr[16] = msgs.getString("dialog_save");
    }

    void initUI() {
        String osType = System.getProperty("os.name").toLowerCase();
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if (osType.indexOf("mac") != -1) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            this.macOS = true;
            this.fc = new AWTFileChooser();
        } else {
            this.fc = new SwingFileChooser();
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.authorModel = new DefaultListModel();
        this.authorList = new JList(this.authorModel);
        this.authorList.addMouseListener(this);
        this.authorList.addKeyListener(this);
        JScrollPane authorScroller = new JScrollPane(this.authorList);
        JPanel authorPanel = new JPanel(new BorderLayout());
        authorPanel.setBorder(BorderFactory.createTitledBorder(labels[1]));
        authorPanel.add(authorScroller);
        authorPanel.setPreferredSize(new Dimension(250, 120));
        this.titleModel = new DefaultListModel();
        this.titleList = new JList(this.titleModel);
        this.titleList.addMouseListener(this);
        this.titleList.addKeyListener(this);
        JScrollPane titleScroller = new JScrollPane(this.titleList);
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBorder(BorderFactory.createTitledBorder(labels[2]));
        titlePanel.add(titleScroller);
        titlePanel.setPreferredSize(new Dimension(250, 120));
        JPanel bookPanel = new JPanel();
        bookPanel.setLayout(new BoxLayout(bookPanel, 1));
        bookPanel.setBorder(BorderFactory.createTitledBorder(labels[3]));
        this.authorText = UIFactory.newTextField(20, "", Book.keys[1], this, this);
        this.authorText.setEnabled(false);
        bookPanel.add(UIFactory.addElements(labels[4], this.authorText));
        this.titleText = UIFactory.newTextField(20, "", Book.keys[2], this, this);
        this.titleText.setEnabled(false);
        bookPanel.add(UIFactory.addElements(labels[5], this.titleText));
        this.genreModel = new DefaultComboBoxModel();
        this.genreCB = UIFactory.newComboBox(this.genreModel, Book.keys[3], null);
        this.genreCB.setEnabled(false);
        this.genreCB.setEditable(true);
        bookPanel.add(UIFactory.addElements(labels[6], this.genreCB));
        this.seriesText = UIFactory.newTextField(20, "", Book.keys[4], this, this);
        this.seriesText.setEnabled(false);
        bookPanel.add(UIFactory.addElements(labels[7], this.seriesText));
        this.fileBT = UIFactory.newButton(labels[8], "BT:" + labels[8], 'F', this);
        this.fileBT.setEnabled(false);
        this.fileText = UIFactory.newTextField(20, "", Book.keys[5], this, this);
        this.fileText.setEnabled(false);
        UIFactory.addElements(bookPanel, (JComponent)this.fileBT, this.fileText);
        this.imageBT = UIFactory.newButton(labels[9], "BT:" + labels[9], 'I', this);
        this.imageBT.setEnabled(false);
        this.imageText = UIFactory.newTextField(20, "", Book.keys[6], this, this);
        this.imageText.setEnabled(false);
        UIFactory.addElements(bookPanel, (JComponent)this.imageBT, this.imageText);
        JPanel imagePanel = new JPanel(new FlowLayout(4));
        this.imageLabel = new JLabel();
        this.imageLabel.setPreferredSize(new Dimension(200, 200));
        this.imageLabel.setBorder(BorderFactory.createTitledBorder(labels[9]));
        imagePanel.add(this.imageLabel);
        bookPanel.add(imagePanel);
        JPanel editorPanel = new JPanel(new BorderLayout());
        this.descriptionText = new JEditorPane();
        this.descriptionText.addKeyListener(this);
        this.descriptionText.setPreferredSize(new Dimension(400, 120));
        this.descriptionText.setEnabled(false);
        editorPanel.setBorder(BorderFactory.createTitledBorder(labels[10]));
        editorPanel.add((Component)new JScrollPane(this.descriptionText), "Center");
        bookPanel.add(editorPanel);
        bookPanel.setBorder(BorderFactory.createTitledBorder(labels[3]));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 0));
        mainPanel.add(authorPanel);
        mainPanel.add(titlePanel);
        mainPanel.add(bookPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.newBT = UIFactory.newButton(labels[11], "BT:" + labels[11], 'N', this);
        this.addBT = UIFactory.newButton(labels[12], "BT:" + labels[12], 'A', this);
        this.saveBT = UIFactory.newButton(labels[13], "BT:" + labels[13], 'S', this);
        this.deleteBT = UIFactory.newButton(labels[14], "BT:" + labels[14], 'D', this);
        this.eBookBT = UIFactory.newButton(labels[15], "BT:" + labels[15], 'B', this);
        this.editBT = new JToggleButton(labels[16]);
        this.editBT.setActionCommand("BT:" + labels[16]);
        this.editBT.setMnemonic('E');
        this.editBT.addActionListener(this);
        this.cancelBT = UIFactory.newButton(labels[17], "BT:" + labels[17], 'C', this);
        this.openBT = UIFactory.newButton(labels[18], "BT:" + labels[18], 'O', this);
        this.searchBT = new JToggleButton(labels[19]);
        this.searchBT.setActionCommand("BT:" + labels[19]);
        this.searchBT.setMnemonic('F');
        this.searchBT.addActionListener(this);
        this.convertBT = UIFactory.newButton(labels[20], "BT:" + labels[20], 'C', this);
        buttonPanel.add(this.newBT);
        buttonPanel.add(this.editBT);
        buttonPanel.add(this.addBT);
        buttonPanel.add(this.cancelBT);
        buttonPanel.add(this.saveBT);
        buttonPanel.add(this.deleteBT);
        buttonPanel.add(this.convertBT);
        buttonPanel.add(this.openBT);
        buttonPanel.add(this.searchBT);
        buttonPanel.add(this.eBookBT);
        this.searchText = UIFactory.newTextField(20, "", "TF:" + labels[19], this, null);
        JPanel footPanel = new JPanel();
        footPanel.setLayout(new BoxLayout(footPanel, 1));
        footPanel.add(buttonPanel);
        footPanel.add(this.searchText);
        this.addBT.setVisible(false);
        this.cancelBT.setVisible(false);
        this.searchText.setVisible(false);
        this.openBT.setVisible(true);
        JPanel windowPanel = new JPanel(new BorderLayout());
        windowPanel.add((Component)mainPanel, "Center");
        windowPanel.add((Component)footPanel, "South");
        this.window = new JFrame(labels[0]);
        this.window.setContentPane(windowPanel);
        this.window.addWindowListener(this);
        this.window.setDefaultCloseOperation(0);
        new DropTarget(this.authorList, this);
        new DropTarget(this.titleList, this);
        new DropTarget(this.fileText, this);
        new DropTarget(this.imageText, this);
        new DropTarget(this.imageLabel, this);
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu(labels[27]);
        menu.add(UIFactory.newMenuItem(labels[23], null, this));
        menu.add(UIFactory.newMenuItem(labels[24], null, this));
        menu.add(UIFactory.newMenuItem(labels[25], null, this));
        if (!this.macOS) {
            menu.add(UIFactory.newMenuItem(labels[26], null, this));
        }
        menuBar.add(menu);
        this.window.setJMenuBar(menuBar);
    }

    void makeAuthorList() {
        int j = 0;
        Object[] authorArray = new String[this.books.size() + 1];
        authorArray[0] = "*";
        for (Book b : this.books) {
            if (!b.isVisible()) continue;
            authorArray[++j] = b.getAuthor();
        }
        Arrays.sort(authorArray, 0, ++j);
        this.authorModel.removeAllElements();
        for (int i = 0; i < j; ++i) {
            if (this.authorModel.contains(authorArray[i])) continue;
            this.authorModel.addElement(authorArray[i]);
        }
        this.authorList.setSelectedIndex(0);
    }

    void makeTitleList(String author, String guid) {
        int i;
        int j = 0;
        int index = -1;
        int n = this.books.size();
        Object[] titleArray = new Title[n];
        if (this.books.size() == 0) {
            return;
        }
        if (author == null) {
            author = this.book.getAuthor();
        }
        if (guid == null && this.titleList.getSelectedIndex() != -1) {
            guid = ((Title)this.titleList.getSelectedValue()).guid;
        }
        this.titleModel.removeAllElements();
        for (i = 0; i < n; ++i) {
            Book b = (Book)this.books.get(i);
            if (!b.isVisible() || !author.equals("*") && !author.equals(b.getAuthor())) continue;
            titleArray[j++] = new Title(b.getGUID(), b.getTitle(), b.getSeries(), i);
        }
        Arrays.sort(titleArray, 0, j);
        for (i = 0; i < j; ++i) {
            this.titleModel.addElement(titleArray[i]);
            if (((Title)titleArray[i]).guid != guid) continue;
            index = i;
        }
        if (titleArray.length > 0) {
            this.titleList.setSelectedIndex(index != -1 ? index : 0);
            this.titleList.ensureIndexIsVisible(index);
            this.setBook();
        }
        this.window.setTitle(labels[0] + " (" + labels[1] + ": " + this.authorModel.size() + ", " + labels[2] + ": " + this.titleModel.getSize() + "/" + this.books.size() + ")");
    }

    void makeTitleList(String author) {
        this.makeTitleList(author, null);
    }

    void loadBooks() {
        if (!this.books.load()) {
            UIFactory.errorMsg(dialogStr[0], dialogStr[1]);
            return;
        }
        if (this.books.size() > 0) {
            this.makeAuthorList();
            this.makeTitleList("*");
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < this.books.size(); ++i) {
                String genre = ((Book)this.books.get(i)).getGenre();
                if (list.contains(genre)) continue;
                list.add(genre);
            }
            Object[] genres = list.toArray();
            Arrays.sort(genres);
            for (int i = 0; i < genres.length; ++i) {
                this.genreModel.addElement(genres[i]);
            }
            this.changes = false;
        } else {
            this.newBook();
        }
    }

    void saveBooks() {
        ToolBox.copy("books.dat", "books.dat.back");
        this.books.save();
        this.changes = false;
    }

    void setBook() {
        int i = this.titleList.getSelectedIndex();
        if (i < 0) {
            return;
        }
        Title t = (Title)this.titleList.getSelectedValue();
        this.book = (Book)this.books.get(t.pos);
        this.authorText.setText(this.book.getAuthor());
        this.titleText.setText(this.book.getTitle());
        this.genreCB.setSelectedItem(this.book.getGenre());
        this.seriesText.setText(this.book.getSeries());
        this.fileText.setText(this.book.getFileName());
        this.imageText.setText(this.book.getImageName());
        this.descriptionText.setText(this.book.getDescription());
        this.setImage();
    }

    void setImage() {
        String imageName = this.book.getImageName();
        if (imageName != null && imageName.length() > 0) {
            ImageIcon icon = new ImageIcon(imageName);
            Image img = icon.getImage();
            icon.setImage(img.getScaledInstance(180, 180, 4));
            this.imageLabel.setIcon(icon);
        } else {
            this.imageLabel.setIcon(null);
        }
    }

    void clearBook() {
        this.authorText.setText("");
        this.titleText.setText("");
        this.genreCB.setSelectedIndex(-1);
        this.seriesText.setText("");
        this.fileText.setText("");
        this.imageText.setText("");
        this.descriptionText.setText("");
        if (this.book != null) {
            this.book.setImageName("");
            this.setImage();
        }
    }

    void newBook(boolean setAuthor) {
        String authorStr;
        this.clearBook();
        this.backup = this.book;
        this.book = new Book();
        this.book.createGUID();
        this.books.add(this.book);
        this.setEditable(true);
        this.editBT.setVisible(false);
        this.addBT.setVisible(true);
        if (this.books.size() <= 1) {
            this.buttonsOff();
        }
        if (setAuthor && (authorStr = (String)this.authorList.getSelectedValue()) != null && !authorStr.equals("*")) {
            this.authorText.setText(authorStr);
            this.book.setAuthor(authorStr);
        }
        this.authorText.grabFocus();
    }

    void newBook() {
        this.newBook(true);
    }

    void addBook() {
        if (this.book.getAuthor().length() == 0 && this.book.getTitle().length() == 0) {
            if (this.titleModel.size() <= 0) {
                this.authorText.grabFocus();
                return;
            }
            this.cancelEdit();
            return;
        }
        String author = this.book.getAuthor();
        if (!this.authorModel.contains(author)) {
            this.makeAuthorList();
        }
        this.authorList.setSelectedValue(author, true);
        this.setEditable(false);
        this.editBT.setVisible(true);
        this.changes = true;
    }

    void deleteBook() {
        int i = this.titleList.getSelectedIndex();
        int n = this.titleModel.size() - 1;
        Title t = (Title)this.titleList.getSelectedValue();
        this.books.remove(t.pos);
        if (this.books.size() <= 0) {
            this.authorModel.clear();
            this.titleModel.clear();
            this.clearBook();
            this.buttonsOff();
            return;
        }
        this.makeTitleList((String)this.authorList.getSelectedValue());
        if (n > 0) {
            if (i >= n) {
                --i;
            }
            this.titleList.setSelectedIndex(i);
        } else {
            this.makeAuthorList();
            this.makeTitleList("*");
        }
        this.setBook();
        this.changes = true;
    }

    void cancelEdit() {
        if (this.addBT.isVisible()) {
            this.books.remove(this.books.size() - 1);
            this.setBook();
            this.editBT.setVisible(true);
        } else {
            if (this.titleList.getSelectedIndex() < 0) {
                return;
            }
            this.books.set(((Title)this.titleList.getSelectedValue()).pos, this.backup);
            this.editBT.setSelected(false);
        }
        this.setEditable(false);
    }

    void setEditable(boolean editable) {
        if (editable) {
            this.authorText.setEnabled(true);
            this.titleText.setEnabled(true);
            this.genreCB.setEnabled(true);
            this.seriesText.setEnabled(true);
            this.fileBT.setEnabled(true);
            this.fileText.setEnabled(true);
            this.imageBT.setEnabled(true);
            this.imageText.setEnabled(true);
            this.descriptionText.setEnabled(true);
            this.newBT.setVisible(false);
            this.deleteBT.setVisible(false);
            this.eBookBT.setVisible(false);
            this.cancelBT.setVisible(true);
            this.saveBT.setVisible(false);
            this.openBT.setVisible(false);
            this.searchBT.setVisible(false);
            this.searchText.setEnabled(false);
            this.convertBT.setVisible(false);
            this.authorList.setEnabled(false);
            this.titleList.setEnabled(false);
            this.genreCB.addActionListener(this);
            this.editBT.setSelected(true);
            this.authorText.grabFocus();
        } else {
            this.authorText.setEnabled(false);
            this.titleText.setEnabled(false);
            this.genreCB.setEnabled(false);
            this.seriesText.setEnabled(false);
            this.fileBT.setEnabled(false);
            this.fileText.setEnabled(false);
            this.imageBT.setEnabled(false);
            this.imageText.setEnabled(false);
            this.descriptionText.setEnabled(false);
            this.addBT.setVisible(false);
            this.newBT.setVisible(true);
            this.deleteBT.setVisible(true);
            this.eBookBT.setVisible(true);
            this.cancelBT.setVisible(false);
            this.saveBT.setVisible(true);
            this.openBT.setVisible(true);
            this.searchBT.setVisible(true);
            this.searchText.setEnabled(true);
            this.convertBT.setVisible(true);
            this.authorList.setEnabled(true);
            this.titleList.setEnabled(true);
            this.genreCB.removeActionListener(this);
            this.editBT.setSelected(false);
            String author = (String)this.authorList.getSelectedValue();
            if (!author.equals(this.book.getAuthor())) {
                this.makeAuthorList();
                this.authorList.setSelectedValue(this.book.getAuthor(), true);
            }
            this.makeTitleList(this.book.getAuthor(), this.book.getGUID());
            this.changes = true;
        }
    }

    void buttonsOff() {
        this.editBT.setVisible(false);
        this.deleteBT.setVisible(false);
        this.eBookBT.setVisible(false);
        this.cancelBT.setVisible(false);
        this.saveBT.setVisible(false);
    }

    void openBook() {
        if (this.book == null) {
            return;
        }
        LaunchBase view = LaunchViewer.getInstance();
        if (view == null) {
            return;
        }
        Viewer v = null;
        if (this.macOS) {
            if (Viewers.getInstance().size() > 0) {
                v = (Viewer)view.findProgram(this.book);
            }
            if (v == null) {
                v = new Viewer();
                v.setProgram("open");
                v.addArg("%file");
            }
        } else {
            v = (Viewer)view.findProgram(this.book);
        }
        if (v == null) {
            return;
        }
        view.launch(this.book, v);
        if (view.hasErrors()) {
            UIFactory.errorMsg(dialogStr[0], dialogStr[13]);
        }
    }

    void convertBook() {
        if (this.book == null) {
            return;
        }
        LaunchBase conv = LaunchConverter.getInstance();
        if (conv == null) {
            return;
        }
        conv.launch(this.book, conv.findProgram(this.book));
        if (conv.hasErrors()) {
            UIFactory.errorMsg(dialogStr[0], dialogStr[13]);
        }
    }

    void search(String string) {
        if (string.length() == 0) {
            for (Book b : this.books) {
                b.setVisible(true);
            }
        } else {
            string = string.replaceAll(":\\w", ": ");
            string = string.replaceAll("\\s+:", ":");
            String[] tokens = string.split(" +");
            String[] keys = new String[tokens.length];
            String[] vals = new String[tokens.length];
            char[] ops = new char[tokens.length];
            int n = 0;
            boolean isKey = false;
            boolean isOperator = false;
            for (String token : tokens) {
                token = token.trim();
                isKey = token.endsWith(":");
                boolean bl = isOperator = token.startsWith("&") || token.startsWith("|");
                if (!isOperator) {
                    if (isKey) {
                        keys[n] = token.substring(0, token.length() - 1);
                        keys[n] = this.mapKey(keys[n]);
                        continue;
                    }
                    vals[n] = vals[n] == null ? token : vals[n] + " " + token;
                    continue;
                }
                ops[n] = token.charAt(0);
                ++n;
            }
            ++n;
            for (int i = 0; i < n; ++i) {
                if (keys[i] == null || vals[i] == null) {
                    for (int j = i + 1; j < n; ++j) {
                        keys[j - 1] = keys[j];
                        vals[j - 1] = vals[j];
                        ops[j - 1] = ops[j];
                    }
                    --n;
                }
                if (vals[i] == null) continue;
                vals[i] = vals[i].toUpperCase();
            }
            if (n == 0) {
                return;
            }
            for (Book b : this.books) {
                boolean bookMatch = n > 1;
                for (int j = 0; j < n; ++j) {
                    boolean fieldMatch;
                    String searchFor = vals[j];
                    String searchIn = b.get(keys[j]).toUpperCase();
                    int comparison = searchIn.indexOf(searchFor);
                    boolean bl = fieldMatch = comparison >= 0;
                    if (j > 0 && ops[j - 1] > '\u0000') {
                        int k = j - 1;
                        bookMatch = ops[k] == '&' ? bookMatch && fieldMatch : bookMatch || fieldMatch;
                        continue;
                    }
                    bookMatch = fieldMatch;
                }
                b.setVisible(bookMatch);
            }
        }
        this.makeAuthorList();
        this.makeTitleList("*");
    }

    void sendBook() {
        if (this.book == null) {
            return;
        }
        URLClassLoader loader = null;
        try {
            loader = new URLClassLoader(new URL[]{new URL("file:/Users/tommy/src/java/Catalog/src/devs/")});
        }
        catch (Exception e) {
            System.out.println("ClassLoader failed");
        }
        EBook eBook = null;
        GeneralPrefs prefs = GeneralPrefs.getInstance();
        String className = prefs.getPlugIn();
        System.out.println("class: " + className);
        try {
            Class<?> c = loader.loadClass(className);
            eBook = (EBook)c.newInstance();
        }
        catch (ClassNotFoundException e1) {
            System.out.println("Class not found");
        }
        catch (InstantiationException e2) {
            System.out.println("Class can't be instatiated");
        }
        catch (IllegalAccessException e3) {
            System.out.println("Constructor can't be accessed");
        }
        if (eBook == null) {
            return;
        }
        String oldPath = prefs.getPath();
        String newPath = eBook.setPath(oldPath);
        System.out.println(newPath);
        if (newPath != null) {
            if (!newPath.equals(oldPath)) {
                prefs.setPath(newPath);
            }
            eBook.send(this.book);
        }
    }

    void addGenre(String genre) {
        if (genre == null || genre.length() == 0) {
            return;
        }
        this.genreModel.addElement(genre);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.genreModel.getSize(); ++i) {
            list.add((String)this.genreModel.getElementAt(i));
        }
        if (list.size() < 1) {
            return;
        }
        Object[] genres = list.toArray();
        Arrays.sort(genres);
        this.genreModel.removeAllElements();
        for (Object o : genres) {
            this.genreModel.addElement(o);
        }
    }

    String mapKey(String key) {
        if (key == null) {
            return null;
        }
        for (int i = 0; i < Book.keys.length; ++i) {
            if (!key.equalsIgnoreCase(this.keyMapping[i])) continue;
            return Book.keys[i];
        }
        return null;
    }

    void prefs() {
        CatalogPrefs catPrefs = CatalogPrefs.getInstance();
        catPrefs.show();
    }

    void info() {
        String msg = "Catalog 2.0\n\nCopyright (c) 2009 T. Berndt\n\nCatalog is program to take care of your eBooks.\n\nThis program comes with ABSOLUTELY NO WARRANTY.\nIt is free software, and you are welcome to redistribute it.\nCatalog is shipped under the terms and conditions of the GPL.\n\n";
        JOptionPane.showMessageDialog(this.window, "Catalog 2.0\n\nCopyright (c) 2009 T. Berndt\n\nCatalog is program to take care of your eBooks.\n\nThis program comes with ABSOLUTELY NO WARRANTY.\nIt is free software, and you are welcome to redistribute it.\nCatalog is shipped under the terms and conditions of the GPL.\n\n", "Info", 1);
    }

    void exit() {
        Object[] options;
        if (this.changes && JOptionPane.showOptionDialog(this.window, dialogStr[16], dialogStr[12], 0, 3, null, options = new String[]{labels[22], labels[21]}, options[1]) == 1) {
            this.saveBooks();
        }
        System.exit(0);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(Book.keys[1])) {
            this.titleText.grabFocus();
        } else if (cmd.equals(Book.keys[2])) {
            this.genreCB.grabFocus();
        } else if (cmd.equals(Book.keys[3])) {
            String genre = (String)this.genreCB.getSelectedItem();
            if (this.genreCB.getSelectedIndex() == -1) {
                this.addGenre(genre);
                this.genreModel.setSelectedItem(genre);
            }
            this.book.setGenre(genre);
            this.seriesText.grabFocus();
        } else if (cmd.equals(Book.keys[4])) {
            this.fileText.grabFocus();
        } else if (cmd.equals(Book.keys[5])) {
            this.imageText.grabFocus();
        } else if (cmd.equals(Book.keys[6])) {
            this.descriptionText.grabFocus();
        } else if (cmd.equals("BT:" + labels[8])) {
            if (this.fc.getFileName(this.window, this.fileText, dialogStr[9])) {
                this.book.setFileName(this.fileText.getText());
            }
        } else if (cmd.equals("BT:" + labels[9])) {
            if (this.fc.getFileName(this.window, this.imageText, dialogStr[10])) {
                this.book.setImageName(this.imageText.getText());
                this.setImage();
            }
        } else if (cmd.equals("BT:" + labels[11])) {
            this.newBook();
        } else if (cmd.equals("BT:" + labels[12])) {
            this.addBook();
            this.titleList.grabFocus();
        } else if (cmd.equals("BT:" + labels[13])) {
            this.saveBooks();
            this.titleList.grabFocus();
        } else if (cmd.equals("BT:" + labels[14])) {
            this.deleteBook();
            this.titleList.grabFocus();
        } else if (cmd.equals("BT:" + labels[15])) {
            this.sendBook();
            this.titleList.grabFocus();
        } else if (cmd.equals("BT:" + labels[16])) {
            this.backup = this.book.clone();
            this.setEditable(this.editBT.isSelected());
        } else if (cmd.equals("BT:" + labels[17])) {
            this.cancelEdit();
            this.titleList.grabFocus();
        } else if (cmd.equals("BT:" + labels[18])) {
            this.openBook();
            this.titleList.grabFocus();
        } else if (cmd.equals("BT:" + labels[19])) {
            boolean searchState = this.searchBT.isSelected();
            this.searchText.setVisible(searchState);
            this.window.validate();
            if (searchState) {
                this.searchText.grabFocus();
            } else {
                this.search("");
            }
        } else if (cmd.equals("TF:" + labels[19])) {
            this.search(this.searchText.getText());
        } else if (cmd.equals("BT:" + labels[20])) {
            this.convertBook();
            this.titleList.grabFocus();
        } else if (cmd.equals("MI:" + labels[23])) {
            this.prefs();
            this.titleList.grabFocus();
        } else if (cmd.equals("MI:" + labels[24])) {
            this.info();
            this.titleList.grabFocus();
        } else if (cmd.equals("MI:" + labels[25])) {
            Docu.getInstance().show();
            this.titleList.grabFocus();
        } else if (cmd.equals("MI:" + labels[26])) {
            this.exit();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getClickCount() < 1) {
            return;
        }
        Object uiEl = e.getSource();
        if (uiEl == this.authorList) {
            this.makeTitleList((String)this.authorList.getSelectedValue());
        } else if (uiEl == this.titleList) {
            this.setBook();
            if (e.getClickCount() > 1) {
                this.openBook();
            }
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        Object uiEl = e.getSource();
        if (uiEl == this.authorText) {
            this.book.setAuthor(this.authorText.getText());
        } else if (uiEl == this.titleText) {
            this.book.setTitle(this.titleText.getText());
        } else if (uiEl == this.seriesText) {
            this.book.setSeries(this.seriesText.getText());
        } else if (uiEl == this.fileText) {
            this.book.setFileName(this.fileText.getText());
        } else if (uiEl == this.imageText) {
            this.book.setImageName(this.imageText.getText());
            this.setImage();
        } else if (uiEl == this.descriptionText) {
            this.book.setDescription(this.descriptionText.getText());
        } else if (uiEl == this.authorList) {
            this.makeTitleList((String)this.authorList.getSelectedValue());
            this.authorList.grabFocus();
        } else if (uiEl == this.titleList) {
            this.setBook();
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.exit();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void dragEnter(DropTargetDragEvent e) {
    }

    public void dragExit(DropTargetEvent e) {
    }

    public void dragOver(DropTargetDragEvent e) {
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void drop(DropTargetDropEvent e) {
        block16: {
            Component src;
            Object[] options;
            String file;
            List fileList;
            block14: {
                block15: {
                    File f;
                    fileList = null;
                    try {
                        Transferable tr = e.getTransferable();
                        for (DataFlavor dataFlavor : tr.getTransferDataFlavors()) {
                            if (!dataFlavor.isFlavorJavaFileListType()) continue;
                            e.acceptDrop(3);
                            fileList = (List)tr.getTransferData(dataFlavor);
                            e.dropComplete(true);
                            break;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        e.rejectDrop();
                        return;
                    }
                    file = "";
                    options = new String[]{labels[17], labels[12]};
                    src = ((DropTarget)e.getSource()).getComponent();
                    if (!this.editBT.isSelected()) break block14;
                    if (fileList.size() > 1) {
                        System.out.println("Only one file expected and thus accepted");
                    }
                    if ((f = (File)fileList.get(0)).isDirectory()) {
                        return;
                    }
                    try {
                        file = f.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (file == null || file.length() == 0) {
                        return;
                    }
                    if (src != this.imageText && src != this.imageLabel) break block15;
                    this.imageText.setText(file);
                    this.book.setImageName(file);
                    this.setImage();
                    break block16;
                }
                if (src != this.fileText) break block16;
                this.fileText.setText(file);
                this.book.setFileName(file);
                break block16;
            }
            if (src != this.authorList && src != this.titleList) {
                return;
            }
            for (int i = 0; i < fileList.size(); ++i) {
                File file2 = (File)fileList.get(i);
                if (file2.isDirectory()) continue;
                try {
                    file = file2.getCanonicalPath();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                if (file == null || file.length() == 0) continue;
                this.newBook(false);
                ToolBox.provideMetaData(this.book, file);
                this.authorText.setText(this.book.getAuthor());
                this.titleText.setText(this.book.getTitle());
                this.seriesText.setText(this.book.getSeries());
                this.fileText.setText(this.book.getFileName());
                if (fileList.size() <= 1) continue;
                if (JOptionPane.showOptionDialog(this.window, dialogStr[15] + "\n\n" + labels[4] + ": '" + this.book.getAuthor() + "'" + "\n" + labels[5] + ": '" + this.book.getTitle() + "'", dialogStr[12], 0, 3, null, options, options[1]) == 1) {
                    this.addBook();
                    continue;
                }
                this.cancelEdit();
            }
        }
    }

    class Title
    implements Comparable {
        public String guid;
        public String title;
        public String series;
        public int pos;

        Title(String g, String t, String s, int i) {
            this.guid = g;
            this.title = t;
            this.series = s;
            this.pos = i;
        }

        public int compareTo(Object o) {
            Title other = (Title)o;
            return (this.series + ":" + this.title).compareTo(other.series + ":" + other.title);
        }

        public String toString() {
            return this.title;
        }
    }
}

