/*
 * Decompiled with CFR 0.152.
 */
package Catalog;

import Catalog.Book;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Books
extends ArrayList<Book> {
    private static final String VERSION = "0.2";
    public static final String fileName = "books.dat";
    private static Books instance = null;

    private Books() {
    }

    public static Books getInstance() {
        if (instance == null) {
            instance = new Books();
        }
        return instance;
    }

    public boolean load() {
        this.clear();
        try {
            Book book;
            File file = new File(fileName);
            if (!file.exists()) {
                return true;
            }
            BufferedReader f = new BufferedReader(new FileReader(file));
            while (f.ready() && (book = new Book()).read(f)) {
                this.add(book);
            }
            f.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "ERROR loading book:\n" + this.get(this.size() - 1), "Error", 0);
            return false;
        }
        return true;
    }

    public boolean save() {
        try {
            BufferedWriter f = new BufferedWriter(new FileWriter(fileName));
            for (Book b : this) {
                b.write(f);
            }
            f.close();
        }
        catch (IOException e) {
            System.err.println();
            JOptionPane.showMessageDialog(null, "ERROR saving a book\nEXCEPTION:\n" + e, "Error", 0);
            return false;
        }
        return true;
    }
}

