/*
 * Decompiled with CFR 0.152.
 */
package Catalog;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class Book
implements Comparable {
    private static final String VERSION = "0.4";
    String guid = null;
    String author = "";
    String title = "";
    String genre = "";
    String series = "";
    String file = "";
    String image = "";
    String description = "";
    boolean visible = true;
    public static final String[] keys = new String[]{"BOOK::GUID", "BOOK::AUTHOR", "BOOK::TITLE", "BOOK::GENRE", "BOOK::SERIES", "BOOK::FILE", "BOOK::IMAGE", "BOOK::DESCRIPTION"};

    public void createGUID() {
        if (this.guid != null) {
            return;
        }
        String zero = "00000000";
        String hashCode = "" + this.hashCode();
        int l = 10 - hashCode.length();
        String s = zero.substring(0, l) + hashCode;
        this.guid = s + "." + System.currentTimeMillis();
    }

    public String getGUID() {
        return this.guid;
    }

    public void setGUID(String s) {
        this.guid = s;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String s) {
        this.author = s;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String s) {
        this.title = s;
    }

    public String getGenre() {
        return this.genre;
    }

    public void setGenre(String s) {
        this.genre = s;
    }

    public String getSeries() {
        return this.series;
    }

    public void setSeries(String s) {
        this.series = s;
    }

    public String getFileName() {
        return this.file;
    }

    public void setFileName(String s) {
        this.file = s;
    }

    public String getImageName() {
        return this.image;
    }

    public void setImageName(String s) {
        this.image = s;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String s) {
        this.description = s;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean v) {
        this.visible = v;
    }

    public String get(String key) {
        if (key.equals(keys[0])) {
            return this.getGUID();
        }
        if (key.equals(keys[1])) {
            return this.getAuthor();
        }
        if (key.equals(keys[2])) {
            return this.getTitle();
        }
        if (key.equals(keys[3])) {
            return this.getGenre();
        }
        if (key.equals(keys[4])) {
            return this.getSeries();
        }
        if (key.equals(keys[5])) {
            return this.getFileName();
        }
        if (key.equals(keys[6])) {
            return this.getImageName();
        }
        if (key.equals(keys[7])) {
            return this.getDescription();
        }
        return null;
    }

    public void set(String key, String s) {
        if (key.equals(keys[0])) {
            this.setGUID(s);
        } else if (key.equals(keys[1])) {
            this.setAuthor(s);
        } else if (key.equals(keys[2])) {
            this.setTitle(s);
        } else if (key.equals(keys[3])) {
            this.setGenre(s);
        } else if (key.equals(keys[4])) {
            this.setSeries(s);
        } else if (key.equals(keys[5])) {
            this.setFileName(s);
        } else if (key.equals(keys[6])) {
            this.setImageName(s);
        } else if (key.equals(keys[7])) {
            this.setDescription(s);
        }
    }

    public boolean read(BufferedReader f) throws IOException {
        for (String key : keys) {
            this.set(key, f.readLine().trim());
        }
        StringBuffer buffer = new StringBuffer();
        String line = this.getDescription();
        while (!line.equals("<<<END")) {
            if (line.length() > 0) {
                buffer.append(line + "\n");
            }
            line = f.readLine().trim();
        }
        this.setDescription(buffer.toString());
        return this.guid.length() != 0;
    }

    public void write(BufferedWriter f) throws IOException {
        for (String key : keys) {
            f.write(this.get(key));
            f.newLine();
        }
        f.write("<<<END");
        f.newLine();
    }

    public Book clone() {
        Book b = new Book();
        for (String key : keys) {
            b.set(key, this.get(key));
        }
        return b;
    }

    public String toString() {
        return "\nguid        : " + this.guid + "\nauthor      : " + this.author + "\ntitle       : " + this.title + "\ngenre       : " + this.genre + "\nseries      : " + this.series + "\nfile        : " + this.file + "\nimage       : " + this.image + "\ndescription : " + this.description;
    }

    public int compareTo(Object o) {
        Book other = (Book)o;
        return (this.series + ":" + this.title).compareTo(other.getSeries() + ":" + other.getTitle());
    }
}

