/*
 * Decompiled with CFR 0.152.
 */
package Catalog;

import Catalog.Book;
import Catalog.Books;
import Catalog.util.ToolBox;
import Catalog.util.UIFactory;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class AddBooks
implements ActionListener {
    Books books = null;
    File path = null;
    FileFilter fileFilter = null;
    ArrayList<Candidate> candidates = null;
    ArrayList<File> files = null;
    ArrayList<String> oldNames = null;
    ArrayList<String> newNames = null;
    String[] suffix = new String[]{".doc", ".htm", ".html", ".pdf", ".rtf", ".txt", ".lit", ".mobi", ".prc", ".epub"};
    JButton saveBT;
    boolean moved = false;
    JTable candidateTable;

    public static void main(String[] args) {
        AddBooks adder = new AddBooks(args);
        adder.getData();
        adder.initGUI();
    }

    AddBooks(String[] args) {
        this.fileFilter = new DocFilter();
        this.files = new ArrayList();
        this.oldNames = new ArrayList();
        this.newNames = new ArrayList();
        this.candidates = new ArrayList();
        this.books = Books.getInstance();
        this.books.load();
        String pathStr = ".";
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-p") || args[i + 1] == null) continue;
            pathStr = args[i + 1];
        }
        this.path = new File(pathStr);
        if (!this.path.isDirectory()) {
            this.path = new File(this.path.getAbsolutePath());
            this.path = new File(this.path.getParent());
        }
    }

    void getData() {
        this.process(this.getFiles(this.path));
        Iterator<File> i = this.files.iterator();
        while (i.hasNext()) {
            File f = i.next();
            String fullName = f.getAbsolutePath();
            String line = f.getName();
            String author = "";
            String title = "";
            String series = "";
            String fileName = "";
            int start = -1;
            int stop = -1;
            int pos = -1;
            i.remove();
            stop = line.indexOf("-");
            if (stop != -1) {
                author = line.substring(0, stop).trim();
            }
            if ((start = line.lastIndexOf("-", (stop = line.lastIndexOf(".", line.length())) - 1)) == -1) {
                start = pos;
            }
            title = line.substring(start + 1, stop).trim();
            start = line.indexOf("-");
            stop = line.lastIndexOf("-");
            if (start != -1 && stop != -1 && stop > start) {
                series = line.substring(start + 1, stop).trim();
            }
            if (author.length() == 0) {
                start = stop = fullName.lastIndexOf(File.separator);
                start = fullName.lastIndexOf(File.separator, stop - 1);
                if (start != -1 && stop != -1 && stop > start) {
                    author = fullName.substring(start + 1, stop).trim();
                }
            }
            if (this.exists(author, title)) continue;
            Candidate candidate = new Candidate();
            candidate.createGUID();
            candidate.setAuthor(author);
            candidate.setTitle(title);
            candidate.setSeries(series);
            candidate.setPath(this.guessPath(author));
            candidate.setFileName(fullName);
            candidate.setInclude(candidate.path.length() > 0);
            this.candidates.add(candidate);
        }
        this.files.clear();
    }

    void process(ArrayList<File> list) {
        this.processFiles(list);
        this.processFolders(list);
    }

    void processFiles(ArrayList<File> list) {
        Iterator<File> i = list.iterator();
        while (i.hasNext()) {
            File f = i.next();
            if (f.isDirectory()) continue;
            this.files.add(f);
            i.remove();
        }
    }

    void processFolders(ArrayList<File> list) {
        Iterator<File> i = list.iterator();
        while (i.hasNext()) {
            File f = i.next();
            if (f.isDirectory()) {
                this.process(this.getFiles(f));
            }
            i.remove();
        }
    }

    boolean exists(String author, String title) {
        for (Book b : this.books) {
            if (!author.equals(b.getAuthor()) || !title.equals(b.getTitle())) continue;
            return true;
        }
        return false;
    }

    String guessPath(String author) {
        for (Book book : this.books) {
            String a = null;
            String b = null;
            int l = 0;
            boolean match = false;
            if (author.length() < book.getAuthor().length()) {
                a = author;
                b = book.getAuthor();
            } else {
                a = book.getAuthor();
                b = author;
            }
            if (!(match = a.equals((b = b.substring(0, l = a.length())).substring(0, l)))) continue;
            String name = book.getFileName();
            if (name == null || name.length() == 0) {
                return "";
            }
            int startPos = name.lastIndexOf(File.separator);
            if (startPos < 0) {
                return "";
            }
            return name.substring(0, startPos);
        }
        return "";
    }

    String replacePath(Candidate c) {
        File f = new File(c.getFileName());
        return c.getPath() + f.getName();
    }

    ArrayList<File> getFiles(File folder) {
        File[] files = folder.listFiles(this.fileFilter);
        ArrayList<File> list = new ArrayList<File>(files.length);
        for (File f : files) {
            list.add(f);
        }
        return list;
    }

    void initGUI() {
        JButton okBT = UIFactory.newButton("OK", "CMD::OK", 'o', this);
        this.saveBT = UIFactory.newButton("Save", "CMD::SAVE", 's', this);
        this.saveBT.setEnabled(false);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okBT);
        buttonPanel.add(this.saveBT);
        CandidateModel candidateModel = new CandidateModel();
        this.candidateTable = new JTable(candidateModel);
        this.candidateTable.setSelectionMode(2);
        this.candidateTable.setColumnSelectionAllowed(true);
        candidateModel.setTable(this.candidateTable);
        for (int i = 0; i < 6; ++i) {
            TableColumn column = this.candidateTable.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setPreferredWidth(75);
                continue;
            }
            if (i == 1 || i == 2 || i == 3) {
                column.setPreferredWidth(250);
                continue;
            }
            if (i == 4) {
                column.setPreferredWidth(400);
                continue;
            }
            column.setPreferredWidth(600);
        }
        BookModel bookModel = new BookModel();
        JTable bookTable = new JTable(bookModel);
        bookTable.setAutoCreateRowSorter(true);
        bookTable.setRowHeight(60);
        bookModel.setTable(bookTable);
        for (int i = 0; i < 5; ++i) {
            TableColumn column = bookTable.getColumnModel().getColumn(i);
            if (i == 0 || i == 1 || i == 2) {
                column.setPreferredWidth(400);
                continue;
            }
            if (i == 3) {
                column.setPreferredWidth(180);
                continue;
            }
            column.setPreferredWidth(600);
        }
        JTabbedPane tabPane = new JTabbedPane();
        tabPane.add("Candidates", new JScrollPane(this.candidateTable));
        tabPane.add("Books", new JScrollPane(bookTable));
        JFrame window = new JFrame("AddBooks");
        window.add(tabPane);
        window.add((Component)buttonPanel, "South");
        window.setDefaultCloseOperation(3);
        window.pack();
        window.validate();
        window.setSize(1200, 800);
        window.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("CMD::OK")) {
            Iterator<Candidate> i = this.candidates.iterator();
            while (i.hasNext()) {
                Candidate c = i.next();
                if (!c.getInclude()) continue;
                this.oldNames.add(c.getFileName());
                c.setFileName(this.replacePath(c));
                this.newNames.add(c.getFileName());
                this.books.add(c);
                i.remove();
                this.moved = true;
            }
            if (this.moved) {
                this.saveBT.setEnabled(true);
                this.candidateTable.repaint();
            }
        } else if (cmd.equals("CMD::SAVE")) {
            for (int i = 0; i < this.oldNames.size(); ++i) {
                ToolBox.move(this.oldNames.get(i), this.newNames.get(i));
            }
            this.oldNames.clear();
            this.newNames.clear();
            this.books.save();
        }
    }

    class TableBook
    extends Book {
        TableBook(Book b) {
            this.guid = b.guid;
            this.author = b.author;
            this.title = b.title;
            this.genre = b.genre;
            this.series = b.series;
            this.file = b.file;
            this.image = b.image;
        }

        ImageIcon getImage() {
            String image = this.getImageName();
            if (image != null && image.length() > 0) {
                ImageIcon icon = new ImageIcon(image);
                Image img = icon.getImage();
                icon.setImage(img.getScaledInstance(60, 60, 4));
                return icon;
            }
            return new ImageIcon();
        }

        Object getColumn(int i) {
            switch (i) {
                case 0: {
                    return this.author;
                }
                case 1: {
                    return this.title;
                }
                case 2: {
                    return this.series;
                }
                case 3: {
                    return this.getImage();
                }
                case 4: {
                    return this.file;
                }
            }
            throw new RuntimeException("no such column " + i);
        }
    }

    class BookModel
    extends AbstractTableModel {
        private String[] colNames = new String[]{"Author", "Title", "Series", "Image", "File"};
        private JTable table;

        BookModel() {
        }

        @Override
        public int getColumnCount() {
            return this.colNames.length;
        }

        @Override
        public int getRowCount() {
            return AddBooks.this.books.size();
        }

        @Override
        public String getColumnName(int j) {
            return this.colNames[j];
        }

        @Override
        public Object getValueAt(int i, int j) {
            return new TableBook((Book)AddBooks.this.books.get(i)).getColumn(j);
        }

        @Override
        public Class<?> getColumnClass(int j) {
            return this.getValueAt(0, j).getClass();
        }

        @Override
        public boolean isCellEditable(int i, int j) {
            return true;
        }

        public void setTable(JTable t) {
            this.table = t;
        }

        public JTable getTable() {
            return this.table;
        }

        @Override
        public void setValueAt(Object value, int i, int j) {
        }
    }

    class Candidate
    extends Book {
        boolean include = false;
        String path = "";

        Candidate() {
        }

        public void setInclude(boolean b) {
            this.include = b;
        }

        public boolean getInclude() {
            return this.include;
        }

        public void setPath(String s) {
            this.path = s;
        }

        public String getPath() {
            if (this.path.length() == 0) {
                return "";
            }
            return this.path + (this.path.charAt(this.path.length() - 1) != File.separatorChar ? File.separator : "");
        }

        Object getColumn(int i) {
            switch (i) {
                case 0: {
                    return this.include;
                }
                case 1: {
                    return this.author;
                }
                case 2: {
                    return this.title;
                }
                case 3: {
                    return this.series;
                }
                case 4: {
                    return this.path;
                }
                case 5: {
                    return this.file;
                }
            }
            throw new RuntimeException("no such column " + i);
        }
    }

    class CandidateModel
    extends AbstractTableModel {
        private String[] colNames = new String[]{"Include", "Author", "Title", "Series", "Path", "Original"};
        private JTable table;

        CandidateModel() {
        }

        @Override
        public int getColumnCount() {
            return this.colNames.length;
        }

        @Override
        public int getRowCount() {
            return AddBooks.this.candidates.size();
        }

        @Override
        public String getColumnName(int j) {
            return this.colNames[j];
        }

        @Override
        public Object getValueAt(int i, int j) {
            return AddBooks.this.candidates.get(i).getColumn(j);
        }

        @Override
        public Class<?> getColumnClass(int j) {
            return this.getValueAt(0, j).getClass();
        }

        @Override
        public boolean isCellEditable(int i, int j) {
            return true;
        }

        public void setTable(JTable t) {
            this.table = t;
        }

        public JTable getTable() {
            return this.table;
        }

        @Override
        public void setValueAt(Object value, int i, int j) {
            int[] rows;
            for (int k : rows = this.table.getSelectedRows()) {
                Candidate c = AddBooks.this.candidates.get(k);
                if (j == 0) {
                    c.setInclude(c.path.length() > 0 ? (Boolean)value : false);
                    continue;
                }
                if (j == 1) {
                    c.setAuthor((String)value);
                    c.setPath(AddBooks.this.guessPath(c.getAuthor()));
                    continue;
                }
                if (j == 2) {
                    c.setTitle((String)value);
                    continue;
                }
                if (j == 3) {
                    c.setSeries((String)value);
                    continue;
                }
                if (j != 4) continue;
                c.setPath((String)value);
            }
            if (j == 1 || j == 2) {
                Iterator<Candidate> k = AddBooks.this.candidates.iterator();
                while (k.hasNext()) {
                    Candidate c = k.next();
                    if (!AddBooks.this.exists(c.getAuthor(), c.getTitle())) continue;
                    k.remove();
                }
                this.fireTableDataChanged();
            }
        }
    }

    class DocFilter
    implements FileFilter {
        DocFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            for (String s : AddBooks.this.suffix) {
                if (!f.getName().endsWith(s)) continue;
                return true;
            }
            return false;
        }
    }
}

